/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.note.banks.bocom.dc.service.note.receivable.discount;

import java.util.Date;
import java.util.List;
import kd.bos.dataentity.resource.ResManager;
import kd.ebg.egf.common.context.EBContext;
import kd.ebg.egf.common.context.RequestContextUtils;
import kd.ebg.egf.common.framework.bank.info.BankResponse;
import kd.ebg.egf.common.utils.datetime.DateUtil;
import kd.ebg.egf.common.utils.string.StringUtils;
import kd.ebg.egf.common.utils.xml.JDomUtils;
import kd.ebg.note.banks.bocom.dc.service.note.receivable.discount.QueryDiscountNoteReceivableImpl;
import kd.ebg.note.banks.bocom.dc.service.note.util.BOCOM_DC_NotePacker;
import kd.ebg.note.banks.bocom.dc.service.note.util.BOCOM_DC_Parser;
import kd.ebg.note.business.SameBankUtil;
import kd.ebg.note.business.noteReceivable.atomic.AbstractNoteReceivableImpl;
import kd.ebg.note.business.noteReceivable.atomic.IQueryNoteReceivable;
import kd.ebg.note.business.noteReceivable.bank.BankNoteReceivableRequest;
import kd.ebg.note.business.noteReceivable.util.EBGNoteReceivableUtils;
import kd.ebg.note.common.entity.biz.status.PaymentState;
import kd.ebg.note.common.model.NoteReceivableInfo;
import org.jdom2.Element;

public class DiscountNoteReceivableImpl
extends AbstractNoteReceivableImpl {
    public long getBankInterval() {
        return 0L;
    }

    public int getBatchSize() {
        return 1;
    }

    public Class<? extends IQueryNoteReceivable> defaultQueryClass() {
        return QueryDiscountNoteReceivableImpl.class;
    }

    public String getDeveloper() {
        return "";
    }

    public String getBizCode() {
        return "420303";
    }

    public String getBizDesc() {
        return ResManager.loadKDString((String)"\u6536\u7968\u5904\u7406-\u7968\u636e\u8d34\u73b0\uff08420303\uff09", (String)"DiscountNoteReceivableImpl_0", (String)"ebg-note-banks-bocom-dc", (Object[])new Object[0]);
    }

    public boolean match(NoteReceivableInfo noteReceivableInfo) {
        return true;
    }

    public String pack(BankNoteReceivableRequest request, String pageTag) {
        List noteReceivableInfos = request.getNoteReceivableInfos();
        NoteReceivableInfo receivableInfo = (NoteReceivableInfo)noteReceivableInfos.get(0);
        Element root = BOCOM_DC_NotePacker.packRootForNote("420303", receivableInfo.getBankDetailSeqId());
        Element body = JDomUtils.addChild((Element)root, (String)"body");
        JDomUtils.addChild((Element)body, (String)"QryAcct", (String)receivableInfo.getDrawerAccNo());
        JDomUtils.addChild((Element)body, (String)"IdNb", (String)receivableInfo.getBillNo());
        boolean isSameBank = false;
        if (receivableInfo.getAcceptorBankName() != null && SameBankUtil.isSameBank((String)EBContext.getContext().getBankVersionID(), (String)receivableInfo.getAcceptorBankName()).equals("1")) {
            isSameBank = true;
        }
        boolean isSameBankPayee = false;
        if (receivableInfo.getPayeeBankName() != null && SameBankUtil.isSameBank((String)EBContext.getContext().getBankVersionID(), (String)receivableInfo.getPayeeBankName()).equals("1")) {
            isSameBankPayee = true;
        }
        JDomUtils.addChild((Element)body, (String)"BankFlg1", (String)(isSameBankPayee ? "0" : "1"));
        JDomUtils.addChild((Element)body, (String)"BankFlg2", (String)(isSameBank ? "0" : "1"));
        JDomUtils.addChild((Element)body, (String)"DscntBkNm", (String)receivableInfo.getPayeeBankName());
        JDomUtils.addChild((Element)body, (String)"DscntBkAcctSvcr", (String)receivableInfo.getPayeeBankCnaps());
        JDomUtils.addChild((Element)body, (String)"DscntBkAcctId", (String)receivableInfo.getPayeeAccNo());
        JDomUtils.addChild((Element)body, (String)"AcctId", (String)receivableInfo.getAcceptorAccNo());
        JDomUtils.addChild((Element)body, (String)"RpdMk", (String)"RM00");
        String signDate4Test = RequestContextUtils.getParameter().getBankParameter("signDate4Test");
        boolean isProduct = StringUtils.isEmpty((String)signDate4Test);
        if (isProduct) {
            JDomUtils.addChild((Element)body, (String)"DsAppDt", (String)DateUtil.formatDate((Date)new Date()));
        } else {
            JDomUtils.addChild((Element)body, (String)"DsAppDt", (String)signDate4Test);
        }
        Double rate = Double.parseDouble(receivableInfo.getDisCountRate()) / 100.0;
        JDomUtils.addChild((Element)body, (String)"IntrstRate", (String)rate.toString());
        JDomUtils.addChild((Element)body, (String)"Amt", (String)receivableInfo.getDisCountAmount());
        JDomUtils.addChild((Element)body, (String)"BanEndrsmtMk", (String)receivableInfo.getTransferFlag());
        if ("0".equals(receivableInfo.getAutoAccept()) && !isSameBankPayee || "0".equals(receivableInfo.getAutoAccept()) && isSameBank) {
            JDomUtils.addChild((Element)body, (String)"SttlmMk", (String)"SM00");
        } else {
            JDomUtils.addChild((Element)body, (String)"SttlmMk", (String)"SM01");
        }
        JDomUtils.addChild((Element)body, (String)"RpdOpenDt", (String)"");
        JDomUtils.addChild((Element)body, (String)"RpdDueDt", (String)"");
        JDomUtils.addChild((Element)body, (String)"RpdIntrstRate", (String)"");
        JDomUtils.addChild((Element)body, (String)"RpdAmt", (String)"");
        JDomUtils.addChild((Element)body, (String)"TxlCtrctNb", (String)"");
        JDomUtils.addChild((Element)body, (String)"InvcNb", (String)"");
        JDomUtils.addChild((Element)body, (String)"RmrkByPropsr", (String)receivableInfo.getExplanation());
        String encoding = RequestContextUtils.getCharset();
        return JDomUtils.root2StringWithoutXMLDeclaration((Element)root, (String)encoding);
    }

    public List<NoteReceivableInfo> parse(BankNoteReceivableRequest request, String responseStr) {
        List noteReceivableInfos = request.getNoteReceivableInfos();
        String encoding = RequestContextUtils.getCharset();
        Element ap = JDomUtils.string2Root((String)responseStr, (String)encoding);
        BankResponse rsp = BOCOM_DC_Parser.parseRoot(ap);
        if ("0000".equals(rsp.getResponseCode())) {
            EBGNoteReceivableUtils.setPaymentState((List)noteReceivableInfos, (PaymentState)PaymentState.SUBMITED, (String)rsp.getResponseCode(), (String)rsp.getResponseMessage());
        } else if ("9157".equals(rsp.getResponseCode()) || "9150".equals(rsp.getResponseCode()) || "9151".equals(rsp.getResponseCode()) || "9292".equals(rsp.getResponseCode())) {
            EBGNoteReceivableUtils.setPaymentState((List)noteReceivableInfos, (PaymentState)PaymentState.FAIL, (String)rsp.getResponseCode(), (String)rsp.getResponseMessage());
        } else {
            EBGNoteReceivableUtils.setPaymentState((List)noteReceivableInfos, (PaymentState)PaymentState.UNKNOWN, (String)ResManager.loadKDString((String)"\u94f6\u884c\u8fd4\u56de\u975e\u6b63\u5e38\u72b6\u6001\u7801\uff0c\u9700\u8981\u4eba\u5de5\u786e\u8ba4\u4ea4\u6613\u72b6\u6001\u3002", (String)"DiscountNoteReceivableImpl_4", (String)"ebg-note-banks-bocom-dc", (Object[])new Object[0]), (String)rsp.getResponseCode(), (String)rsp.getResponseMessage());
        }
        Element head = ap.getChild("head");
        String req_no = head.getChildTextTrim("req_no");
        ((NoteReceivableInfo)noteReceivableInfos.get(0)).setRspserialno(req_no);
        return noteReceivableInfos;
    }
}

