/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.note.banks.bocom.dc.service.note.receivable.endorse;

import java.util.List;
import kd.bos.dataentity.resource.ResManager;
import kd.ebg.egf.common.context.EBContext;
import kd.ebg.egf.common.context.RequestContextUtils;
import kd.ebg.egf.common.framework.bank.info.BankResponse;
import kd.ebg.egf.common.log.EBGLogger;
import kd.ebg.egf.common.utils.xml.JDomUtils;
import kd.ebg.note.banks.bocom.dc.service.note.receivable.endorse.QueryEndorseNoteReceivableImpl;
import kd.ebg.note.banks.bocom.dc.service.note.util.BOCOM_DC_NotePacker;
import kd.ebg.note.banks.bocom.dc.service.note.util.BOCOM_DC_Parser;
import kd.ebg.note.business.SameBankUtil;
import kd.ebg.note.business.noteReceivable.atomic.AbstractNoteReceivableImpl;
import kd.ebg.note.business.noteReceivable.atomic.IQueryNoteReceivable;
import kd.ebg.note.business.noteReceivable.bank.BankNoteReceivableRequest;
import kd.ebg.note.business.noteReceivable.util.EBGNoteReceivableUtils;
import kd.ebg.note.common.entity.biz.status.PaymentState;
import kd.ebg.note.common.model.NoteReceivableInfo;
import org.jdom2.Element;

public class EndorseNoteReceivableImpl
extends AbstractNoteReceivableImpl {
    private EBGLogger logger = EBGLogger.getInstance().getLogger(EndorseNoteReceivableImpl.class);

    public long getBankInterval() {
        return 0L;
    }

    public int getBatchSize() {
        return 1;
    }

    public Class<? extends IQueryNoteReceivable> defaultQueryClass() {
        return QueryEndorseNoteReceivableImpl.class;
    }

    public String getDeveloper() {
        return "";
    }

    public String getBizCode() {
        return "420302";
    }

    public String getBizDesc() {
        return ResManager.loadKDString((String)"\u6536\u7968\u5904\u7406-\u7968\u636e\u80cc\u4e66\uff08420302\uff09", (String)"EndorseNoteReceivableImpl_0", (String)"ebg-note-banks-bocom-dc", (Object[])new Object[0]);
    }

    public boolean match(NoteReceivableInfo noteReceivableInfo) {
        return true;
    }

    public String pack(BankNoteReceivableRequest request, String pageTag) {
        List noteReceivableInfos = request.getNoteReceivableInfos();
        NoteReceivableInfo receivableInfo = (NoteReceivableInfo)noteReceivableInfos.get(0);
        Element root = BOCOM_DC_NotePacker.packRootForNote("420302", receivableInfo.getBankDetailSeqId());
        Element body = JDomUtils.addChild((Element)root, (String)"body");
        JDomUtils.addChild((Element)body, (String)"QryAcct", (String)receivableInfo.getDrawerAccNo());
        JDomUtils.addChild((Element)body, (String)"IdNb", (String)receivableInfo.getBillNo());
        JDomUtils.addChild((Element)body, (String)"BanEndrsmtMk", (String)receivableInfo.getTransferFlag());
        JDomUtils.addChild((Element)body, (String)"RmrkByPropsr", (String)receivableInfo.getExplanation());
        boolean isSameBank = false;
        if (receivableInfo.getPayeeBankName() != null && SameBankUtil.isSameBank((String)EBContext.getContext().getBankVersionID(), (String)receivableInfo.getPayeeBankName()).equals("1")) {
            isSameBank = true;
        }
        JDomUtils.addChild((Element)body, (String)"EeBankFlg", (String)(isSameBank ? "0" : "1"));
        JDomUtils.addChild((Element)body, (String)"EeNm", (String)receivableInfo.getPayeeAccName());
        JDomUtils.addChild((Element)body, (String)"EeAcctId", (String)receivableInfo.getPayeeAccNo());
        JDomUtils.addChild((Element)body, (String)"EeAcctSvcr", (String)receivableInfo.getPayeeBankCnaps());
        String encoding = RequestContextUtils.getCharset();
        return JDomUtils.root2StringWithoutXMLDeclaration((Element)root, (String)encoding);
    }

    public List<NoteReceivableInfo> parse(BankNoteReceivableRequest request, String responseStr) {
        List noteReceivableInfos = request.getNoteReceivableInfos();
        String encoding = RequestContextUtils.getCharset();
        Element ap = JDomUtils.string2Root((String)responseStr, (String)encoding);
        BankResponse rsp = BOCOM_DC_Parser.parseRoot(ap);
        if ("0000".equals(rsp.getResponseCode())) {
            EBGNoteReceivableUtils.setPaymentState((List)noteReceivableInfos, (PaymentState)PaymentState.SUBMITED, (String)rsp.getResponseCode(), (String)rsp.getResponseMessage());
        }
        if ("E042".equals(rsp.getResponseCode())) {
            EBGNoteReceivableUtils.setPaymentState((List)noteReceivableInfos, (PaymentState)PaymentState.FAIL, (String)rsp.getResponseCode(), (String)rsp.getResponseMessage());
        } else {
            EBGNoteReceivableUtils.setPaymentState((List)noteReceivableInfos, (PaymentState)PaymentState.UNKNOWN, (String)ResManager.loadKDString((String)"\u94f6\u884c\u8fd4\u56de\u975e\u6b63\u5e38\u72b6\u6001\u7801\uff0c\u9700\u4eba\u5de5\u786e\u8ba4\u4ea4\u6613\u72b6\u6001\u3002", (String)"EndorseNoteReceivableImpl_4", (String)"ebg-note-banks-bocom-dc", (Object[])new Object[0]), (String)rsp.getResponseCode(), (String)rsp.getResponseMessage());
        }
        Element head = ap.getChild("head");
        String req_no = head.getChildTextTrim("req_no");
        ((NoteReceivableInfo)noteReceivableInfos.get(0)).setRspserialno(req_no);
        return noteReceivableInfos;
    }
}

