/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.note.banks.hsb.dc.services.newnote;

import kd.ebg.egf.common.context.RequestContextUtils;
import kd.ebg.egf.common.exception.EBServiceException;
import kd.ebg.egf.common.log.EBGLogger;
import kd.ebg.egf.common.utils.string.StringFormater;
import kd.ebg.egf.common.utils.xml.JDomUtils;
import org.jdom2.Element;

public class HSB_DC_Packer {
    private static EBGLogger logger = EBGLogger.getInstance().getLogger(HSB_DC_Packer.class);

    public static String buildCommonMsg(String xmlStr) throws EBServiceException {
        Element root = JDomUtils.string2Root((String)xmlStr, (String)RequestContextUtils.getCharset());
        xmlStr = JDomUtils.root2StringWithoutXMLDeclaration((Element)root, (String)RequestContextUtils.getCharset());
        int length = HSB_DC_Packer.getLength(xmlStr);
        StringBuilder buffer = new StringBuilder();
        String bankParameterValue = RequestContextUtils.getBankParameterValue((String)"exchangeProtocol");
        if ("TCP".equals(bankParameterValue)) {
            buffer.append(HSB_DC_Packer.formatLen(Integer.toString(length + 2), 10));
        }
        buffer.append("00");
        buffer.append(xmlStr);
        return buffer.toString();
    }

    public static int getLength(String msg) throws EBServiceException {
        String encoding = RequestContextUtils.getBankParameterValue((String)"charset");
        try {
            int length = msg.getBytes(encoding).length;
            return length;
        }
        catch (Exception e) {
            logger.info("\u83b7\u53d6\u62a5\u6587\u5934+\u62a5\u6587\u4f53\u957f\u5ea6\u662f\u51fa\u9519\uff0c", (Object)e);
            return 0;
        }
    }

    public static String formatLen(String orgStr, int exptecedLength) {
        try {
            String encoding = RequestContextUtils.getBankParameterValue((String)"charset");
            return StringFormater.formatLen((String)orgStr, (int)exptecedLength, (boolean)true, (char)'0', (String)encoding);
        }
        catch (Exception e) {
            logger.info("\u683c\u5f0f\u5316\u5b57\u7b26\u4e32\u51fa\u9519\uff0c", (Object)e);
            return "";
        }
    }
}

