/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.note.banks.zsb.opa.services.codeless.detail;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.czb.sap.sdk.ServiceBean;
import com.czb.sap.sdk.inf.ApiHeader;
import com.czb.sap.sdk.inf.ApiRspData;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import kd.bos.dataentity.resource.ResManager;
import kd.ebg.egf.common.exception.EBExceiptionUtil;
import kd.ebg.egf.common.framework.frame.Sequence;
import kd.ebg.egf.common.log.EBGLogger;
import kd.ebg.egf.common.utils.FetchTokenUtils;
import kd.ebg.note.banks.zsb.opa.services.codeless.detail.EndorseImpl;
import kd.ebg.note.banks.zsb.opa.services.utils.SdkInit;
import kd.ebg.note.business.noteDetail.atomic.AbstractNoteDetailImpl;
import kd.ebg.note.business.noteDetail.bank.BankNoteDetailRequest;
import kd.ebg.note.business.noteDetail.bank.BankNoteDetailRequestBody;
import kd.ebg.note.business.noteDetail.bank.EBBankDetailResponse;
import kd.ebg.note.common.entity.biz.notedetail.Detail;
import kd.ebg.note.common.entity.biz.notedetail.NoteDetailRequest;
import kd.ebg.note.common.entity.biz.notedetail.NoteSidesInfo;

public class CodelssNoteDetailImpl
extends AbstractNoteDetailImpl {
    private static final EBGLogger logger = EBGLogger.getInstance().getLogger(CodelssNoteDetailImpl.class);

    public String getDeveloper() {
        return null;
    }

    public String getBizCode() {
        return "nbts_searchCanReplyBillInfoYqt";
    }

    public String getBizDesc() {
        return ResManager.loadKDString((String)"\u5f85\u5e94\u7b54\u7968\u636e\u67e5\u8be2", (String)"CodelssNoteDetailImpl_0", (String)"ebg-note-banks-zsb-opa", (Object[])new Object[0]);
    }

    public boolean match(NoteDetailRequest noteDetailRequest) {
        return false;
    }

    public EBBankDetailResponse doBiz(BankNoteDetailRequest request) {
        String rspStr = "";
        String transCode = "";
        BankNoteDetailRequestBody requestBody = request.getBody();
        if (requestBody.getTranType().equals("03")) {
            transCode = "receipt";
        } else if (requestBody.getTranType().equals("02")) {
            transCode = "accept";
        } else if (requestBody.getTranType().equals("10")) {
            transCode = "corpEndor";
        } else if (requestBody.getTranType().equals("20")) {
            transCode = "present";
        } else if (requestBody.getTranType().equals("18")) {
            transCode = "pledge";
        } else {
            throw EBExceiptionUtil.serviceException((String)ResManager.loadKDString((String)"\u6682\u4e0d\u652f\u6301\u8be5\u4e1a\u52a1\u7c7b\u578b\u67e5\u8be2\u3002", (String)"CodelssNoteDetailImpl_1", (String)"ebg-note-banks-zsb-opa", (Object[])new Object[0]));
        }
        ArrayList<Detail> list = new ArrayList<Detail>(1);
        try {
            int pageTag = 1;
            SdkInit.init();
            do {
                ApiHeader header = new ApiHeader();
                header.setMsgtype("nbts_searchCanReplyBillInfoYqt");
                header.setTraceno(Sequence.genSequence());
                String token = FetchTokenUtils.getToken();
                header.setToken(token);
                HashMap<String, Object> body = new HashMap<String, Object>(1);
                body.put("certifyAcctNo", request.getAcnt().getAccNo());
                body.put("busiType", transCode);
                body.put("custAcctNo", request.getAcnt().getAccNo());
                body.put("billType", request.getBody().getDraftType());
                HashMap<String, Integer> PageRequest = new HashMap<String, Integer>(1);
                PageRequest.put("pageSize", 100);
                PageRequest.put("currentPage", pageTag);
                body.put("PageRequest", PageRequest);
                body.put("eleSign", Sequence.gen16Sequence());
                logger.info("\u8bf7\u6c42\u53c2\u6570:{}", (Object)JSON.toJSONString(body));
                ApiRspData data = ServiceBean.getService((String)SdkInit.getTenantKey()).invoke(header, body);
                rspStr = JSON.toJSONString((Object)data);
                logger.info("\u6d59\u5546\u8fd4\u56de\u62a5\u6587\uff1a" + rspStr);
                if (!"000000".equalsIgnoreCase(data.getResultcode())) {
                    SdkInit.checkToken(token);
                }
                List<Detail> details = this.parse(request, rspStr);
                list.addAll(details);
            } while (!this.isLastPage(pageTag = this.getNextPageTag(rspStr, pageTag)));
        }
        catch (Throwable e) {
            throw EBExceiptionUtil.serviceException((String)String.format(ResManager.loadKDString((String)"\u6d59\u5546\u67e5\u8be2\u5f02\u5e38\uff1a%1$s\u3002", (String)"CodelssNoteDetailImpl_2", (String)"ebg-note-banks-zsb-opa", (Object[])new Object[0]), e.getMessage()), (Throwable)e);
        }
        return new EBBankDetailResponse(list);
    }

    public String pack(BankNoteDetailRequest request, String pagetag) {
        return null;
    }

    public List<Detail> parse(BankNoteDetailRequest rqst, String rspStr) {
        JSONObject root = JSONObject.parseObject((String)rspStr);
        String statusCode = root.getString("resultcode");
        String statusDesc = root.getString("resultdesc");
        if (!"000000".equalsIgnoreCase(statusCode)) {
            throw EBExceiptionUtil.serviceException((String)String.format(ResManager.loadKDString((String)"\u67e5\u8be2\u5931\u8d25 , \u94f6\u884c\u8fd4\u56de\u9519\u8bef\u7801:%1$s \u9519\u8bef\u4fe1\u606f:%2$s", (String)"CodelssNoteDetailImpl_3", (String)"ebg-note-banks-zsb-opa", (Object[])new Object[0]), statusCode, statusDesc));
        }
        ArrayList<Detail> result = new ArrayList<Detail>(1);
        JSONObject jsonBody = root.getJSONObject("body");
        JSONObject PageResponse = jsonBody.getJSONObject("pageResponse");
        int totalRows = PageResponse.getInteger("totalRows");
        int totalPages = PageResponse.getInteger("totalPages");
        if (totalRows == 0 || totalPages == 0) {
            return result;
        }
        JSONArray CanReplyBillInfoYqtOutBean = jsonBody.getJSONArray("canReplyBillInfoYqtOutBeanList");
        for (int i = 0; i < CanReplyBillInfoYqtOutBean.size(); ++i) {
            JSONObject element = CanReplyBillInfoYqtOutBean.getJSONObject(i);
            Detail detailInfo = new Detail();
            result.add(detailInfo);
            String billNo = element.getString("billNo");
            detailInfo.setNoteNo(billNo);
            String billAmount = element.getString("billAmount");
            detailInfo.setAmount(billAmount);
            String rangeStart = element.getString("rangeStart");
            detailInfo.setStartNo(rangeStart);
            String rangeEnd = element.getString("rangeEnd");
            detailInfo.setEndNo(rangeEnd);
            String billType = element.getString("billType");
            detailInfo.setDraftType(billType);
            String issuDate = element.getString("issuDate");
            detailInfo.setIssueDate(issuDate);
            String dueDate = element.getString("dueDate");
            detailInfo.setDueDate(dueDate);
            String remitter = element.getString("remitter");
            String remitterAcctNo = element.getString("remitterAcctNo");
            String remitterBankNo = element.getString("remitterBankNo");
            String remitterBankName = element.getString("remitterBankName");
            detailInfo.setDrawerAccName(remitter);
            detailInfo.setDrawerAccNo(remitterAcctNo);
            detailInfo.setDrawerCnapsCode(remitterBankNo);
            detailInfo.setDrawerBankName(remitterBankName);
            String payee = element.getString("payee");
            String payeeAcctNo = element.getString("payeeAcctNo");
            String payeeBankNo = element.getString("payeeBankNo");
            String payeeBankName = element.getString("payeeBankName");
            detailInfo.setPayeeAccName(payee);
            detailInfo.setPayeeAccNo(payeeAcctNo);
            detailInfo.setPayeeCnapsCode(payeeBankNo);
            detailInfo.setPayeeBankName(payeeBankName);
            String acceptor = element.getString("acceptor");
            String acceptorAcctNo = element.getString("acceptorAcctNo");
            String acceptorBankNo = element.getString("acceptorBankNo");
            String acceptorBankName = element.getString("acceptorBankName");
            detailInfo.setAcceptorAccName(acceptor);
            detailInfo.setAcceptorAccNo(acceptorAcctNo);
            detailInfo.setAcceptorCnapsCode(acceptorBankNo);
            detailInfo.setAcceptorBankName(acceptorBankName);
            String banEndorMark = element.getString("banEndorMark");
            detailInfo.setTransferFlag(banEndorMark);
            String isAllowSplit = element.getString("isAllowSplit");
            detailInfo.setGrdBag(isAllowSplit);
            String rangeStatus = element.getString("rangeStatus");
            detailInfo.setNoteStatus(rangeStatus);
            String flowFlag = element.getString("flowFlag");
            detailInfo.setIsNewECDS("0");
            detailInfo.setCirStatus(flowFlag);
            String applyDate = element.getString("applyDate");
            detailInfo.setApplicationDate(applyDate);
            String fromName = element.getString("fromName");
            String fromAcctNo = element.getString("fromAcctNo");
            String fromBankNo = element.getString("fromBankNo");
            String fromBankName = element.getString("fromBankName");
            detailInfo.setApplicantAcName(fromName);
            detailInfo.setApplicantAcNo(fromAcctNo);
            detailInfo.setApplicantBankCnaps(fromBankNo);
            detailInfo.setApplicantBankName(fromBankName);
            detailInfo.setHolderBankName(fromBankName);
            detailInfo.setHolderCnapsCode(fromBankNo);
            detailInfo.setHolderAccNo(fromAcctNo);
            detailInfo.setPreHolderName(fromName);
            if (!"10".equals(rqst.getBody().getTranType())) continue;
            try {
                EndorseImpl impl = new EndorseImpl();
                List<NoteSidesInfo> noteSidesInfos = impl.getMessage(rqst.getAcnt().getAccNo(), billNo, rangeStart, rangeEnd);
                detailInfo.setNoteSidesInfo(noteSidesInfos);
                continue;
            }
            catch (Exception e) {
                detailInfo.setIsNoteSidesError("Y");
            }
        }
        return result;
    }

    public int getNextPageTag(String rspStr, int pageTag) {
        JSONObject root = JSONObject.parseObject((String)rspStr);
        JSONObject jsonBody = root.getJSONObject("body");
        JSONObject PageResponse = jsonBody.getJSONObject("pageResponse");
        int totalPages = PageResponse.getInteger("totalPages");
        if (pageTag < totalPages) {
            return pageTag + 1;
        }
        return 0;
    }

    public boolean isLastPage(int pageTag) {
        return pageTag == 0;
    }
}

