/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.note.banks.pab.dc.service.note.detail;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import java.time.LocalDate;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import kd.bos.dataentity.resource.ResManager;
import kd.ebg.egf.common.exception.EBExceiptionUtil;
import kd.ebg.egf.common.log.EBGLogger;
import kd.ebg.egf.common.model.bank.BankAcnt;
import kd.ebg.egf.common.utils.LocalDateUtil;
import kd.ebg.egf.common.utils.datetime.DateTimeUtils;
import kd.ebg.egf.common.utils.string.StringUtils;
import kd.ebg.note.banks.pab.dc.service.note.detail.endorseInfo.EndorseImpl;
import kd.ebg.note.banks.pab.dc.service.note.util.PackerUtil;
import kd.ebg.note.banks.pab.dc.service.note.util.ParserUtil;
import kd.ebg.note.business.noteDetail.atomic.AbstractNoteDetailImpl;
import kd.ebg.note.business.noteDetail.bank.BankNoteDetailRequest;
import kd.ebg.note.business.noteDetail.bank.BankNoteDetailRequestBody;
import kd.ebg.note.business.noteDetail.bank.EBBankDetailResponse;
import kd.ebg.note.common.entity.biz.notedetail.Detail;
import kd.ebg.note.common.entity.biz.notedetail.NoteDetailRequest;
import kd.ebg.note.common.entity.biz.notedetail.NoteSidesInfo;

public class NoteDetailImpl
extends AbstractNoteDetailImpl {
    private final EBGLogger logger = EBGLogger.getInstance().getLogger(NoteDetailImpl.class);

    public String getDeveloper() {
        return "";
    }

    public String getBizCode() {
        return "P70103";
    }

    public String getBizDesc() {
        return ResManager.loadKDString((String)"\u7968\u636e\u4fe1\u606f\u67e5\u8be2", (String)"NoteDetailImpl_0", (String)"ebg-note-banks-pab-dc", (Object[])new Object[0]);
    }

    public boolean match(NoteDetailRequest noteDetailRequest) {
        return true;
    }

    public long getBankInterval() {
        return 0L;
    }

    public boolean isNeedPage() {
        return true;
    }

    public String getFirstPageTag() {
        return "1";
    }

    public String getNextPageTag(String rspStr, String pageTag) {
        JSONObject retData = ParserUtil.getJsonRoot(rspStr);
        JSONObject content = retData.getJSONObject("retData");
        JSONObject pageInfo = content.getJSONObject("pageInfo");
        int pageCount = pageInfo.getIntValue("pageCount");
        int pre = Integer.parseInt(pageTag);
        if (pre < pageCount) {
            return ++pre + "";
        }
        return "";
    }

    public boolean isLastPage(String rspStr, String pageTag) {
        return StringUtils.isEmpty((String)pageTag);
    }

    public String pack(BankNoteDetailRequest request, String pageTag) {
        String transCode = "";
        BankAcnt ancAcnt = request.getAcnt();
        BankNoteDetailRequestBody body = request.getBody();
        if (body.getTranType().equals("03")) {
            transCode = "NES.003.20.00P";
        } else if (body.getTranType().equals("02")) {
            transCode = "NES.002.20.00P";
        } else if (body.getTranType().equals("10")) {
            transCode = "NES.006.20.00P";
        } else if (body.getTranType().equals("20")) {
            transCode = "NES.011.20.00P";
        } else if (body.getTranType().equals("11")) {
            transCode = "NES.007.20.00P";
        } else {
            throw EBExceiptionUtil.serviceException((String)ResManager.loadKDString((String)"\u65e0\u6cd5\u5904\u7406\u7684\u56de\u590d\u7c7b\u578b\u3002\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u3002", (String)"NoteDetailImpl_2", (String)"ebg-note-banks-pab-dc", (Object[])new Object[0]));
        }
        JSONObject root = new JSONObject();
        JSONObject pageInfo = new JSONObject();
        pageInfo.put("pageNo", (Object)pageTag);
        pageInfo.put("pageSize", (Object)"100");
        root.put("pageInfo", (Object)pageInfo);
        JSONObject requestDto = new JSONObject();
        requestDto.put("applAcctNo", (Object)ancAcnt.getAccNo());
        requestDto.put("applyQueryType", (Object)"1");
        requestDto.put("minTransApplDt", (Object)LocalDateUtil.formatDate((LocalDate)LocalDate.now().plusMonths(-3L)));
        requestDto.put("maxTransApplDt", (Object)DateTimeUtils.format((Date)new Date(), (String)"yyyyMMdd"));
        requestDto.put("transNo", (Object)transCode);
        requestDto.put("queryType", (Object)"QT00");
        requestDto.put("reserveFlag", (Object)"0");
        requestDto.put("isAllowSplitBill", (Object)"1");
        root.put("requestDto", (Object)requestDto);
        return PackerUtil.getPackerResult(root.toJSONString(), this.getBizCode());
    }

    public List<Detail> parse(BankNoteDetailRequest request, String rspStr) {
        JSONObject root = ParserUtil.getJsonRoot(rspStr);
        ArrayList<Detail> result = new ArrayList<Detail>(16);
        JSONObject retData = root.getJSONObject("retData");
        JSONArray list = retData.getJSONArray("list");
        if (list == null) {
            return result;
        }
        for (int i = 0; i < list.size(); ++i) {
            Detail detailInfo = new Detail();
            JSONObject object = (JSONObject)list.get(i);
            String billId = object.getString("billId");
            detailInfo.setBankRefKey(billId);
            String billNo = object.getString("billNo");
            detailInfo.setNoteNo(billNo);
            String billRangeStart = object.getString("billRangeStart");
            detailInfo.setStartNo(billRangeStart);
            String billRangeEnd = object.getString("billRangeEnd");
            detailInfo.setEndNo(billRangeEnd);
            detailInfo.setSubRange(billRangeStart + "-" + billRangeEnd);
            String remitDt = object.getString("remitDt");
            detailInfo.setIssueDate(remitDt);
            String dueDt = object.getString("dueDt");
            detailInfo.setDueDate(dueDt);
            String drwrName = object.getString("drwrName");
            detailInfo.setDrawerAccName(drwrName);
            String drwrAcctNo = object.getString("drwrAcctNo");
            detailInfo.setDrawerAccNo(drwrAcctNo);
            String drwrBankNo = object.getString("drwrBankNo");
            String drwrBankName = object.getString("drwrBankName");
            detailInfo.setDrawerBankName(drwrBankName);
            detailInfo.setDrawerCnapsCode(drwrBankNo);
            String pyeeName = object.getString("pyeeName");
            detailInfo.setPayeeAccName(pyeeName);
            String pyeeAcctNo = object.getString("pyeeAcctNo");
            detailInfo.setPayeeAccNo(pyeeAcctNo);
            String pyeeBankName = object.getString("pyeeBankName");
            detailInfo.setPayeeBankName(pyeeBankName);
            String pyeeBankNo = object.getString("pyeeBankNo");
            detailInfo.setPayeeCnapsCode(pyeeBankNo);
            String acptAcctNo = object.getString("acptAcctNo");
            String acptName = object.getString("acptName");
            detailInfo.setAcceptorAccName(acptName);
            detailInfo.setAcceptorAccNo(acptAcctNo);
            String acptBankName = object.getString("acptBankName");
            detailInfo.setAcceptorBankName(acptBankName);
            String acptBankNo = object.getString("acptBankNo");
            detailInfo.setAcceptorCnapsCode(acptBankNo);
            String billMoney = object.getString("billMoney");
            detailInfo.setAmount(billMoney);
            String transFromName = object.getString("transFromName");
            detailInfo.setApplicantAcName(transFromName);
            String transFromBankNo = object.getString("transFromBankNo");
            String transFromBankName = object.getString("transFromBankName");
            String transFromAcctNo = object.getString("transFromAcctNo");
            detailInfo.setApplicantAcNo(transFromAcctNo);
            detailInfo.setApplicantBankName(transFromBankName);
            detailInfo.setApplicantBankCnaps(transFromBankNo);
            String rmrk = object.getString("rmrk");
            String billType = object.getString("billType");
            detailInfo.setDraftType(billType);
            detailInfo.setExplain(rmrk);
            String cirStatus = object.getString("cirStatus");
            if (!"TF0302".equals(cirStatus)) {
                cirStatus = "TF0302";
            }
            detailInfo.setCirStatus(cirStatus);
            String billStatus = object.getString("billStatus");
            detailInfo.setNoteStatus(billStatus);
            String transId = object.getString("transId");
            String hldrId = object.getString("hldrId");
            String msgId = object.getString("msgId");
            detailInfo.setBankRefKey(billId + "_" + transId + "_" + hldrId + "_" + msgId);
            detailInfo.setCurrency("RMB");
            String isAllowSplitBill = object.getString("isAllowSplitBill");
            detailInfo.setGrdBag(isAllowSplitBill);
            BankNoteDetailRequestBody body = request.getBody();
            detailInfo.setBusinessCode(body.getTranType());
            detailInfo.setIsNewECDS("0");
            detailInfo.setPreHolderName(transFromName);
            result.add(detailInfo);
            try {
                if (!body.getTranType().equals("10")) continue;
                body.setStartNo(billRangeStart);
                body.setEndNo(billRangeEnd);
                body.setNoteNo(billNo);
                EndorseImpl impl = new EndorseImpl();
                EBBankDetailResponse response = impl.doBiz(request);
                List details = response.getDetails();
                Detail detail = (Detail)details.get(0);
                List listSide = detail.getNoteSidesInfo();
                for (int j = 0; j < listSide.size(); ++j) {
                    ((NoteSidesInfo)listSide.get(j)).setResv1(j + 1 + "");
                }
                detailInfo.setNoteSidesInfo(listSide);
                continue;
            }
            catch (Exception e) {
                detailInfo.setIsNoteSidesError("Y");
            }
        }
        return result;
    }
}

