/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.note.banks.pab.dc.service.note.receivable.pledge;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import java.util.Date;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.resource.ResManager;
import kd.ebg.egf.common.exception.EBExceiptionUtil;
import kd.ebg.egf.common.framework.frame.Sequence;
import kd.ebg.egf.common.log.EBGLogger;
import kd.ebg.egf.common.utils.datetime.DateTimeUtils;
import kd.ebg.egf.common.utils.string.StringUtils;
import kd.ebg.note.banks.pab.dc.service.note.receivable.SplideUtil;
import kd.ebg.note.banks.pab.dc.service.note.receivable.pledge.QueryPledgeNoteReceivableImpl;
import kd.ebg.note.banks.pab.dc.service.note.util.PackerUtil;
import kd.ebg.note.banks.pab.dc.service.note.util.ParserUtil;
import kd.ebg.note.business.noteReceivable.atomic.AbstractNoteReceivableImpl;
import kd.ebg.note.business.noteReceivable.atomic.IQueryNoteReceivable;
import kd.ebg.note.business.noteReceivable.bank.BankNoteReceivableRequest;
import kd.ebg.note.common.model.NoteReceivableInfo;

public class PledgeNoteReceivableImpl
extends AbstractNoteReceivableImpl {
    private EBGLogger logger = EBGLogger.getInstance().getLogger(PledgeNoteReceivableImpl.class);

    public long getBankInterval() {
        return 0L;
    }

    public int getBatchSize() {
        return 1;
    }

    public Class<? extends IQueryNoteReceivable> defaultQueryClass() {
        return QueryPledgeNoteReceivableImpl.class;
    }

    public String getDeveloper() {
        return "";
    }

    public String getBizCode() {
        return "P70104";
    }

    public String getBizDesc() {
        return ResManager.loadKDString((String)"\u7535\u7968\u8d28\u62bc(P70104)", (String)"PledgeNoteReceivableImpl_0", (String)"ebg-note-banks-pab-dc", (Object[])new Object[0]);
    }

    public boolean match(NoteReceivableInfo noteReceivableInfo) {
        return true;
    }

    public String pack(BankNoteReceivableRequest request, String pageTag) {
        NoteReceivableInfo[] infos = request.getNotePayableInfosAsArray();
        SplideUtil splideUtil = new SplideUtil();
        String pack4Split = splideUtil.packNoteDetailRequset(infos, "1", "NES.009.20.00P");
        String res4Split = this.doBussiness(pack4Split);
        Map<String, String> result = splideUtil.parseNoteInfoDetail(res4Split);
        NoteReceivableInfo info = infos[0];
        JSONObject root = new JSONObject();
        JSONObject requestDto = new JSONObject();
        requestDto.put("dataSource", (Object)"1");
        requestDto.put("drwrAutoType", (Object)"");
        requestDto.put("operCode", (Object)"OC0");
        requestDto.put("batchNumber", (Object)Sequence.gen16NumSequence());
        root.put("requestDto", (Object)requestDto);
        JSONArray reqInfoList = new JSONArray();
        requestDto.put("reqInfoList", (Object)reqInfoList);
        JSONObject object = new JSONObject();
        reqInfoList.add((Object)object);
        object.put("applAcctNo", (Object)info.getDrawerAccNo());
        object.put("applBankNo", (Object)info.getDrawerBankCnaps());
        String billId_hldrId = info.getBankRefKey();
        if (StringUtils.isEmpty((String)billId_hldrId)) {
            throw EBExceiptionUtil.serviceException((String)ResManager.loadKDString((String)"bankRefKey\u4e0d\u6ee1\u8db3\u6761\u4ef6\uff0c\u65e0\u6cd5\u5904\u7406", (String)"PledgeNoteReceivableImpl_1", (String)"ebg-note-banks-pab-dc", (Object[])new Object[0]));
        }
        String[] bankRefKey = billId_hldrId.split("_");
        if (bankRefKey.length < 2) {
            throw EBExceiptionUtil.serviceException((String)ResManager.loadKDString((String)"bankRefKey\u4e0d\u6ee1\u8db3\u6761\u4ef6\uff0c\u65e0\u6cd5\u5904\u7406", (String)"PledgeNoteReceivableImpl_1", (String)"ebg-note-banks-pab-dc", (Object[])new Object[0]));
        }
        object.put("billId", (Object)result.get("billId"));
        object.put("hldrId", (Object)result.get("hldrId"));
        object.put("transNo", (Object)"NES.009.20.00P");
        object.put("transAmt", (Object)info.getAmount());
        object.put("reserveFlag", (Object)"0");
        object.put("rmrkByPropsr", (Object)info.getExplanation());
        JSONObject impawnInfo = new JSONObject();
        object.put("impawnInfo", (Object)impawnInfo);
        impawnInfo.put("toName", (Object)info.getPayeeAccName());
        impawnInfo.put("toAcctNo", (Object)info.getPayeeAccNo());
        impawnInfo.put("impawnDt", (Object)DateTimeUtils.format((Date)new Date(), (String)"yyyyMMdd"));
        impawnInfo.put("toBankNo", (Object)info.getPayeeBankCnaps());
        return PackerUtil.getPackerResult(root.toJSONString(), "P70104");
    }

    public List<NoteReceivableInfo> parse(BankNoteReceivableRequest request, String responseStr) {
        List infos = request.getNoteReceivableInfos();
        ParserUtil.parsePay(infos, responseStr);
        return infos;
    }
}

