/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.note.banks.cmb.opa.service.note.payable.revocation;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import java.util.Date;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.resource.ResManager;
import kd.ebg.egf.common.context.EBContext;
import kd.ebg.egf.common.context.RequestContextUtils;
import kd.ebg.egf.common.exception.EBExceiptionUtil;
import kd.ebg.egf.common.framework.communication.ConnectionFactory;
import kd.ebg.egf.common.framework.frame.Sequence;
import kd.ebg.egf.common.log.EBGLogger;
import kd.ebg.egf.common.model.bank.BankAcnt;
import kd.ebg.egf.common.utils.datetime.DateUtil;
import kd.ebg.egf.common.utils.string.StringUtils;
import kd.ebg.note.banks.cmb.opa.service.BankBusinessConfig;
import kd.ebg.note.banks.cmb.opa.service.note.payable.revocation.QueryRevocationNotePayableImpl;
import kd.ebg.note.banks.cmb.opa.service.note.util.AvaiableQuery;
import kd.ebg.note.banks.cmb.opa.service.note.util.JsonUtil;
import kd.ebg.note.banks.cmb.opa.service.note.util.MsgPacker;
import kd.ebg.note.banks.cmb.opa.service.note.util.ParserPayable;
import kd.ebg.note.banks.cmb.opa.service.note.util.PostUtil;
import kd.ebg.note.banks.cmb.opa.service.note.util.SaasUtil;
import kd.ebg.note.business.notePayable.atomic.AbstractNotePayableImpl;
import kd.ebg.note.business.notePayable.atomic.IQueryNotePayable;
import kd.ebg.note.business.notePayable.bank.BankNotePayableRequest;
import kd.ebg.note.business.notePayable.bank.EBBankNotePayableResponse;
import kd.ebg.note.common.model.NotePayableInfo;

public class RevocationNotePayableImpl
extends AbstractNotePayableImpl {
    private final EBGLogger logger = EBGLogger.getInstance().getLogger(RevocationNotePayableImpl.class);

    public long getBankInterval() {
        return 0L;
    }

    public int getBatchSize() {
        return 0;
    }

    public Class<? extends IQueryNotePayable> defaultQueryClass() {
        return QueryRevocationNotePayableImpl.class;
    }

    public String getDeveloper() {
        return "";
    }

    public String getBizCode() {
        return "billdestruction";
    }

    public String getBizDesc() {
        return ResManager.loadKDString((String)"\u64a4\u7968", (String)"RevocationNotePayableImpl_0", (String)"ebg-note-banks-cmb-opa", (Object[])new Object[0]);
    }

    public void configFactory(ConnectionFactory factory) {
        super.configFactory(factory);
        factory.setHttpHeader("Content-Type", "application/x-www-form-urlencoded");
    }

    public EBBankNotePayableResponse doBiz(BankNotePayableRequest request) {
        String rqstStr = this.pack(request, null);
        String rspStr = PostUtil.sendMsgForPay(rqstStr);
        try {
            List<NotePayableInfo> infos = this.parse(request, rspStr);
            return new EBBankNotePayableResponse(infos);
        }
        catch (Exception e) {
            this.logger.error("error ", (Throwable)e);
            EBContext.getContext().setThrowableAfterSend((Throwable)e);
            return new EBBankNotePayableResponse(request.getNotePayableInfoList());
        }
    }

    public boolean match(NotePayableInfo notePayableInfo) {
        return true;
    }

    public String pack(BankNotePayableRequest request, String pageTag) {
        BankAcnt acnt = request.getAcnt();
        AvaiableQuery avaiable = new AvaiableQuery();
        NotePayableInfo[] infos = request.getNotePayableInfosAsArray();
        Map flag = avaiable.getmsg(infos[0].getDrawerAccNo(), "BC19", infos[0].getBillNo(), infos[0].getStartNo(), infos[0].getEndNo());
        if (flag == null) {
            throw EBExceiptionUtil.serviceException((String)ResManager.loadKDString((String)"\u94f6\u884c\u8fd4\u56de\u6b64\u7968\u636e\u4e0d\u80fd\u64a4\u7968\u3002", (String)"RevocationNotePayableImpl_1", (String)"ebg-note-banks-cmb-opa", (Object[])new Object[0]));
        }
        JSONObject body = new JSONObject();
        JSONArray array1 = new JSONArray();
        JSONObject qryHdr = new JSONObject();
        String cltNbr = RequestContextUtils.getBankParameterValue((String)"cltNbr");
        if (!StringUtils.isEmpty((String)cltNbr)) {
            qryHdr.put("cltNbr", (Object)cltNbr);
        } else {
            qryHdr.put("cltNbr", (Object)acnt.getAccNo().substring(0, 10));
        }
        array1.add((Object)qryHdr);
        body.put("trxHdr", (Object)array1);
        JSONArray array2 = new JSONArray();
        JSONObject cltTrsDetailEdcInpDto = new JSONObject();
        cltTrsDetailEdcInpDto.put("cnlRef", (Object)SaasUtil.getRnlRef(infos[0].getBankBatchSeqId()));
        cltTrsDetailEdcInpDto.put("flwTyp", (Object)"ND0010");
        cltTrsDetailEdcInpDto.put("busTyp", (Object)"DB");
        cltTrsDetailEdcInpDto.put("busSty", (Object)"04");
        cltTrsDetailEdcInpDto.put("busTrs", (Object)"OUT");
        cltTrsDetailEdcInpDto.put("busStr", (Object)infos[0].getDraftType());
        cltTrsDetailEdcInpDto.put("oprDat", (Object)DateUtil.formatDate((Date)new Date()));
        cltTrsDetailEdcInpDto.put("sndEac", (Object)infos[0].getDrawerAccNo());
        cltTrsDetailEdcInpDto.put("ccyNbr", (Object)"10");
        cltTrsDetailEdcInpDto.put("addMap", (Object)"NNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNN");
        cltTrsDetailEdcInpDto.put("bchCnt", (Object)"1");
        cltTrsDetailEdcInpDto.put("bchTyp", (Object)"OPR");
        String flwCod = BankBusinessConfig.getBusMod(infos[0].getDrawerAccNo());
        if (StringUtils.isEmpty((String)flwCod)) {
            throw EBExceiptionUtil.serviceException((String)ResManager.loadKDString((String)"\u4e1a\u52a1\u6a21\u5f0f\u7f16\u53f7\u4e3a\u7a7a\uff0c\u8bf7\u5728\u8d26\u53f7\u914d\u7f6e\u7684\u9644\u52a0\u5c5e\u6027\u4e2d\u7ef4\u62a4\u3002", (String)"RegisterNotePayableImpl_5", (String)"ebg-note-banks-cmb-opa", (Object[])new Object[0]));
        }
        cltTrsDetailEdcInpDto.put("flwCod", (Object)flwCod);
        array2.add((Object)cltTrsDetailEdcInpDto);
        body.put("batchBusOprX1", (Object)array2);
        JSONArray array6 = new JSONArray();
        JSONObject busOprIpt = new JSONObject();
        busOprIpt.put("busOprIpt", (Object)cltTrsDetailEdcInpDto);
        array6.add((Object)busOprIpt);
        body.put("batchDetail", (Object)array6);
        JSONArray array7 = new JSONArray();
        JSONObject DestructionApplyX2 = new JSONObject();
        JSONArray DestructionApplyX = new JSONArray();
        JSONObject sceneDataMap = new JSONObject();
        sceneDataMap.put("DestructionApplyX2", (Object)DestructionApplyX);
        busOprIpt.put("sceneDataMap", (Object)sceneDataMap);
        DestructionApplyX.add((Object)DestructionApplyX2);
        DestructionApplyX2.put("innNbr", flag.get("innNbr"));
        DestructionApplyX2.put("bilNbr", (Object)infos[0].getBillNo());
        DestructionApplyX2.put("bilAmt", (Object)infos[0].getAmount().toString());
        array7.add((Object)DestructionApplyX2);
        JSONArray array8 = new JSONArray();
        JSONObject DestructionApplyX1 = new JSONObject();
        array8.add((Object)DestructionApplyX1);
        body.put("DestructionApplyX1", (Object)array8);
        DestructionApplyX1.put("appEac", (Object)infos[0].getDrawerAccNo());
        DestructionApplyX1.put("appSrc", (Object)"CS02");
        DestructionApplyX1.put("busCod", (Object)"BC19");
        DestructionApplyX1.put("busTyp", (Object)"C00");
        DestructionApplyX1.put("busCod", (Object)"BC19");
        DestructionApplyX1.put("busDat", (Object)DateUtil.formatDate((Date)new Date()));
        DestructionApplyX1.put("busCnl", (Object)"EDC");
        DestructionApplyX1.put("prxApp", (Object)"PS01");
        DestructionApplyX1.put("busCcy", (Object)"10");
        DestructionApplyX1.put("busAmt", (Object)infos[0].getAmount().toString());
        DestructionApplyX1.put("busCnt", (Object)"1");
        JSONObject head = JsonUtil.getHead("billdestruction", Sequence.genSequence());
        JSONObject result = JsonUtil.getrequest(head, body);
        return MsgPacker.getSendMsg(result, this.logger, "billdestruction");
    }

    public List<NotePayableInfo> parse(BankNotePayableRequest request, String responseStr) {
        List infos = request.getNotePayableInfoList();
        ParserPayable.parsePay(infos, responseStr);
        return infos;
    }
}

