/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.receipt.banks.ncb.dc.service.receipt.fetch;

import com.alibaba.fastjson.JSONObject;
import com.google.common.collect.Maps;
import java.time.LocalDate;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.resource.ResManager;
import kd.ebg.egf.common.model.detail.DetailInfoOnReceipt;
import kd.ebg.egf.common.utils.FetchDataUtils;
import kd.ebg.egf.common.utils.LocalDateUtil;
import kd.ebg.receipt.banks.ncb.dc.service.receipt.api.OneBankReceiptDownloadImpl;
import kd.ebg.receipt.business.receipt.atom.AbstractBankReceiptHandleImpl;
import kd.ebg.receipt.business.receipt.atom.IBankReceiptHandle;
import kd.ebg.receipt.business.receipt.bank.frontProxy.BankReceiptRequest;
import kd.ebg.receipt.business.receipt.bank.frontProxy.BankReceiptResponseEB;
import kd.ebg.receipt.business.receipt.bank.task.BankReceiptHandleRequest;
import kd.ebg.receipt.business.receipt.bank.task.BankReceiptHandleResponseEB;
import kd.ebg.receipt.business.receipt.entity.TaskStatus;
import kd.ebg.receipt.common.constant.UploadStatusEnum;
import kd.ebg.receipt.common.framework.frame.EBGLogger;
import kd.ebg.receipt.common.framework.services.receipt.DownloadListDetailService;
import kd.ebg.receipt.common.model.receipt.DownloadListDetail;
import kd.ebg.receipt.common.utils.SpringContextUtil;

public class BankReceiptFetchListImpl
extends AbstractBankReceiptHandleImpl
implements IBankReceiptHandle {
    private static EBGLogger logger = EBGLogger.getInstance().getLogger(BankReceiptFetchListImpl.class);
    public DownloadListDetailService downloadListDetailService;

    public boolean match(BankReceiptHandleRequest request) {
        if (request == null) {
            return false;
        }
        Integer status = request.getTaskStatus();
        if (status == null) {
            return false;
        }
        return status.intValue() == TaskStatus.PROCESSING.getId();
    }

    public void init(BankReceiptHandleRequest request) {
        this.downloadListDetailService = (DownloadListDetailService)SpringContextUtil.getBean(DownloadListDetailService.class);
    }

    public BankReceiptHandleResponseEB doBiz(BankReceiptHandleRequest request) {
        this.init(request);
        String accNo = request.getAccNo();
        LocalDate transDate = request.getTransDate();
        String transDateStr = LocalDateUtil.formatDate((LocalDate)transDate);
        ArrayList<DownloadListDetail> result = new ArrayList<DownloadListDetail>(16);
        List detailInfoList = FetchDataUtils.queryDetailFromReceipt((String)request.getBankVersionId(), (String)request.getBankLoginId(), (String)accNo, (LocalDate)transDate, (String)request.getHeader().getAcnt().getCurrency());
        long taskId = request.getTaskId();
        List downloadListDetails = this.downloadListDetailService.selectByRefId(Long.valueOf(taskId));
        HashMap existMap = Maps.newHashMapWithExpectedSize((int)1);
        for (DownloadListDetail downloadListDetail : downloadListDetails) {
            if (downloadListDetail.getUploadFlag().intValue() != UploadStatusEnum.UPLOAD_SUCCESS.getId()) continue;
            existMap.put(downloadListDetail.getFileName(), downloadListDetail);
        }
        for (DetailInfoOnReceipt detailInfo : detailInfoList) {
            String jsonStr = detailInfo.getJsonMap();
            JSONObject jsonObject = JSONObject.parseObject((String)jsonStr);
            String serialNo = jsonObject.getString("core_seq_no");
            String amount = jsonObject.getString("tran_amount");
            String cdFlag = jsonObject.getString("cd_flag");
            String sub_core_seq_no = jsonObject.getString("sub_core_seq_no");
            String oppAccNo = detailInfo.getOppAccNo();
            String acdt = jsonObject.getString("acdt");
            String json = detailInfo.getJsonMap();
            StringBuilder fileName = new StringBuilder();
            fileName.append(accNo).append("_");
            fileName.append(transDateStr).append("_");
            fileName.append(serialNo).append("_");
            fileName.append(cdFlag).append("_");
            fileName.append(amount).append("_");
            fileName.append(oppAccNo);
            fileName.append(".pdf");
            String fileNameStr = fileName.toString();
            DownloadListDetail downloadListDetail = new DownloadListDetail();
            downloadListDetail.setFileName(fileName.toString());
            if (!existMap.containsKey(fileNameStr)) {
                OneBankReceiptDownloadImpl bankReceiptPrint = new OneBankReceiptDownloadImpl();
                HashMap paramMap = Maps.newHashMapWithExpectedSize((int)3);
                paramMap.put("flowNo", serialNo);
                paramMap.put("logSrlNo", sub_core_seq_no);
                paramMap.put("transDate", acdt);
                BankReceiptRequest bankReceiptRequest = BankReceiptRequest.builder().accNo(accNo).transDate(transDate).requestStr(serialNo).paramsMap((Map)paramMap).build();
                BankReceiptResponseEB responseEB = bankReceiptPrint.doBiz(bankReceiptRequest);
                String fileLink = (String)responseEB.getData();
                downloadListDetail.setFileLink(fileLink);
            } else {
                DownloadListDetail existDetail = (DownloadListDetail)existMap.get(fileNameStr);
                downloadListDetail.setFileLink(existDetail.getFileLink());
            }
            downloadListDetail.setReceiptJson(json);
            result.add(downloadListDetail);
        }
        return BankReceiptHandleResponseEB.success(result);
    }

    public String getDeveloper() {
        return "";
    }

    public String getBizCode() {
        return "BankReceiptFetchList";
    }

    public String getBizDesc() {
        return ResManager.loadKDString((String)"\u83b7\u53d6\u56de\u5355\u6587\u4ef6\u5217\u8868", (String)"BankReceiptFetchListImpl_0", (String)"ebg-receipt-banks-ncb-dc", (Object[])new Object[0]);
    }
}

