/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.receipt.banks.cus.service.receipt.fetch;

import com.google.common.collect.Maps;
import java.util.Map;
import java.util.Set;
import kd.ebg.egf.common.context.EBContext;
import kd.ebg.egf.common.log.EBGLogger;
import kd.ebg.receipt.banks.cus.service.receipt.CommonReceiptImpl;
import kd.ebg.receipt.business.receipt.atom.IBankReceiptHandle;
import kd.ebg.receipt.business.receipt.bank.task.BankReceiptHandleRequest;
import kd.ebg.receipt.business.receipt.bank.task.BankReceiptHandleResponseEB;
import kd.ebg.receipt.business.receipt.entity.TaskStatus;
import kd.ebg.receipt.common.utils.ReflectUtil;
import kd.sdk.ebg.cus.api.biz.receipt.ISDKFetchReceiptHandle;
import kd.sdk.ebg.cus.bean.bank.receipt.SDKBankReceiptHandleResponse;

public class ReceiptFetchImpl
extends CommonReceiptImpl
implements IBankReceiptHandle {
    EBGLogger logger = EBGLogger.getInstance().getLogger(ReceiptFetchImpl.class);
    private static Map<String, ISDKFetchReceiptHandle> cacheMap = Maps.newHashMapWithExpectedSize((int)1);

    private ISDKFetchReceiptHandle getImplFromCache() {
        String bankVersionID = EBContext.getContext().getBankVersionID();
        return this.getImplFromCache(bankVersionID);
    }

    private synchronized ISDKFetchReceiptHandle getImplFromCache(String bankVersionID) {
        Set clzImplSet;
        if (!cacheMap.containsKey(bankVersionID) && (clzImplSet = ReflectUtil.getSubTypesOf(ISDKFetchReceiptHandle.class)) != null) {
            for (Class c : clzImplSet) {
                try {
                    ISDKFetchReceiptHandle instance = (ISDKFetchReceiptHandle)c.newInstance();
                    cacheMap.put(instance.getBankVersionID(), instance);
                }
                catch (Throwable e) {
                    this.logger.error("\u5b9a\u5236\u5316\u5f00\u53d1\u94f6\u884c\u52a0\u8f7d\u56de\u5355\u4e1a\u52a1Fetch\u5b9e\u73b0\u7c7b\u5f02\u5e38", e);
                }
            }
        }
        ISDKFetchReceiptHandle isdkFetchReceiptHandle = cacheMap.get(bankVersionID);
        return isdkFetchReceiptHandle;
    }

    public boolean match(BankReceiptHandleRequest request) {
        if (request == null) {
            return false;
        }
        Integer status = request.getTaskStatus();
        if (status == null) {
            return false;
        }
        return status.intValue() == TaskStatus.PROCESSING.getId();
    }

    public BankReceiptHandleResponseEB doBiz(BankReceiptHandleRequest request) {
        ISDKFetchReceiptHandle isdkFetchReceiptHandle = this.getImplFromCache();
        SDKBankReceiptHandleResponse receiptHandleResponse = isdkFetchReceiptHandle.doBiz(this.transFormat(request));
        return this.transFormat(receiptHandleResponse, request.getHeader());
    }

    public boolean isBreak() {
        ISDKFetchReceiptHandle isdkFetchReceiptHandle = this.getImplFromCache();
        return isdkFetchReceiptHandle.isBreak();
    }
}

