/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.receipt.banks.zzb.dc.service.receipt.api;

import java.time.LocalDate;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.resource.ResManager;
import kd.ebg.egf.common.context.EBContext;
import kd.ebg.egf.common.framework.communication.ConnectionFactory;
import kd.ebg.egf.common.utils.LocalDateUtil;
import kd.ebg.egf.common.utils.xml.JDomUtils;
import kd.ebg.receipt.banks.zzb.dc.service.receipt.util.RequestPack;
import kd.ebg.receipt.business.receipt.atom.AbstractBankReceiptImpl;
import kd.ebg.receipt.business.receipt.atom.IBankReceipt;
import kd.ebg.receipt.business.receipt.bank.frontProxy.BankReceiptRequest;
import kd.ebg.receipt.business.receipt.bank.frontProxy.BankReceiptResponseEB;
import kd.ebg.receipt.common.framework.frame.EBGLogger;
import kd.ebg.receipt.common.framework.receipt.exception.ReceiptException;
import org.jdom2.Element;

public class ZzbBankDetailRequestImpl
extends AbstractBankReceiptImpl
implements IBankReceipt {
    private static EBGLogger logger = EBGLogger.getInstance().getLogger(ZzbBankDetailRequestImpl.class);

    public String pack(BankReceiptRequest request) {
        String bankVersionId = EBContext.getContext().getBankVersionID();
        String bankLoginID = EBContext.getContext().getBankLoginID();
        String accNo = request.getAccNo();
        LocalDate transDate = request.getTransDate();
        String requestStr = request.getRequestStr();
        return requestStr;
    }

    public BankReceiptResponseEB parse(BankReceiptRequest request, String responseStr) {
        String bankVersionId = EBContext.getContext().getBankVersionID();
        String bankLoginID = EBContext.getContext().getBankLoginID();
        String accNo = request.getAccNo();
        LocalDate transDate = request.getTransDate();
        return BankReceiptResponseEB.success(this.detailParser(responseStr));
    }

    public String getDeveloper() {
        return null;
    }

    public String getBizCode() {
        return "ZZB_BANK_DETAIL_REQUEST";
    }

    public String getBizDesc() {
        return ResManager.loadKDString((String)"\u90d1\u5dde\u94f6\u884c\u4ea4\u6613\u660e\u7ec6\u63a5\u53e3\u8bf7\u6c42\u3002", (String)"ZzbBankDetailRequestImpl_0", (String)"ebg-receipt-banks-zzb-dc", (Object[])new Object[0]);
    }

    public void configFactory(ConnectionFactory factory) {
        super.configFactory(factory);
        Map runningParams = EBContext.getContext().getRunningParams();
        String cipher = (String)runningParams.get("userPassword");
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("/eb2e/B2EActTrsQry.do?userPassword=");
        stringBuilder.append(cipher);
        stringBuilder.append("&SIGDATA=0");
        stringBuilder.append("&_locale=zh_CN");
        String uri = stringBuilder.toString();
        factory.setUri(uri);
        factory.setHttpHeader("Content-Type", "application/xml");
    }

    public List<Map<String, String>> detailParser(String response) {
        if (response == null || response.trim().length() == 0) {
            throw new ReceiptException(ResManager.loadKDString((String)"\u94f6\u884c\u8fd4\u56de\u54cd\u5e94\u62a5\u6587\u4e3a\u7a7a\u3002", (String)"ZzbBankDetailRequestImpl_1", (String)"ebg-receipt-banks-zzb-dc", (Object[])new Object[0]));
        }
        Element root = JDomUtils.str2DocUTF8((String)response).getRootElement();
        Element error = root.getChild("error");
        if (error != null) {
            throw new ReceiptException(String.format(ResManager.loadKDString((String)"\u94f6\u884c\u8fd4\u56de\u9519\u8bef\uff1a%s\u3002", (String)"ZzbBankDetailRequestImpl_7", (String)"ebg-receipt-banks-zzb-dc", (Object[])new Object[0]), error.getTextTrim()));
        }
        Element Head = JDomUtils.getUnNullChildElement((Element)root, (String)"Head");
        String IBSReturnCode = JDomUtils.getUnNullChildText((Element)Head, (String)"IBSReturnCode");
        String IBSReturnMsg = JDomUtils.getUnNullChildText((Element)Head, (String)"IBSReturnMsg");
        if ("000000".equalsIgnoreCase(IBSReturnCode)) {
            int pagesTotal;
            Element Body = JDomUtils.getUnNullChildElement((Element)root, (String)"Body");
            String TotleCount = JDomUtils.getUnNullChildText((Element)Body, (String)"TotleCount");
            if ("0".equals(TotleCount)) {
                throw new ReceiptException(ResManager.loadKDString((String)"\u94f6\u884c\u672a\u8fd4\u56de\u56de\u5355\u4fe1\u606f\uff0c\u8bf7\u67e5\u770b\u5f53\u524d\u4efb\u52a1\u662f\u5426\u6709\u4ea4\u6613\u660e\u7ec6\u3002", (String)"ZzbBankDetailRequestImpl_3", (String)"ebg-receipt-banks-zzb-dc", (Object[])new Object[0]));
            }
            ArrayList<Map<String, String>> receiptDetail_list = new ArrayList<Map<String, String>>(16);
            String count = Body.getChildText("TotleCount");
            int totleCount = Integer.parseInt(count);
            if (totleCount == 0) {
                this.setLastPage(true);
                return receiptDetail_list;
            }
            int currentPage = Integer.parseInt(this.getCurrentPage());
            if (currentPage < (pagesTotal = totleCount / 50 + 1)) {
                this.setCurrentPage(currentPage + 1);
            } else {
                this.setLastPage(true);
            }
            Element List2 = JDomUtils.getUnNullChildElement((Element)Body, (String)"List");
            List lists = List2.getChildren("Map");
            lists.forEach(list -> {
                String JnlNo = JDomUtils.getUnNullChildText((Element)list, (String)"JnlNo");
                String Amount = JDomUtils.getUnNullChildText((Element)list, (String)"Amount");
                HashMap<String, String> map = new HashMap<String, String>();
                map.put("JnlNo", JnlNo);
                map.put("Amount", Amount);
                receiptDetail_list.add(map);
            });
            return receiptDetail_list;
        }
        if ("000001".equalsIgnoreCase(IBSReturnCode)) {
            throw new ReceiptException(String.format(ResManager.loadKDString((String)"\u94f6\u884c\u8fd4\u56de\u9519\u8bef\uff0c\u8fd4\u56de\u7801\uff1a%1$s\u94f6\u884c\u54cd\u5e94\u8d85\u65f6\uff0c\u9700\u8981\u91cd\u65b0\u767b\u5f55\u4ee3\u7406\u5de5\u5177\uff0c\u8fd4\u56de\u4fe1\u606f\uff1a%2$s\u3002", (String)"ZzbBankDetailRequestImpl_8", (String)"ebg-receipt-banks-zzb-dc", (Object[])new Object[0]), IBSReturnCode, IBSReturnMsg));
        }
        throw new ReceiptException(String.format(ResManager.loadKDString((String)"\u94f6\u884c\u8fd4\u56de\u9519\u8bef\uff0c\u8fd4\u56de\u7801\uff1a%1$s \u8fd4\u56de\u4fe1\u606f\uff1a%2$s\u3002", (String)"ZzbBankDetailRequestImpl_9", (String)"ebg-receipt-banks-zzb-dc", (Object[])new Object[0]), IBSReturnCode, IBSReturnMsg));
    }

    public static List<Map<String, String>> queryDetailList(String accNo, LocalDate transDate) {
        ArrayList<Map<String, String>> result = new ArrayList<Map<String, String>>(16);
        String transDateStr = LocalDateUtil.formatDate((LocalDate)transDate);
        ZzbBankDetailRequestImpl zzbBankDetailRequest = new ZzbBankDetailRequestImpl();
        zzbBankDetailRequest.setLastPage(false);
        zzbBankDetailRequest.setCurrentPage("1");
        boolean lastPage = false;
        while (!lastPage) {
            String request = RequestPack.detailtRequest(accNo, transDateStr, zzbBankDetailRequest.getCurrentPage());
            BankReceiptRequest bankReceiptRequest = BankReceiptRequest.builder().requestStr(request).accNo(accNo).transDate(transDate).build();
            BankReceiptResponseEB response = zzbBankDetailRequest.doBiz(bankReceiptRequest);
            List responseData = (List)response.getData();
            if (!responseData.isEmpty()) {
                result.addAll(responseData);
            }
            lastPage = zzbBankDetailRequest.isLastPage();
        }
        return result;
    }
}

