/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.receipt.banks.lzb.dc.service.receipt.fetch;

import com.alibaba.fastjson.JSONObject;
import java.time.LocalDate;
import java.util.ArrayList;
import kd.ebg.egf.common.utils.LocalDateUtil;
import kd.ebg.egf.common.utils.Sequence;
import kd.ebg.receipt.banks.lzb.dc.service.receipt.api.BankReceiptApplyRequestImpl;
import kd.ebg.receipt.banks.lzb.dc.service.receipt.utils.Parser;
import kd.ebg.receipt.business.receipt.atom.AbstractBankReceiptHandleImpl;
import kd.ebg.receipt.business.receipt.atom.IBankReceiptHandle;
import kd.ebg.receipt.business.receipt.bank.frontProxy.BankReceiptRequest;
import kd.ebg.receipt.business.receipt.bank.task.BankReceiptHandleRequest;
import kd.ebg.receipt.business.receipt.bank.task.BankReceiptHandleResponseEB;
import kd.ebg.receipt.business.receipt.entity.TaskStatus;
import kd.ebg.receipt.common.model.receipt.DownloadListDetail;

public class BankReceiptFetchListImpl
extends AbstractBankReceiptHandleImpl
implements IBankReceiptHandle {
    public boolean match(BankReceiptHandleRequest request) {
        if (request == null) {
            return false;
        }
        Integer status = request.getTaskStatus();
        if (status == null) {
            return false;
        }
        return status.intValue() == TaskStatus.PROCESSING.getId();
    }

    public BankReceiptHandleResponseEB doBiz(BankReceiptHandleRequest request) {
        String accNo = request.getAccNo();
        LocalDate transDate = request.getTransDate();
        ArrayList<DownloadListDetail> result = new ArrayList<DownloadListDetail>(16);
        String batchNo = Sequence.gen16Sequence();
        BankReceiptApplyRequestImpl bankReceiptApplyRequest = new BankReceiptApplyRequestImpl();
        BankReceiptRequest bankReceiptRequest = BankReceiptRequest.builder().accNo(accNo).transDate(transDate).requestStr(batchNo).build();
        bankReceiptApplyRequest.doBiz(bankReceiptRequest);
        DownloadListDetail downloadListDetail = new DownloadListDetail();
        JSONObject jsonObject = new JSONObject();
        jsonObject.put("batch_no", (Object)batchNo);
        jsonObject.put("apply_date", (Object)LocalDateUtil.formatDate((LocalDate)LocalDate.now()));
        downloadListDetail.setFileName(batchNo + ".zip");
        downloadListDetail.setFileLink(jsonObject.toJSONString());
        result.add(downloadListDetail);
        Parser.sleepInterval();
        return BankReceiptHandleResponseEB.success(result);
    }

    public String getDeveloper() {
        return null;
    }

    public String getBizCode() {
        return "";
    }

    public String getBizDesc() {
        return null;
    }

    public boolean isBreak() {
        return true;
    }
}

