/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.receipt.banks.gzrcb.dc.service.receipt;

import com.alibaba.fastjson.JSONObject;
import com.google.common.collect.Maps;
import java.time.LocalDate;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.resource.ResManager;
import kd.ebg.egf.common.context.EBContext;
import kd.ebg.egf.common.framework.bank.info.BankRequest;
import kd.ebg.egf.common.model.detail.DetailInfoOnReceipt;
import kd.ebg.egf.common.utils.FetchDataUtils;
import kd.ebg.receipt.banks.gzrcb.dc.service.receipt.GzrcbDcCommConfig;
import kd.ebg.receipt.banks.gzrcb.dc.service.receipt.api.BankReceiptInfoQueryImpl;
import kd.ebg.receipt.business.receipt.atom.AbstractBankReceiptHandleImpl;
import kd.ebg.receipt.business.receipt.atom.IBankReceiptHandle;
import kd.ebg.receipt.business.receipt.bank.frontProxy.BankReceiptRequest;
import kd.ebg.receipt.business.receipt.bank.frontProxy.BankReceiptResponseEB;
import kd.ebg.receipt.business.receipt.bank.task.BankReceiptHandleRequest;
import kd.ebg.receipt.business.receipt.bank.task.BankReceiptHandleResponseEB;
import kd.ebg.receipt.business.receipt.entity.TaskStatus;
import kd.ebg.receipt.common.constant.MatchStatusEnum;
import kd.ebg.receipt.common.constant.UploadStatusEnum;
import kd.ebg.receipt.common.framework.frame.EBGLogger;
import kd.ebg.receipt.common.framework.receipt.exception.ReceiptException;
import kd.ebg.receipt.common.framework.receipt.util.EBConfigBuilder;
import kd.ebg.receipt.common.framework.services.receipt.DownloadListDetailService;
import kd.ebg.receipt.common.model.receipt.DownloadListDetail;
import kd.ebg.receipt.common.utils.SpringContextUtil;

public class BankReceiptFetchListImpl
extends AbstractBankReceiptHandleImpl
implements IBankReceiptHandle {
    private static EBGLogger log = EBGLogger.getInstance().getLogger(BankReceiptFetchListImpl.class);
    public DownloadListDetailService downloadListDetailService;

    public boolean match(BankReceiptHandleRequest request) {
        if (request == null) {
            return false;
        }
        Integer status = request.getTaskStatus();
        if (status == null) {
            return false;
        }
        return status.intValue() == TaskStatus.PROCESSING.getId();
    }

    public void init(BankReceiptHandleRequest request) {
        this.downloadListDetailService = (DownloadListDetailService)SpringContextUtil.getBean(DownloadListDetailService.class);
    }

    public BankReceiptHandleResponseEB doBiz(BankReceiptHandleRequest request) {
        this.init(request);
        String accNo = request.getAccNo();
        LocalDate transDate = request.getTransDate();
        ArrayList<Object> result = new ArrayList<Object>(16);
        String bankLoginId = EBContext.getContext().getBankLoginID();
        GzrcbDcCommConfig config = (GzrcbDcCommConfig)EBConfigBuilder.getInstance().buildConfig(GzrcbDcCommConfig.class, bankLoginId);
        String userId = config.getUSERID();
        HashMap paramsMap = Maps.newHashMapWithExpectedSize((int)16);
        paramsMap.put("userId", userId);
        paramsMap.put("TEST_TRANSDATE", config.getTEST_TRANSDATE());
        String bankCurrency = request.getHeader().getAcnt().getCurrency();
        List detailInfoList = FetchDataUtils.queryDetailFromReceipt((String)request.getBankVersionId(), (String)request.getBankLoginId(), (String)accNo, (LocalDate)transDate, (String)bankCurrency);
        List downloadListDetails = this.downloadListDetailService.selectByRefId(request.getTaskId());
        HashMap existDownloadMap = Maps.newHashMapWithExpectedSize((int)1);
        for (DownloadListDetail downloadListDetail : downloadListDetails) {
            if (downloadListDetail.getUploadFlag().intValue() != UploadStatusEnum.UPLOAD_SUCCESS.getId() && downloadListDetail.getMatchFlag().intValue() != MatchStatusEnum.SUCCESS.getId()) continue;
            existDownloadMap.put(downloadListDetail.getFileName(), downloadListDetail);
        }
        for (DetailInfoOnReceipt detailInfoOnReceipt : detailInfoList) {
            JSONObject jsonObject = JSONObject.parseObject((String)detailInfoOnReceipt.getJsonMap());
            String newFileName = accNo + "_" + transDate + "_" + jsonObject.getString("GUIYLS") + "_" + jsonObject.getString("DAYIJE") + ".pdf";
            if (existDownloadMap.containsKey(newFileName)) {
                result.add(existDownloadMap.get(newFileName));
                continue;
            }
            String SERNUM = jsonObject.getString("SERNUM");
            paramsMap.remove("SERNUM");
            paramsMap.put("SERNUM", SERNUM);
            BankReceiptRequest bankReceiptReq = BankReceiptRequest.builder().transDate(transDate).accNo(accNo).paramsMap((Map)paramsMap).build();
            BankReceiptInfoQueryImpl bankReceiptInfoQuery = new BankReceiptInfoQueryImpl();
            BankReceiptResponseEB receiptResponseEB = (BankReceiptResponseEB)bankReceiptInfoQuery.doBiz((BankRequest)bankReceiptReq);
            String fileName = (String)receiptResponseEB.getData();
            DownloadListDetail detail = new DownloadListDetail();
            detail.setFileLink(fileName);
            detail.setFileName(newFileName);
            result.add(detail);
        }
        if (result.size() == 0) {
            throw new ReceiptException(ResManager.loadKDString((String)"\u672c\u6b21\u4efb\u52a1\u83b7\u53d6\u7684\u56de\u5355\u6587\u4ef6\u5217\u8868\u4e3a\u7a7a\u3002", (String)"BankReceiptFetchListImpl_0", (String)"ebg-receipt-banks-gzrcb-dc", (Object[])new Object[0]));
        }
        return BankReceiptHandleResponseEB.success(result);
    }

    public String getDeveloper() {
        return null;
    }

    public String getBizCode() {
        return "GZRCB_BankReceiptFetchList";
    }

    public String getBizDesc() {
        return ResManager.loadKDString((String)"\u83b7\u53d6\u5e7f\u5dde\u519c\u5546\u94f6\u884c\u56de\u5355\u6587\u4ef6\u5217\u8868\u3002", (String)"BankReceiptFetchListImpl_1", (String)"ebg-receipt-banks-gzrcb-dc", (Object[])new Object[0]);
    }

    public boolean isBreak() {
        return true;
    }
}

