/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.receipt.banks.ceb.dc.service.receipt;

import java.time.LocalDate;
import kd.ebg.egf.common.context.EBContext;
import kd.ebg.egf.common.utils.LocalDateUtil;
import kd.ebg.receipt.banks.ceb.dc.service.CebDCCommConfig;
import kd.ebg.receipt.common.framework.receipt.parse.impl.AbstractFileParser;
import kd.ebg.receipt.common.framework.receipt.util.EBConfigBuilder;

public class CebDcFileParser
extends AbstractFileParser {
    public String getAccNo() {
        return this.getParsedString(0);
    }

    public LocalDate getDate() {
        String bankLoginId = EBContext.getContext().getBankLoginID();
        CebDCCommConfig config = (CebDCCommConfig)EBConfigBuilder.getInstance().buildConfig(CebDCCommConfig.class, bankLoginId);
        boolean isPdf = config.getReceiptFileType().equals("PDF");
        if (isPdf) {
            return LocalDateUtil.parserDate((String)this.getParsedString(1));
        }
        String date = this.getParsedString(1);
        date = date.substring(0, 8);
        return LocalDateUtil.parserDate((String)date);
    }

    public String getReceiptNo() {
        String receiptNo = this.getParsedString(2);
        return receiptNo;
    }

    public String getAmount() {
        String amount = this.getParsedString(3);
        return amount;
    }

    public String getFileSplit() {
        return "_";
    }

    public String getBankVersion() {
        return "CEB_DC";
    }
}

