/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.receipt.banks.ceb.dc.service.receipt.api.ofd;

import java.time.LocalDate;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import kd.bos.dataentity.resource.ResManager;
import kd.ebg.egf.common.context.EBContext;
import kd.ebg.egf.common.framework.communication.ConnectionFactory;
import kd.ebg.egf.common.framework.frame.Sequence;
import kd.ebg.egf.common.utils.LocalDateUtil;
import kd.ebg.egf.common.utils.xml.JDomUtils;
import kd.ebg.receipt.banks.ceb.dc.service.CebDCCommConfig;
import kd.ebg.receipt.banks.ceb.dc.service.receipt.util.ofd.OFDPacker;
import kd.ebg.receipt.banks.ceb.dc.service.receipt.util.ofd.OFDParse;
import kd.ebg.receipt.banks.ceb.dc.service.receipt.util.ofd.ReceiptQueryInfo;
import kd.ebg.receipt.business.receipt.atom.AbstractBankReceiptImpl;
import kd.ebg.receipt.business.receipt.atom.IBankReceipt;
import kd.ebg.receipt.business.receipt.bank.frontProxy.BankReceiptRequest;
import kd.ebg.receipt.business.receipt.bank.frontProxy.BankReceiptResponseEB;
import kd.ebg.receipt.common.framework.frame.EBGLogger;
import kd.ebg.receipt.common.framework.receipt.constant.RetryErrorEnum;
import kd.ebg.receipt.common.framework.receipt.exception.ReceiptException;
import kd.ebg.receipt.common.framework.receipt.util.EBConfigBuilder;
import org.jdom2.Element;

public class BankReceiptFileAppointmentQueryImpl
extends AbstractBankReceiptImpl
implements IBankReceipt {
    private static EBGLogger logger = EBGLogger.getInstance().getLogger(BankReceiptFileAppointmentQueryImpl.class);

    public String pack(BankReceiptRequest request) {
        String bankLoginId = EBContext.getContext().getBankLoginID();
        CebDCCommConfig config = (CebDCCommConfig)EBConfigBuilder.getInstance().buildConfig(CebDCCommConfig.class, bankLoginId);
        String accNo = request.getAccNo();
        LocalDate transDate = request.getTransDate();
        String transDateStr = LocalDateUtil.formatDate((LocalDate)transDate);
        Map paramsMap = request.getParamsMap();
        String clientBchID = (String)paramsMap.get("ClientBchID");
        String clientPchID = (String)paramsMap.get("ClientPchID");
        String cifNo = config.getCifNo();
        String seqNo = cifNo + transDateStr + Sequence.gen16Sequence();
        String clientPatchID = seqNo + "0001";
        Element headElement = OFDPacker.buildHead("b2e004034", seqNo);
        Element transContentElement = OFDPacker.buildB2e004034TransContent(clientPatchID, clientBchID, clientPchID);
        Element systemHeadElement = OFDPacker.buildSystemHead();
        String requestToXml = OFDPacker.requestToXml(systemHeadElement, headElement, transContentElement);
        return requestToXml;
    }

    public BankReceiptResponseEB parse(BankReceiptRequest request, String responseStr) {
        String accNo = request.getAccNo();
        LocalDate transDate = request.getTransDate();
        String transDateStr = LocalDateUtil.formatDate((LocalDate)transDate);
        Element root = JDomUtils.str2DocGBK((String)responseStr).getRootElement();
        OFDParse.handleErrorResponse(root, "b2e004034");
        Element transContentElement = OFDParse.getUnNullChildElement(root, "TransContent");
        String returnCode = OFDParse.getChildText(transContentElement, "ReturnCode");
        String returnMsg = OFDParse.getChildText(transContentElement, "ReturnMsg");
        String status = OFDParse.getChildText(transContentElement, "Status");
        if (Objects.equals(status, "0")) {
            Element batchRespListElement = OFDParse.getUnNullChildElement(transContentElement, "BatchRespList");
            List batchRespList = batchRespListElement.getChildren();
            ArrayList<ReceiptQueryInfo> receiptQueryInfoList = new ArrayList<ReceiptQueryInfo>(16);
            for (int i = 0; i < batchRespList.size(); ++i) {
                Element element = (Element)batchRespList.get(i);
                String fileName = OFDParse.getChildText(element, "FileName");
                String filePath = OFDParse.getChildText(element, "FilePath");
                ReceiptQueryInfo receiptQueryInfo = new ReceiptQueryInfo();
                receiptQueryInfo.setFileName(fileName);
                receiptQueryInfo.setFilePath(filePath);
                receiptQueryInfoList.add(receiptQueryInfo);
            }
            return BankReceiptResponseEB.success(receiptQueryInfoList);
        }
        if (Objects.equals(status, "1")) {
            StringBuilder errorMsg = new StringBuilder();
            errorMsg.append(ResManager.loadKDString((String)"b2e004034\u63a5\u53e3\u8fd4\u56de\u9519\u8bef\uff1a\u9519\u8bef\u7801\uff1a", (String)"BankReceiptFileAppointmentQueryImpl_0", (String)"ebg-receipt-banks-ceb-dc", (Object[])new Object[0])).append(returnCode).append("\u3002");
            errorMsg.append(ResManager.loadKDString((String)"\u9519\u8bef\u63cf\u8ff0", (String)"BankReceiptFileAppointmentQueryImpl_1", (String)"ebg-receipt-banks-ceb-dc", (Object[])new Object[0])).append(returnMsg).append("\u3002");
            throw new ReceiptException(errorMsg.toString());
        }
        if (Objects.equals(status, "2")) {
            throw new ReceiptException(RetryErrorEnum.BANK_PROCESSING.getMsg());
        }
        if (Objects.equals(status, "3")) {
            throw new ReceiptException(ResManager.loadKDString((String)"\u65e0\u56de\u5355\u8bb0\u5f55", (String)"BankReceiptFileAppointmentQueryImpl_2", (String)"ebg-receipt-banks-ceb-dc", (Object[])new Object[0]));
        }
        if (Objects.equals(status, "4")) {
            throw new ReceiptException(ResManager.loadKDString((String)"\u5386\u53f2\u56de\u5355\u7b14\u6570\u8d85\u8fc7\u6700\u5927\u503c\u9650\u5236\uff0c\u6587\u4ef6\u751f\u6210\u5931\u8d25\u3002", (String)"BankReceiptFileAppointmentQueryImpl_3", (String)"ebg-receipt-banks-ceb-dc", (Object[])new Object[0]));
        }
        StringBuilder errorMsg = new StringBuilder();
        errorMsg.append(ResManager.loadKDString((String)"b2e004034\u63a5\u53e3\u8fd4\u56de\u9519\u8bef\uff1a\u9519\u8bef\u7801\uff1a", (String)"BankReceiptFileAppointmentQueryImpl_0", (String)"ebg-receipt-banks-ceb-dc", (Object[])new Object[0])).append(returnCode).append("\u3002");
        errorMsg.append(ResManager.loadKDString((String)"\u9519\u8bef\u63cf\u8ff0", (String)"BankReceiptFileAppointmentQueryImpl_1", (String)"ebg-receipt-banks-ceb-dc", (Object[])new Object[0])).append(returnMsg).append("\u3002");
        throw new ReceiptException(errorMsg.toString());
    }

    public String getDeveloper() {
        return "LV";
    }

    public String getBizCode() {
        return "b2e004034";
    }

    public String getBizDesc() {
        return ResManager.loadKDString((String)"\u5149\u5927\u94f6\u884c\u94f6\u884c\u56de\u5355\u6587\u4ef6\u4e0b\u8f7d\u8bf7\u6c42\u3002", (String)"BankReceiptFileAppointmentQueryImpl_4", (String)"ebg-receipt-banks-ceb-dc", (Object[])new Object[0]);
    }

    public void configFactory(ConnectionFactory factory) {
        super.configFactory(factory);
        String bankLoginId = EBContext.getContext().getBankLoginID();
        CebDCCommConfig config = (CebDCCommConfig)EBConfigBuilder.getInstance().buildConfig(CebDCCommConfig.class, bankLoginId);
        String cipher = config.getCipher();
        String userId = config.getUserID();
        StringBuilder uriBuilder = new StringBuilder();
        uriBuilder.append("/ent/b2e004034.do?");
        uriBuilder.append("usrID=").append(userId);
        uriBuilder.append("&userPassword=").append(cipher);
        factory.setUri(uriBuilder.toString());
        factory.setHttpHeader("Content-Type", "application/xml");
    }
}

