/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.receipt.banks.ceb.dc.service.reconciliation.api;

import com.alibaba.fastjson.JSONObject;
import java.time.LocalDate;
import java.util.Map;
import java.util.Objects;
import kd.bos.dataentity.resource.ResManager;
import kd.ebg.egf.common.context.EBContext;
import kd.ebg.egf.common.framework.communication.ConnectionFactory;
import kd.ebg.egf.common.utils.LocalDateUtil;
import kd.ebg.egf.common.utils.xml.JDomUtils;
import kd.ebg.receipt.banks.ceb.dc.service.CebDCCommConfig;
import kd.ebg.receipt.banks.ceb.dc.service.receipt.util.ofd.OFDPacker;
import kd.ebg.receipt.banks.ceb.dc.service.receipt.util.ofd.OFDParse;
import kd.ebg.receipt.business.receipt.atom.reconciliation.AbstractBankReconciliationImpl;
import kd.ebg.receipt.business.receipt.atom.reconciliation.IBankReconciliation;
import kd.ebg.receipt.business.receipt.bank.frontProxy.reconciliation.BankReconciliationRequest;
import kd.ebg.receipt.business.receipt.bank.frontProxy.reconciliation.BankReconciliationResponseEB;
import kd.ebg.receipt.common.framework.frame.EBGLogger;
import kd.ebg.receipt.common.framework.receipt.exception.ReceiptException;
import kd.ebg.receipt.common.framework.receipt.util.EBConfigBuilder;
import org.jdom2.Element;

public class BankReconciliationFileAppointmentImpl
extends AbstractBankReconciliationImpl
implements IBankReconciliation {
    private static EBGLogger logger = EBGLogger.getInstance().getLogger(BankReconciliationFileAppointmentImpl.class);

    public String pack(BankReconciliationRequest request) {
        String accNo = request.getAccNo();
        LocalDate transDate = request.getTransDate();
        String transDateStr = LocalDateUtil.formatDate((LocalDate)transDate);
        Map paramsMap = request.getParamsMap();
        String seqNo = (String)paramsMap.get("seqNo");
        String clientPatchID = seqNo + "0001";
        Element headElement = OFDPacker.buildHead("b2e004036", seqNo);
        Element transContentElement = OFDPacker.buildB2e004036TransContent(clientPatchID, accNo, transDate);
        Element systemHeadElement = OFDPacker.buildSystemHead();
        String requestToXml = OFDPacker.requestToXml(systemHeadElement, headElement, transContentElement);
        return requestToXml;
    }

    public BankReconciliationResponseEB parse(BankReconciliationRequest request, String responseStr) {
        Element respDataElement;
        String flag;
        String accNo = request.getAccNo();
        LocalDate transDate = request.getTransDate();
        String transDateStr = LocalDateUtil.formatDate((LocalDate)transDate);
        Element root = JDomUtils.str2DocGBK((String)responseStr).getRootElement();
        OFDParse.handleErrorResponse(root, "b2e004036");
        Element transContentElement = OFDParse.getUnNullChildElement(root, "TransContent");
        String returnCode = OFDParse.getChildText(transContentElement, "ReturnCode");
        String returnMsg = OFDParse.getChildText(transContentElement, "ReturnMsg");
        if (Objects.equals(returnCode, "0000") && Objects.equals(flag = OFDParse.getChildText(respDataElement = OFDParse.getUnNullChildElement(transContentElement, "RespData"), "Flag"), "0")) {
            Map paramsMap = request.getParamsMap();
            String seqNo = (String)paramsMap.get("seqNo");
            String clientPatchID = seqNo + "0001";
            JSONObject jsonObject = new JSONObject();
            jsonObject.put("ClientBchID", (Object)seqNo);
            jsonObject.put("ClientPchID", (Object)clientPatchID);
            return BankReconciliationResponseEB.success((Object)jsonObject.toJSONString());
        }
        StringBuilder errorMsg = new StringBuilder();
        errorMsg.append(ResManager.loadKDString((String)"b2e004032\u63a5\u53e3\u8fd4\u56de\u9519\u8bef\uff1a\u9519\u8bef\u7801\uff1a", (String)"BankReconciliationFileAppointmentImpl_0", (String)"ebg-receipt-banks-ceb-dc", (Object[])new Object[0])).append(returnCode).append("\u3002");
        errorMsg.append(ResManager.loadKDString((String)"\u9519\u8bef\u63cf\u8ff0\uff1a", (String)"BankReconciliationFileAppointmentImpl_1", (String)"ebg-receipt-banks-ceb-dc", (Object[])new Object[0])).append(returnMsg).append("\u3002");
        throw new ReceiptException(errorMsg.toString());
    }

    public String getDeveloper() {
        return "LV";
    }

    public String getBizCode() {
        return "b2e004036";
    }

    public String getBizDesc() {
        return ResManager.loadKDString((String)"\u5149\u5927\u94f6\u884c\u94f6\u884c\u5bf9\u8d26\u5355\u6587\u4ef6\u4e0b\u8f7d\u8bf7\u6c42", (String)"BankReconciliationFileAppointmentImpl_2", (String)"ebg-receipt-banks-ceb-dc", (Object[])new Object[0]);
    }

    public void configFactory(ConnectionFactory factory) {
        super.configFactory(factory);
        String bankLoginId = EBContext.getContext().getBankLoginID();
        CebDCCommConfig config = (CebDCCommConfig)EBConfigBuilder.getInstance().buildConfig(CebDCCommConfig.class, bankLoginId);
        String cipher = config.getCipher();
        String userId = config.getUserID();
        StringBuilder uriBuilder = new StringBuilder();
        uriBuilder.append("/ent/b2e004036.do?");
        uriBuilder.append("usrID=").append(userId);
        uriBuilder.append("&userPassword=").append(cipher);
        uriBuilder.append("&Sigdata=").append("1");
        factory.setUri(uriBuilder.toString());
        factory.setHttpHeader("Content-Type", "application/xml");
    }
}

