/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.receipt.banks.gdnxs.dc.service;

import com.jcraft.jsch.ChannelSftp;
import java.io.File;
import java.time.LocalDate;
import java.util.ArrayList;
import java.util.List;
import kd.ebg.egf.common.log.EBGLogger;
import kd.ebg.egf.common.utils.LocalDateUtil;
import kd.ebg.receipt.business.receipt.atom.AbstractBankReceiptHandleImpl;
import kd.ebg.receipt.business.receipt.atom.IBankReceiptHandle;
import kd.ebg.receipt.business.receipt.bank.task.BankReceiptHandleRequest;
import kd.ebg.receipt.business.receipt.bank.task.BankReceiptHandleResponseEB;
import kd.ebg.receipt.business.receipt.entity.TaskStatus;
import kd.ebg.receipt.business.receipt.utils.BankReceiptApiUtil;
import kd.ebg.receipt.common.constant.UploadStatusEnum;
import kd.ebg.receipt.common.core.utils.EBGStringUtils;
import kd.ebg.receipt.common.framework.receipt.bank.BankFtpProperties;
import kd.ebg.receipt.common.framework.receipt.util.EBConfigBuilder;
import kd.ebg.receipt.common.framework.receipt.util.FileStorageUtil;
import kd.ebg.receipt.common.framework.receipt.util.SFTPUtils;
import kd.ebg.receipt.common.framework.services.receipt.DownloadListDetailService;
import kd.ebg.receipt.common.model.receipt.DownloadListDetail;
import kd.ebg.receipt.common.utils.FileCommonUtils;
import kd.ebg.receipt.common.utils.SpringContextUtil;

public class BankReceiptDownloadImpl
extends AbstractBankReceiptHandleImpl
implements IBankReceiptHandle {
    private static EBGLogger logger = EBGLogger.getInstance().getLogger(BankReceiptDownloadImpl.class);
    public DownloadListDetailService downloadListDetailService;

    public String getDeveloper() {
        return null;
    }

    public String getBizCode() {
        return null;
    }

    public String getBizDesc() {
        return null;
    }

    public boolean match(BankReceiptHandleRequest request) {
        if (request == null) {
            return false;
        }
        Integer status = request.getTaskStatus();
        if (status == null) {
            return false;
        }
        return status.intValue() == TaskStatus.DOWNLOADING.getId();
    }

    public void init(BankReceiptHandleRequest request) {
        this.downloadListDetailService = (DownloadListDetailService)SpringContextUtil.getBean(DownloadListDetailService.class);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public BankReceiptHandleResponseEB doBiz(BankReceiptHandleRequest request) {
        this.init(request);
        String bankVersionId = request.getBankVersionId();
        String accNo = request.getAccNo();
        LocalDate transDate = request.getTransDate();
        Long taskId = request.getTaskId();
        String bakFilePath = FileStorageUtil.getFileBakPathByAccNoAndDate((String)bankVersionId, (String)accNo, (String)LocalDateUtil.formatDate((LocalDate)transDate));
        BankFtpProperties bankFtpProperties = (BankFtpProperties)EBConfigBuilder.getInstance().buildConfig(BankFtpProperties.class, request.getBankLoginId());
        ChannelSftp sftp = null;
        if (bankFtpProperties.getReceiptAchieveWay().equals("sftp")) {
            sftp = SFTPUtils.getInstance().getSftp(request.getBankLoginId());
        }
        ArrayList<DownloadListDetail> result = new ArrayList<DownloadListDetail>(1);
        ArrayList<Long> deleteIds = new ArrayList<Long>(1);
        List downloadListDetails = this.downloadListDetailService.selectByRefId(taskId);
        try {
            for (int i = 0; i < downloadListDetails.size(); ++i) {
                DownloadListDetail detail = (DownloadListDetail)downloadListDetails.get(i);
                if (detail.getUploadFlag().intValue() == UploadStatusEnum.UPLOAD_SUCCESS.getId()) {
                    result.add(detail);
                    continue;
                }
                boolean isSuccess = this.download(detail, bakFilePath, accNo, transDate, bankFtpProperties, sftp);
                if (isSuccess) {
                    result.add(detail);
                    continue;
                }
                deleteIds.add(detail.getId());
            }
        }
        finally {
            if (bankFtpProperties.getReceiptAchieveWay().equals("sftp")) {
                SFTPUtils.getInstance().close(sftp);
            }
        }
        if (!deleteIds.isEmpty()) {
            this.downloadListDetailService.deleteById(deleteIds);
        }
        return BankReceiptHandleResponseEB.success(result);
    }

    public boolean download(DownloadListDetail detail, String bakFilePath, String accNo, LocalDate transDate, BankFtpProperties bankFtpProperties, ChannelSftp sftp) {
        String fileName = detail.getFileLink();
        String newFileName = detail.getFileName();
        try {
            boolean flag = false;
            if (bankFtpProperties.getReceiptAchieveWay().equals("sftp")) {
                String ftpPath = "/";
                String sftpPath = EBGStringUtils.isEmpty((String)bankFtpProperties.getFtpPath()) ? ftpPath : bankFtpProperties.getFtpPath();
                flag = SFTPUtils.getInstance().downloadSingleFile(sftpPath, fileName, bakFilePath, sftp);
            } else if (bankFtpProperties.getReceiptAchieveWay().equals("bank_login")) {
                BankReceiptApiUtil bankReceiptApiUtil = new BankReceiptApiUtil(accNo, transDate);
                String frontProxyPath = bankFtpProperties.getFrontProxyPath();
                flag = bankReceiptApiUtil.downloadReceiptFileWithPath(frontProxyPath, fileName, bakFilePath);
            }
            if (flag) {
                File saveFile = FileCommonUtils.getFileByPath((String)(bakFilePath + File.separator + fileName));
                FileCommonUtils.moveFile((File)saveFile, (String)bakFilePath, (String)newFileName);
            }
            return flag;
        }
        catch (Throwable e) {
            logger.error(e.getMessage(), e);
            return false;
        }
    }
}

