/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.receipt.banks.whsybc.dc.service.utils;

import com.google.common.base.Strings;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import kd.bos.dataentity.resource.ResManager;
import kd.ebg.egf.common.context.EBContext;
import kd.ebg.egf.common.context.RequestContextUtils;
import kd.ebg.egf.common.log.EBGLogger;
import kd.ebg.egf.common.utils.datetime.DateTimeUtils;
import kd.ebg.egf.common.utils.xml.JDomUtils;
import kd.ebg.receipt.banks.whsybc.dc.service.utils.SignHelper;
import kd.ebg.receipt.banks.whsybc.dc.service.utils.StringHelper;
import org.jdom2.Content;
import org.jdom2.Element;

public class PackerHelper {
    private static final EBGLogger logger = EBGLogger.getInstance().getLogger(PackerHelper.class);
    public static final Map<String, String> DSCRPCODEMAP = new HashMap<String, String>(16);
    private static final DateTimeFormatter DATE_TIME_FORMATTER;
    private static final DateTimeFormatter DATE_FORMATTER;
    private static final DateTimeFormatter MONTH_FORMATTER;
    private static final Map<String, Integer> seriMap;

    public static String getThreadSeq() {
        return RequestContextUtils.getRunningParam((String)"ThreadSeq");
    }

    public static void setThreadSeq(String seq) {
        RequestContextUtils.setRunningParam((String)"ThreadSeq", (String)seq);
    }

    public static String formatDateTime(LocalDateTime localDateTime) {
        return localDateTime.format(DATE_TIME_FORMATTER);
    }

    public static String formatDate(LocalDate localDate) {
        return localDate.format(DATE_FORMATTER);
    }

    public static String formatMonth(LocalDate localDate) {
        return localDate.format(MONTH_FORMATTER);
    }

    public static LocalDate parseDate(String str) {
        return LocalDate.parse(str, DATE_FORMATTER);
    }

    public static LocalDateTime parseDateTime(String str) {
        return LocalDateTime.parse(str, DATE_TIME_FORMATTER);
    }

    public static Element createRequestHander(Element element) {
        String dataMsg = JDomUtils.root2StringNoIndentLineNoSeparator((Element)PackerHelper.createSignElement(element), (String)"UTF-8");
        Element transaction = JDomUtils.createRoot((String)"BankData");
        Element sign = new Element("Sign");
        JDomUtils.addChild((Element)sign, (String)"SignedData", (String)SignHelper.sign(dataMsg));
        JDomUtils.addChild((Element)sign, (String)"PubKey", (String)"");
        JDomUtils.addChild((Element)transaction, (Element)sign);
        return transaction;
    }

    public static Element createSignElement(Element element) {
        Element root = new Element("msg");
        Element head = new Element("msg_head");
        JDomUtils.addChild((Element)head, (String)"msg_type", (String)"0");
        JDomUtils.addChild((Element)head, (String)"msg_id", (String)"1005");
        JDomUtils.addChild((Element)head, (String)"msg_sn", (String)"0");
        JDomUtils.addChild((Element)head, (String)"version", (String)"1");
        JDomUtils.addChild((Element)root, (Element)head);
        Element body = new Element("msg_body");
        Element origin_data = new Element("origin_data");
        origin_data.addContent((Content)element.clone());
        JDomUtils.addChild((Element)body, (Element)origin_data);
        JDomUtils.addChild((Element)root, (Element)body);
        return root;
    }

    public static Element createRequestBody(String opName, String serial) {
        Element element = new Element("opReq");
        JDomUtils.addChild((Element)element, (String)"opname", (String)opName);
        JDomUtils.addChild((Element)element, (String)"cstNo", (String)RequestContextUtils.getBankParameterValue((String)"cstNo"));
        JDomUtils.addChild((Element)element, (String)"serialNo", (String)serial);
        JDomUtils.addChild((Element)element, (String)"userId", (String)RequestContextUtils.getBankParameterValue((String)"userId"));
        JDomUtils.addChild((Element)element, (String)"userNo", (String)RequestContextUtils.getBankParameterValue((String)"userNo"));
        JDomUtils.addChild((Element)element, (String)"reqTime", (String)PackerHelper.formatDateTime(LocalDateTime.now()));
        return element;
    }

    public static Element crateParamElement(Map<String, String> map) {
        return PackerHelper.crateElement("ReqParam", map);
    }

    public static Element crateElement(String eleName, Map<String, String> map) {
        Element element = new Element(eleName);
        map.forEach((key, value) -> JDomUtils.addChild((Element)element, (String)key, (String)value));
        return element;
    }

    public static StringBuilder createReportHeader(Element bodyEelement, String opname, String serial) {
        StringBuilder builder = new StringBuilder(serial);
        builder.append(Strings.padStart((String)opname, (int)25, (char)'0'));
        builder.append(Strings.padStart((String)PackerHelper.getElementLength(bodyEelement), (int)8, (char)'0'));
        return builder;
    }

    public static String addUrl() {
        return "/yqbank/APIReqServlet";
    }

    public static synchronized String getSeq() {
        String time = DateTimeUtils.format((Date)new Date(), (String)"yyyyMMddHHmmss");
        Integer seq = seriMap.get(time);
        if (seq == null) {
            if (seriMap.size() > 10) {
                seriMap.clear();
            }
            seriMap.put(time, 1);
        } else {
            seriMap.put(time, seq + 1);
        }
        return DateTimeUtils.format((Date)new Date(), (String)"yyyyMMddHHmmss") + RequestContextUtils.getBankParameterValue((String)"constid") + RequestContextUtils.getBankParameterValue((String)"userId") + StringHelper.leftAddZero(String.valueOf(seriMap.get(time)), 4);
    }

    public static String getElementLength(Element element) {
        int length = 0;
        try {
            String charsetName = EBContext.getContext().getCharsetName();
            length = JDomUtils.root2StringNoIndentLineNoSeparator((Element)element.clone(), (String)charsetName).getBytes(charsetName).length;
        }
        catch (Exception exception) {
            logger.error("\u83b7\u53d6\u62a5\u6587\u957f\u5ea6\u5f02\u5e38", (Throwable)exception);
        }
        return String.valueOf(length);
    }

    public static String packXML(Map<String, String> params, String opName) {
        String serial = PackerHelper.getSeq();
        Element bodyElement = PackerHelper.createRequestBody(opName, serial);
        JDomUtils.addChild((Element)bodyElement, (Element)PackerHelper.crateParamElement(params));
        Element rootElement = PackerHelper.createRequestHander(bodyElement);
        JDomUtils.addChild((Element)rootElement, (Element)bodyElement);
        StringBuilder stringBuilder = PackerHelper.createReportHeader(rootElement, opName, serial);
        return stringBuilder.append(JDomUtils.root2StringNoIndentLineNoSeparator((Element)rootElement, (String)EBContext.getContext().getCharsetName())).toString();
    }

    public static String packXML(Map<String, String> params, String opName, String serialNo) {
        Element bodyElement = PackerHelper.createRequestBody(opName, serialNo);
        JDomUtils.addChild((Element)bodyElement, (Element)PackerHelper.crateParamElement(params));
        Element rootElement = PackerHelper.createRequestHander(bodyElement);
        JDomUtils.addChild((Element)rootElement, (Element)bodyElement);
        StringBuilder stringBuilder = PackerHelper.createReportHeader(rootElement, opName, serialNo);
        return stringBuilder.append(JDomUtils.root2StringNoIndentLineNoSeparator((Element)rootElement, (String)EBContext.getContext().getCharsetName())).toString();
    }

    public static StringBuilder createReportHander(Element bodyEelement, String opname, String serial) {
        String[] arrString = new String[]{StringHelper.leftAddZero(serial, 23), StringHelper.leftAddZero(opname, 25), StringHelper.leftAddZero(StringHelper.getElementLength(bodyEelement), 8)};
        StringBuilder stringBuilder = new StringBuilder();
        for (String string : arrString) {
            stringBuilder.append(string);
        }
        return stringBuilder;
    }

    static {
        DSCRPCODEMAP.put(ResManager.loadKDString((String)"\u76f4\u63a5\u4e0a\u5212", (String)"PackerHelper_0", (String)"ebg-receipt-banks-whsybc-dc", (Object[])new Object[0]), "8201");
        DSCRPCODEMAP.put(ResManager.loadKDString((String)"\u76f4\u63a5\u4e0b\u62e8", (String)"PackerHelper_1", (String)"ebg-receipt-banks-whsybc-dc", (Object[])new Object[0]), "8202");
        DSCRPCODEMAP.put(ResManager.loadKDString((String)"\u540c\u7ea7\u8c03\u62e8", (String)"PackerHelper_2", (String)"ebg-receipt-banks-whsybc-dc", (Object[])new Object[0]), "8205");
        DATE_TIME_FORMATTER = DateTimeFormatter.ofPattern("yyyyMMddHHmmss");
        DATE_FORMATTER = DateTimeFormatter.ofPattern("yyyyMMdd");
        MONTH_FORMATTER = DateTimeFormatter.ofPattern("yyyyMM");
        seriMap = new HashMap<String, Integer>(16);
    }
}

