/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.receipt.banks.bjb.opa.service.utils;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import java.util.Base64;
import java.util.Locale;
import java.util.concurrent.TimeUnit;
import kd.bos.dataentity.resource.ResManager;
import kd.ebg.egf.common.cache.CosmicCache;
import kd.ebg.egf.common.context.RequestContextUtils;
import kd.ebg.egf.common.exception.EBExceiptionUtil;
import kd.ebg.egf.common.framework.security.manage.AESCipherSecurity;
import kd.ebg.egf.common.framework.security.manage.CipherInfo;
import kd.ebg.egf.common.utils.DesUtil;
import kd.ebg.egf.common.utils.string.StringUtils;
import kd.ebg.receipt.banks.bjb.opa.service.config.ConfigProperty;
import kd.ebg.receipt.business.receipt.utils.ShowTipUtil;
import kd.ebg.receipt.common.model.CertInfo;
import kd.ebg.receipt.common.model.repository.UserCertRepository;
import kd.ebg.receipt.common.utils.SpringContextUtil;

public class CommonUtils {
    public static String getKeyValue(String keyId) {
        String key = keyId + "_BJB_OPA_certifyKey";
        String secretKey = CosmicCache.get((String)key);
        if (StringUtils.isEmpty((String)secretKey)) {
            UserCertRepository userCertRepository = (UserCertRepository)SpringContextUtil.getBean(UserCertRepository.class);
            CertInfo certInfo = userCertRepository.findBankLoginCertByBankLoginIDAndBankConfigIDAndCustomID(keyId, RequestContextUtils.getRequestContext().getBankLoginID(), RequestContextUtils.getCustomId());
            AESCipherSecurity security = (AESCipherSecurity)SpringContextUtil.getBean(AESCipherSecurity.class);
            CipherInfo cipherInfo = security.getCipherInfo(certInfo.getFileContent());
            int version = cipherInfo.getCipherVersion();
            byte[] certBytes = org.apache.commons.codec.binary.Base64.decodeBase64((String)cipherInfo.getCipherData());
            byte[] plainData = DesUtil.decryptProxyCert((byte[])certBytes, (String)RequestContextUtils.getCustomId(), (int)version, (String)"");
            secretKey = StringUtils.byteToString((byte[])plainData);
            CosmicCache.putIfAbsentWithExpire((String)key, (String)secretKey, (int)60, (TimeUnit)TimeUnit.SECONDS);
        }
        return secretKey;
    }

    public static String getConfig() {
        return CommonUtils.encodeBase64Mes(CommonUtils.configInit());
    }

    public static String configInit() {
        ConfigProperty configProperty = new ConfigProperty();
        configProperty.setAppID(RequestContextUtils.getBankParameterValue((String)"appId"));
        configProperty.setCaName(RequestContextUtils.getBankParameterValue((String)"caName"));
        configProperty.setCaPrefix(RequestContextUtils.getBankParameterValue((String)"caPrefix"));
        configProperty.setCaPawd(RequestContextUtils.getBankParameterValue((String)"caPawd"));
        configProperty.setCaTopic(RequestContextUtils.getBankParameterValue((String)"caTopic"));
        configProperty.setLoginUserID(RequestContextUtils.getBankParameterValue((String)"loginUserID"));
        configProperty.setLoginUserPWD(RequestContextUtils.getBankParameterValue((String)"loginUserPWD"));
        configProperty.setOpenCaDir(RequestContextUtils.getBankParameterValue((String)"openCaDir"));
        configProperty.setOpenCaName(RequestContextUtils.getBankParameterValue((String)"openCaName"));
        String openIp = RequestContextUtils.getBankParameterValue((String)"openIp");
        String openPort = RequestContextUtils.getBankParameterValue((String)"openPort");
        String openProtocol = RequestContextUtils.getBankParameterValue((String)"openProtocol").toLowerCase(Locale.ROOT);
        String publicUrl = openProtocol + "://" + openIp + ":" + openPort;
        configProperty.setPublicUrl(publicUrl);
        configProperty.setAppPublicKey(CommonUtils.getKeyValue("appPublicKey"));
        configProperty.setKeyStringA1(CommonUtils.getKeyValue("KeyStringA1"));
        configProperty.setKeyStringA2(CommonUtils.getKeyValue("KeyStringA2"));
        configProperty.setPublicKey(CommonUtils.getKeyValue("publicKey"));
        configProperty.setMerchantPrivateKey(CommonUtils.getKeyValue("merchantPrivate"));
        return JSON.toJSON((Object)configProperty).toString();
    }

    public static void checkSuccess(String res) {
        JSONObject response = JSONObject.parseObject((String)res);
        JSONArray ret = response.getJSONArray("ret");
        JSONObject jsonObject = ret.getJSONObject(0);
        String retCode = jsonObject.getString("retCode");
        String retMsg = jsonObject.getString("retMsg");
        if (!"0000".equals(retCode)) {
            throw EBExceiptionUtil.serviceException((String)ShowTipUtil.getResponseErrorTips((String)retCode, (String)retMsg));
        }
    }

    public static String decodeBase64Mes(String text) {
        if (StringUtils.isEmpty((String)text)) {
            throw EBExceiptionUtil.serviceException((String)ResManager.loadKDString((String)"\u7f16\u7801\u5185\u5bb9\u4e0d\u80fd\u4e3a\u7a7a", (String)"CommonUtils_0", (String)"ebg-receipt-banks-bjb-opa", (Object[])new Object[0]));
        }
        try {
            Base64.Decoder decoder = Base64.getDecoder();
            byte[] decodedBytes = decoder.decode(text.getBytes("UTF-8"));
            return new String(decodedBytes, "UTF-8");
        }
        catch (Exception e) {
            throw EBExceiptionUtil.serviceException((String)e.getMessage());
        }
    }

    public static String encodeBase64Mes(String text) {
        if (StringUtils.isEmpty((String)text)) {
            throw EBExceiptionUtil.serviceException((String)ResManager.loadKDString((String)"\u7f16\u7801\u5185\u5bb9\u4e0d\u80fd\u4e3a\u7a7a", (String)"CommonUtils_0", (String)"ebg-receipt-banks-bjb-opa", (Object[])new Object[0]));
        }
        try {
            Base64.Encoder encoder = Base64.getEncoder();
            byte[] encode = encoder.encode(text.getBytes("UTF-8"));
            return new String(encode, "UTF-8");
        }
        catch (Exception e) {
            throw EBExceiptionUtil.serviceException((String)e.getMessage());
        }
    }
}

