/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.receipt.banks.hsb.dc.service.receipt.api;

import com.alibaba.fastjson.JSONObject;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import kd.ebg.egf.common.context.RequestContextUtils;
import kd.ebg.egf.common.framework.communication.ConnectionFactory;
import kd.ebg.egf.common.utils.xml.JDomUtils;
import kd.ebg.receipt.banks.hsb.dc.service.receipt.utils.HSB_DC_Packer;
import kd.ebg.receipt.banks.hsb.dc.service.receipt.utils.HSB_DC_Parser;
import kd.ebg.receipt.business.detail.atomic.AbstractDetailImpl;
import kd.ebg.receipt.business.detail.atomic.IDetail;
import kd.ebg.receipt.business.detail.atomic.IHisDetail;
import kd.ebg.receipt.business.detail.bank.BankDetailRequest;
import kd.ebg.receipt.business.detail.bank.EBBankDetailResponse;
import kd.ebg.receipt.common.framework.match.MatchRule;
import kd.ebg.receipt.common.model.DetailInfo;
import org.jdom2.Element;

public class DetailImpl
extends AbstractDetailImpl
implements IDetail,
IHisDetail {
    public String pack(BankDetailRequest bankDetailRequest) {
        return HSB_DC_Packer.packReceiptDetail(bankDetailRequest);
    }

    public EBBankDetailResponse parse(BankDetailRequest bankDetailRequest, String responseStr) {
        Element body;
        Element dtos;
        List lists;
        EBBankDetailResponse response = new EBBankDetailResponse();
        ArrayList<DetailInfo> detailInfoList = new ArrayList<DetailInfo>(1);
        response.setDetails(detailInfoList);
        this.setLastPage(true);
        String encoding = RequestContextUtils.getCharset();
        responseStr = responseStr.substring(responseStr.indexOf("<ap>"));
        Element root = JDomUtils.string2Root((String)responseStr, (String)encoding);
        Element head = JDomUtils.getUnNullChildElement((Element)root, (String)"head");
        if (HSB_DC_Parser.checkResponseHeader(head) && (lists = (dtos = JDomUtils.getUnNullChildElement((Element)(body = JDomUtils.getUnNullChildElement((Element)root, (String)"body")), (String)"dtos")).getChildren("dto")) != null && lists.size() > 0) {
            int total = 0;
            for (Element element : lists) {
                String total_count = element.getChildTextTrim("total_count");
                if (total_count != null) {
                    total = Integer.parseInt(total_count);
                }
                String tr_acdt = element.getChildTextTrim("tr_acdt");
                String serial_no = element.getChildTextTrim("serial_no");
                String account_seq = element.getChildTextTrim("account_seq");
                String crdr_flag = element.getChildTextTrim("crdr_flag");
                String pay_acct_no = element.getChildTextTrim("pay_acct_no");
                String rcv_acno = element.getChildTextTrim("rcv_acno");
                DetailInfo detailInfo = new DetailInfo();
                detailInfo.setReversed1(tr_acdt);
                detailInfo.setReversed2(serial_no);
                detailInfo.setReversed3(account_seq);
                String json = MatchRule.getInstance().getDetailJsonWithStructuredData(element);
                JSONObject jsonObject = JSONObject.parseObject((String)json);
                jsonObject.put("cdFlag", (Object)crdr_flag);
                jsonObject.put("oppAccNo", (Object)(Objects.equals(pay_acct_no, bankDetailRequest.getAcnt().getAccNo()) ? rcv_acno : pay_acct_no));
                jsonObject.put("serial_no", (Object)String.format("%s_%s", serial_no, account_seq));
                detailInfo.setJson(jsonObject.toJSONString());
                detailInfoList.add(detailInfo);
            }
            int currentPage = Integer.parseInt(this.getCurrentPage());
            int nextCurrentPage = currentPage + lists.size();
            if (nextCurrentPage < total) {
                this.setLastPage(false);
                this.setCurrentPage(nextCurrentPage);
                RequestContextUtils.setRunningParam((String)"tot_rcrd_cnt", (String)Integer.toString(total));
                RequestContextUtils.setRunningParam((String)"rcrd_cnt", (String)Integer.toString(nextCurrentPage));
            }
        }
        return response;
    }

    public int getFirstPage() {
        return 0;
    }

    public String getDeveloper() {
        return null;
    }

    public String getBizCode() {
        return "03020104A0261";
    }

    public String getBizDesc() {
        return null;
    }

    public boolean isSupportPage() {
        return true;
    }

    public void configFactory(ConnectionFactory factory) {
        factory.setHttpHeader("Content-Type", "application/x-www-form-urlencoded");
        factory.setHttpHeader("Content-Encoding", RequestContextUtils.getCharset());
    }
}

