/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.receipt.banks.nbb.opa.service.receipt.api;

import com.alibaba.fastjson.JSONObject;
import java.time.LocalDate;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.TimeUnit;
import kd.bos.dataentity.resource.ResManager;
import kd.ebg.egf.common.cache.CosmicCache;
import kd.ebg.egf.common.context.EBContext;
import kd.ebg.egf.common.context.RequestContextUtils;
import kd.ebg.egf.common.exception.EBExceiptionUtil;
import kd.ebg.egf.common.utils.LocalDateUtil;
import kd.ebg.receipt.banks.nbb.opa.service.receipt.utils.NBBUtil;
import kd.ebg.receipt.business.receipt.atom.AbstractBankReceiptImpl;
import kd.ebg.receipt.business.receipt.atom.IBankReceipt;
import kd.ebg.receipt.business.receipt.bank.frontProxy.BankReceiptRequest;
import kd.ebg.receipt.business.receipt.bank.frontProxy.BankReceiptResponseEB;
import kd.ebg.receipt.common.core.utils.EBGStringUtils;
import kd.ebg.receipt.common.framework.frame.EBGLogger;
import kd.ebg.receipt.common.framework.receipt.exception.ReceiptException;

public class GetReceiptDownloadUrlImpl
extends AbstractBankReceiptImpl
implements IBankReceipt {
    private static EBGLogger logger = EBGLogger.getInstance().getLogger(GetReceiptDownloadUrlImpl.class);

    public String pack(BankReceiptRequest request) {
        return null;
    }

    public BankReceiptResponseEB parse(BankReceiptRequest request, String responseStr) {
        return null;
    }

    public BankReceiptResponseEB doBiz(BankReceiptRequest request) {
        String ret;
        try {
            NBBUtil.initSdk(EBContext.getContext().getCustomID());
            JSONObject reqStr = new JSONObject();
            String custId = RequestContextUtils.getBankParameterValue((String)"custId");
            JSONObject data = new JSONObject();
            data.put("custId", (Object)custId);
            data.put("tradeType", (Object)"RECEIPT");
            data.put("downloadNo", (Object)request.getRequestStr());
            reqStr.put("Data", (Object)data);
            ret = NBBUtil.send("tms", "getGeneralDownloadUrl", reqStr.toJSONString(), this.getBizDesc());
        }
        catch (Exception e) {
            logger.info(e.getMessage());
            throw EBExceiptionUtil.serviceException((String)ResManager.loadKDString((String)"\u94f6\u884c\u8bf7\u6c42\u51fa\u73b0\u5f02\u5e38\u3002", (String)"GetReceiptDownloadUrlImpl_0", (String)"ebg-receipt-banks-nbb-opa", (Object[])new Object[0]), (Throwable)e);
        }
        JSONObject retJson = JSONObject.parseObject((String)ret);
        JSONObject retData = retJson.getJSONObject("Data");
        String code = retData.getString("retCode");
        String msg = retData.getString("retMsg");
        String cacheName = NBBUtil.getCacheName(request.getAccNo(), request.getTransDate());
        if (!"0000".equalsIgnoreCase(code)) {
            CosmicCache.delete((String)cacheName);
            throw EBExceiptionUtil.serviceException((String)String.format(ResManager.loadKDString((String)"\u83b7\u53d6\u56de\u5355\u4e0b\u8f7d\u5730\u5740,\u94f6\u884c\u8fd4\u56de\u9519\u8bef:%s", (String)"GetReceiptDownloadUrlImpl_2", (String)"ebg-receipt-banks-nbb-opa", (Object[])new Object[0]), msg));
        }
        String downloadUrl = retData.getString("downloadUrl");
        String transState = retData.getString("transState");
        if (EBGStringUtils.isNotEmpty((String)downloadUrl) && Objects.equals(transState, "0")) {
            String[] urls = downloadUrl.split(";");
            List<String> list = Arrays.asList(urls);
            if (!list.isEmpty()) {
                CosmicCache.delete((String)cacheName);
                return BankReceiptResponseEB.success(list);
            }
        } else {
            if (Objects.equals(transState, "2")) {
                CosmicCache.putIfAbsentWithExpire((String)cacheName, (String)LocalDateUtil.formatDate((LocalDate)LocalDate.now()), (int)12, (TimeUnit)TimeUnit.HOURS);
                return BankReceiptResponseEB.fail();
            }
            CosmicCache.delete((String)cacheName);
            String transMsg = retData.getString("transMsg");
            throw new ReceiptException(String.format(ResManager.loadKDString((String)"\u56de\u5355\u672a\u751f\u6210,\u63a5\u53e3\u8fd4\u56de\u4fe1\u606f\u63cf\u8ff0:%s\uff0c\u8bf7\u8054\u7cfb\u94f6\u884c\u6392\u67e5\u3002", (String)"GetReceiptDownloadUrlImpl_4", (String)"ebg-receipt-banks-nbb-opa", (Object[])new Object[0]), transMsg));
        }
        return BankReceiptResponseEB.fail();
    }

    public String getDeveloper() {
        return null;
    }

    public String getBizCode() {
        return "getGeneralDownloadUrl";
    }

    public String getBizDesc() {
        return ResManager.loadKDString((String)"\u83b7\u53d6\u56de\u5355\u4e0b\u8f7d\u5730\u5740", (String)"GetReceiptDownloadUrlImpl_1", (String)"ebg-receipt-banks-nbb-opa", (Object[])new Object[0]);
    }
}

