/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.receipt.banks.cexim.dc.service.receipt.utils;

import java.time.LocalDate;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.resource.ResManager;
import kd.ebg.egf.common.context.EBContext;
import kd.ebg.egf.common.exception.EBExceiptionUtil;
import kd.ebg.egf.common.log.EBGLogger;
import kd.ebg.egf.common.utils.string.StringUtils;
import kd.ebg.egf.common.utils.xml.JDomUtils;
import kd.ebg.receipt.banks.cexim.dc.service.receipt.utils.CEXIMDCBankResponse;
import kd.ebg.receipt.banks.cexim.dc.service.receipt.utils.FileInfoNode;
import kd.ebg.receipt.banks.cexim.dc.service.receipt.utils.JDomExtUtils;
import kd.ebg.receipt.common.framework.receipt.exception.ReceiptException;
import org.apache.commons.codec.binary.Base64;
import org.jdom2.Element;

public class CommonParser {
    public static EBGLogger logger = EBGLogger.getInstance().getLogger(CommonParser.class);

    public static CEXIMDCBankResponse getFrontResponse(String rspStr, boolean isPrintLog) {
        CEXIMDCBankResponse response = new CEXIMDCBankResponse();
        Element root = JDomUtils.string2Root((String)rspStr, (String)EBContext.getContext().getCharsetName());
        Element header = JDomUtils.getChildElement((Element)root, (String)"header");
        String returnCode = JDomUtils.getChildText((Element)header, (String)"returnCode");
        String returnMsg = JDomUtils.getChildText((Element)header, (String)"returnMsg");
        response.setResponseCode(returnCode);
        response.setResponseMessage(returnMsg);
        if (!"0000".equalsIgnoreCase(returnCode)) {
            logger.info("\u91d1\u8776\u524d\u7f6e\u673a\u8fd4\u56de\u5931\u8d25\u3002");
            response.setSuccess(false);
        } else {
            response.setSuccess(true);
            Element body = JDomUtils.getChildElement((Element)root, (String)"body");
            String bankMsg = "";
            try {
                byte[] content = Base64.decodeBase64((String)JDomUtils.getChildText((Element)body, (String)"bankMsg"));
                bankMsg = new String(content, EBContext.getContext().getCharsetName());
            }
            catch (Exception e) {
                throw EBExceiptionUtil.serviceException((String)ResManager.loadKDString((String)"\u89e3\u6790\u94f6\u884c\u54cd\u5e94\u5185\u5bb9\u8282\u70b9bankMsg\u53d1\u751f\u5f02\u5e38\u3002", (String)"CommonParser_0", (String)"ebg-receipt-banks-cexim-dc", (Object[])new Object[0]), (Throwable)e);
            }
            response.setBankMsg(bankMsg);
            if (isPrintLog) {
                logger.infoFilerLog("\u91d1\u8776\u524d\u7f6e\u673a\u8fd4\u56de\u62a5\u6587\uff1a" + bankMsg);
            }
        }
        return response;
    }

    public static CEXIMDCBankResponse getBankPreResponse(String rspStr) {
        CEXIMDCBankResponse response = new CEXIMDCBankResponse();
        Element root = JDomExtUtils.string2Root((String)rspStr, (String)EBContext.getContext().getCharsetName());
        Element header = JDomExtUtils.getChildElement((Element)root, (String)"Transaction_Header");
        String statusCode = JDomExtUtils.getChildText((Element)header, (String)"SYS_TX_STATUS");
        String bankCode = JDomExtUtils.getChildText((Element)header, (String)"SYS_RESP_CODE");
        String bankMsg = JDomExtUtils.getChildText((Element)header, (String)"SYS_RESP_DESC");
        response.setResponseCode(bankCode);
        response.setResponseMessage(bankMsg);
        response.setBankMsg(bankMsg);
        if ("01".equalsIgnoreCase(statusCode)) {
            response.setSuccess(false);
        } else {
            response.setSuccess(true);
        }
        Element tranResponse = JDomExtUtils.getChildElement((Element)header, (String)"tran_response");
        if (null != tranResponse) {
            String status = JDomExtUtils.getChildText((Element)tranResponse, (String)"status");
            if ("COMPLETE".equalsIgnoreCase(status)) {
                response.setPaySuccess(true);
            } else {
                response.setUnkown(true);
            }
        } else {
            response.setUnkown(true);
        }
        String STS_TRACE_ID = JDomExtUtils.getChildText((Element)header, (String)"STS_TRACE_ID");
        String TOTAL_PAGE = JDomExtUtils.getChildText((Element)header, (String)"TOTAL_PAGE");
        if (StringUtils.isNotEmpty((String)STS_TRACE_ID)) {
            response.setStsTraceId(STS_TRACE_ID);
        }
        if (StringUtils.isNotEmpty((String)TOTAL_PAGE)) {
            response.setTotalPage(TOTAL_PAGE);
        }
        return response;
    }

    public static List<FileInfoNode> getRespFilesInfos(String responseStr) {
        Element root = JDomExtUtils.string2Root((String)responseStr, (String)EBContext.getContext().getCharsetName());
        ArrayList<FileInfoNode> result = new ArrayList<FileInfoNode>(16);
        Element body = JDomExtUtils.getChildElement((Element)root, (String)"Transaction_Body");
        Element response = JDomExtUtils.getChildElement((Element)body, (String)"response");
        Element fileListPack = JDomExtUtils.getChildElement((Element)response, (String)"FILE_LIST_PACK");
        String fileNumStr = JDomExtUtils.getChildText((Element)fileListPack, (String)"FILE_NUM");
        List fileInfo = fileListPack.getChildren("FILE_INFO");
        String acctulySize = Integer.toString(fileInfo.size());
        if (!acctulySize.equals(fileNumStr)) {
            throw new ReceiptException(String.format(ResManager.loadKDString((String)"\u8fd4\u56de\u7684\u6587\u4ef6\u4fe1\u606f\u8282\u70b9\u683c\u5f0f\u4e0d\u5339\u914d\uff0c\u63cf\u8ff0\u4e3a\uff1a%1$s\u4e2a\uff0c\u5b9e\u9645\u4e3a\uff1a%2$s\u4e2a\u3002", (String)"CommonParser_1", (String)"ebg-receipt-banks-cexim-dc", (Object[])new Object[0]), fileNumStr, acctulySize));
        }
        for (Element node : fileInfo) {
            FileInfoNode info = new FileInfoNode();
            String fileName = JDomExtUtils.getChildText((Element)node, (String)"FILE_NAME");
            String fileMD5 = JDomExtUtils.getChildText((Element)node, (String)"Msg_Smy");
            info.setFileName(fileName);
            info.setMd5(fileMD5);
            result.add(info);
        }
        return result;
    }

    public static String createFileNameByNewApi(String accNo, LocalDate transDate, String amount, String oppAccNo, String transNo, String dbtCrDrcCd, Map<String, Integer> tempMap) {
        StringBuilder sb = new StringBuilder();
        sb.append(accNo).append("_").append(transDate.format(DateTimeFormatter.BASIC_ISO_DATE)).append("_").append(amount).append("_").append(oppAccNo).append("_").append(transNo).append("_").append(dbtCrDrcCd);
        String orderNo = sb.toString();
        if (tempMap.containsKey(orderNo)) {
            int serial = tempMap.get(orderNo) + 1;
            tempMap.put(orderNo, serial);
            sb.append("_").append(String.format("%04d", serial));
        } else {
            tempMap.put(orderNo, 0);
        }
        sb.append(".pdf");
        return sb.toString();
    }

    public static byte[] hexStr2Byte(String hexStr) {
        String str = "0123456789ABCDEF";
        char[] hexs = hexStr.toCharArray();
        byte[] bytes = new byte[hexStr.length() / 2];
        for (int i = 0; i < bytes.length; ++i) {
            int n = str.indexOf(hexs[2 * i]) * 16;
            bytes[i] = (byte)((n += str.indexOf(hexs[2 * i + 1])) & 0xFF);
        }
        return bytes;
    }
}

