/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.receipt.banks.bcs.dc.service.receipt;

import java.time.LocalDate;
import java.util.ArrayList;
import java.util.List;
import kd.bos.dataentity.resource.ResManager;
import kd.ebg.egf.common.framework.bank.info.BankRequest;
import kd.ebg.egf.common.utils.LocalDateUtil;
import kd.ebg.receipt.banks.bcs.dc.service.detail.BcsDcDetailImpl;
import kd.ebg.receipt.banks.bcs.dc.service.receipt.api.BcsDcReceiptDownloadRequest;
import kd.ebg.receipt.banks.bcs.dc.service.util.FileInfo;
import kd.ebg.receipt.banks.bcs.dc.service.util.ResponseParser;
import kd.ebg.receipt.business.receipt.atom.AbstractBankReceiptHandleImpl;
import kd.ebg.receipt.business.receipt.atom.IBankReceiptHandle;
import kd.ebg.receipt.business.receipt.bank.frontProxy.BankReceiptRequest;
import kd.ebg.receipt.business.receipt.bank.frontProxy.BankReceiptResponseEB;
import kd.ebg.receipt.business.receipt.bank.task.BankReceiptHandleRequest;
import kd.ebg.receipt.business.receipt.bank.task.BankReceiptHandleResponseEB;
import kd.ebg.receipt.business.receipt.entity.TaskStatus;
import kd.ebg.receipt.common.framework.frame.EBGLogger;
import kd.ebg.receipt.common.framework.receipt.exception.ReceiptException;
import kd.ebg.receipt.common.framework.services.receipt.DownloadListDetailService;
import kd.ebg.receipt.common.framework.services.receipt.DownloadTaskService;
import kd.ebg.receipt.common.model.receipt.DownloadListDetail;
import kd.ebg.receipt.common.model.receipt.DownloadListTask;
import kd.ebg.receipt.common.utils.SpringContextUtil;

public class BankReceiptFetchListImpl
extends AbstractBankReceiptHandleImpl
implements IBankReceiptHandle {
    private static EBGLogger logger = EBGLogger.getInstance().getLogger(BankReceiptFetchListImpl.class);
    public DownloadListDetailService downloadListDetailService;
    public DownloadTaskService downloadTaskService;

    public void init(BankReceiptHandleRequest request) {
        this.downloadListDetailService = (DownloadListDetailService)SpringContextUtil.getBean(DownloadListDetailService.class);
        this.downloadTaskService = (DownloadTaskService)SpringContextUtil.getBean(DownloadTaskService.class);
    }

    public boolean match(BankReceiptHandleRequest request) {
        if (request == null) {
            return false;
        }
        Integer status = request.getTaskStatus();
        if (status == null) {
            return false;
        }
        return status.intValue() == TaskStatus.PROCESSING.getId();
    }

    public BankReceiptHandleResponseEB doBiz(BankReceiptHandleRequest bankReceiptHandleRequest) {
        this.init(bankReceiptHandleRequest);
        long taskId = bankReceiptHandleRequest.getTaskId();
        DownloadListTask task = this.downloadTaskService.findById(taskId);
        ArrayList<DownloadListDetail> result = new ArrayList<DownloadListDetail>(16);
        String accNo = task.getAccNo();
        String transDateStr = LocalDateUtil.formatDate((LocalDate)task.getTransDate());
        BankReceiptRequest bankDetailRequest = BankReceiptRequest.builder().accNo(accNo).transDate(task.getTransDate()).build();
        BcsDcDetailImpl detailReceipt = new BcsDcDetailImpl();
        BankReceiptResponseEB detailResponse = (BankReceiptResponseEB)detailReceipt.doBiz((BankRequest)bankDetailRequest);
        List<FileInfo> fileInfos = ResponseParser.detailResponseParser(task, (String)detailResponse.getData());
        BankReceiptRequest receiptRequest = BankReceiptRequest.builder().accNo(accNo).transDate(task.getTransDate()).build();
        for (FileInfo info : fileInfos) {
            String host_serial_no = info.getHOST_SERIAL_NO();
            String crdr_flag = info.getCRDR_FLAG();
            String amt = info.getAMT();
            receiptRequest.setRequestStr(host_serial_no);
            BcsDcReceiptDownloadRequest receiptDownloadRequest = new BcsDcReceiptDownloadRequest();
            BankReceiptResponseEB receiptResponseEB = (BankReceiptResponseEB)receiptDownloadRequest.doBiz((BankRequest)receiptRequest);
            String reportFileName = (String)receiptResponseEB.getData();
            StringBuilder newFileName = new StringBuilder();
            newFileName.append(accNo).append("_").append(transDateStr).append("_").append(host_serial_no).append("_").append(amt).append("_").append(crdr_flag).append(".pdf");
            DownloadListDetail detail = new DownloadListDetail();
            detail.setFileLink(reportFileName);
            detail.setFileName(newFileName.toString());
            result.add(detail);
        }
        if (result.size() == 0) {
            throw new ReceiptException(ResManager.loadKDString((String)"\u672c\u6b21\u4efb\u52a1\u83b7\u53d6\u7684\u56de\u5355\u6587\u4ef6\u5217\u8868\u4e3a\u7a7a", (String)"BankReceiptFetchListImpl_0", (String)"ebg-receipt-banks-bcs-dc", (Object[])new Object[0]));
        }
        return BankReceiptHandleResponseEB.success(result);
    }

    public String getDeveloper() {
        return null;
    }

    public String getBizCode() {
        return "BCS_DC_BankReceiptFetchList";
    }

    public String getBizDesc() {
        return ResManager.loadKDString((String)"\u83b7\u53d6\u957f\u6c99\u94f6\u884c\u56de\u5355\u6587\u4ef6\u5217\u8868", (String)"BankReceiptFetchListImpl_1", (String)"ebg-receipt-banks-bcs-dc", (Object[])new Object[0]);
    }
}

