/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.receipt.banks.gyb.dc.service.receipt.fetch;

import java.time.LocalDate;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.List;
import kd.bos.dataentity.resource.ResManager;
import kd.ebg.receipt.banks.gyb.dc.service.receipt.api.BankReceiptQueryImpl;
import kd.ebg.receipt.banks.gyb.dc.service.receipt.info.GybDcFileParser;
import kd.ebg.receipt.business.receipt.atom.AbstractBankReceiptHandleImpl;
import kd.ebg.receipt.business.receipt.atom.IBankReceiptHandle;
import kd.ebg.receipt.business.receipt.bank.task.BankReceiptHandleRequest;
import kd.ebg.receipt.business.receipt.bank.task.BankReceiptHandleResponseEB;
import kd.ebg.receipt.business.receipt.entity.TaskStatus;
import kd.ebg.receipt.common.framework.context.RequestContextUtils;
import kd.ebg.receipt.common.framework.frame.EBGLogger;
import kd.ebg.receipt.common.framework.receipt.exception.ReceiptException;
import kd.ebg.receipt.common.framework.services.receipt.DownloadListDetailService;
import kd.ebg.receipt.common.framework.services.receipt.DownloadTaskService;
import kd.ebg.receipt.common.model.DetailInfo;
import kd.ebg.receipt.common.model.receipt.DownloadListDetail;
import kd.ebg.receipt.common.model.receipt.DownloadListTask;
import kd.ebg.receipt.common.utils.FileCommonUtils;
import kd.ebg.receipt.common.utils.SpringContextUtil;

public class BankReceiptFetchListImpl
extends AbstractBankReceiptHandleImpl
implements IBankReceiptHandle {
    private static EBGLogger logger = EBGLogger.getInstance().getLogger(BankReceiptFetchListImpl.class);
    public DownloadListDetailService downloadListDetailService;
    public DownloadTaskService downloadTaskService;

    public void init(BankReceiptHandleRequest request) {
        this.downloadListDetailService = (DownloadListDetailService)SpringContextUtil.getBean(DownloadListDetailService.class);
        this.downloadTaskService = (DownloadTaskService)SpringContextUtil.getBean(DownloadTaskService.class);
    }

    public boolean match(BankReceiptHandleRequest request) {
        if (request == null) {
            return false;
        }
        Integer status = request.getTaskStatus();
        if (status == null) {
            return false;
        }
        if (status.intValue() != TaskStatus.PROCESSING.getId()) {
            return false;
        }
        return RequestContextUtils.receiptFormatIsFile() || FileCommonUtils.isTestEnv();
    }

    public BankReceiptHandleResponseEB doBiz(BankReceiptHandleRequest request) {
        this.init(request);
        long taskId = request.getTaskId();
        DownloadListTask downloadListTask = this.downloadTaskService.findById(taskId);
        List<DownloadListDetail> result = this.doJob_pushMode(downloadListTask);
        return BankReceiptHandleResponseEB.success(result);
    }

    public List<DownloadListDetail> doJob_pushMode(DownloadListTask task) {
        ArrayList<DownloadListDetail> result = new ArrayList<DownloadListDetail>(16);
        String accNo = task.getAccNo();
        String transDateStr = task.getTransDate().format(DateTimeFormatter.BASIC_ISO_DATE);
        LocalDate transDate = task.getTransDate();
        BankReceiptQueryImpl bankReceiptQuery = new BankReceiptQueryImpl();
        List<DetailInfo> detailInfoList = bankReceiptQuery.queryTransDetail(accNo, transDate, transDate);
        for (DetailInfo detail : detailInfoList) {
            DownloadListDetail downloadListDetail = new DownloadListDetail();
            String cdFlag = detail.getExplanation();
            String Amount = detail.getReversed1();
            String HostJournalNo = detail.getReversed2();
            String BEIZHU = detail.getReversed3();
            String receiptNo = detail.getReceiptNo();
            String oppAccNo = detail.getOppAccNo();
            String fileName = GybDcFileParser.packFileName(accNo, transDateStr, receiptNo, cdFlag, Amount, HostJournalNo, BEIZHU);
            String fileLink = GybDcFileParser.packJSON(accNo, transDateStr, receiptNo, cdFlag, oppAccNo, Amount, HostJournalNo, BEIZHU);
            downloadListDetail.setFileName(fileName);
            downloadListDetail.setFileLink(fileLink);
            result.add(downloadListDetail);
        }
        if (result.size() == 0) {
            throw new ReceiptException(ResManager.loadKDString((String)"\u672c\u6b21\u4efb\u52a1\u83b7\u53d6\u7684\u56de\u5355\u6587\u4ef6\u5217\u8868\u4e3a\u7a7a", (String)"BankReceiptFetchListImpl_0", (String)"ebg-receipt-banks-icbcsg-dc", (Object[])new Object[0]));
        }
        return result;
    }

    public String getDeveloper() {
        return "cw";
    }

    public String getBizCode() {
        return "";
    }

    public String getBizDesc() {
        return "";
    }
}

