/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.receipt.banks.bjb.dc.service.receipt.fetch;

import com.alibaba.fastjson.JSONObject;
import com.jcraft.jsch.ChannelSftp;
import java.io.File;
import java.time.LocalDate;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Vector;
import kd.bos.dataentity.resource.ResManager;
import kd.ebg.egf.common.utils.LocalDateUtil;
import kd.ebg.receipt.banks.bjb.dc.service.receipt.api.BankReceiptInfoRequestImpl;
import kd.ebg.receipt.banks.bjb.dc.service.receipt.info.ReceiptFileParser;
import kd.ebg.receipt.business.receipt.atom.AbstractBankReceiptHandleImpl;
import kd.ebg.receipt.business.receipt.atom.IBankReceiptHandle;
import kd.ebg.receipt.business.receipt.bank.task.BankReceiptHandleRequest;
import kd.ebg.receipt.business.receipt.bank.task.BankReceiptHandleResponseEB;
import kd.ebg.receipt.business.receipt.entity.TaskStatus;
import kd.ebg.receipt.business.receipt.utils.BankReceiptApiUtil;
import kd.ebg.receipt.common.core.utils.EBGStringUtils;
import kd.ebg.receipt.common.core.utils.GZFileUtils;
import kd.ebg.receipt.common.framework.frame.EBGLogger;
import kd.ebg.receipt.common.framework.receipt.bank.BankFtpProperties;
import kd.ebg.receipt.common.framework.receipt.exception.ReceiptException;
import kd.ebg.receipt.common.framework.receipt.util.EBConfigBuilder;
import kd.ebg.receipt.common.framework.receipt.util.FileStorageUtil;
import kd.ebg.receipt.common.framework.receipt.util.SFTPUtils;
import kd.ebg.receipt.common.framework.services.receipt.DownloadListDetailService;
import kd.ebg.receipt.common.framework.services.receipt.DownloadTaskService;
import kd.ebg.receipt.common.model.receipt.DownloadListDetail;
import kd.ebg.receipt.common.utils.FileCommonUtils;
import kd.ebg.receipt.common.utils.SpringContextUtil;

public class ReceiptFetchListImpl
extends AbstractBankReceiptHandleImpl
implements IBankReceiptHandle {
    private static EBGLogger logger = EBGLogger.getInstance().getLogger(ReceiptFetchListImpl.class);
    public DownloadListDetailService downloadListDetailService;
    public DownloadTaskService downloadTaskService;

    public void init(BankReceiptHandleRequest request) {
        this.downloadListDetailService = (DownloadListDetailService)SpringContextUtil.getBean(DownloadListDetailService.class);
        this.downloadTaskService = (DownloadTaskService)SpringContextUtil.getBean(DownloadTaskService.class);
    }

    public String getDeveloper() {
        return "";
    }

    public String getBizCode() {
        return "RECEIPT_FETCHLIST";
    }

    public String getBizDesc() {
        return "";
    }

    public boolean match(BankReceiptHandleRequest request) {
        if (request == null) {
            return false;
        }
        Integer status = request.getTaskStatus();
        if (status == null) {
            return false;
        }
        return status.intValue() == TaskStatus.PROCESSING.getId();
    }

    public BankReceiptHandleResponseEB doBiz(BankReceiptHandleRequest request) {
        this.init(request);
        ArrayList<DownloadListDetail> result = new ArrayList<DownloadListDetail>(16);
        String accNo = request.getAccNo();
        LocalDate transDate = request.getTransDate();
        String transDateStr = LocalDateUtil.formatDate((LocalDate)transDate);
        String bakFilePath = FileStorageUtil.getFileBakPathByAccNoAndDate((String)"BJB_DC", (String)accNo, (String)transDateStr);
        Map<String, JSONObject> queryReceiptList = BankReceiptInfoRequestImpl.queryReceiptList(accNo, transDate);
        if (queryReceiptList.isEmpty()) {
            throw new ReceiptException(ResManager.loadKDString((String)"\u6ca1\u6709\u56de\u5355\u8bb0\u5f55", (String)"ReceiptFetchListImpl_0", (String)"ebg-receipt-banks-bjb-dc", (Object[])new Object[0]));
        }
        long taskId = request.getTaskId();
        List downloadListDetails = this.downloadListDetailService.selectByRefId(Long.valueOf(taskId));
        for (DownloadListDetail downloadListDetail : downloadListDetails) {
            ReceiptFileParser receiptFileParser = new ReceiptFileParser();
            receiptFileParser.setFileName(downloadListDetail.getFileName());
            if (receiptFileParser.getFileSplitLength() != 3) continue;
            this.downloadListDetailService.deleteById(downloadListDetail.getId());
        }
        String matchStr = transDateStr;
        boolean isDownload = this.download(bakFilePath, matchStr, request);
        logger.info("\u662f\u5426\u4e0b\u8f7d\u6210\u529f\uff1a{}", (Object)isDownload);
        for (Map.Entry<String, JSONObject> entry : queryReceiptList.entrySet()) {
            String receiptNo = entry.getKey();
            JSONObject jsonObject = entry.getValue();
            String serialNo = jsonObject.getString("serialNo");
            DownloadListDetail downloadListDetail = new DownloadListDetail();
            StringBuilder receiptName = new StringBuilder();
            receiptName.append(accNo).append("_");
            receiptName.append(transDateStr).append("_");
            receiptName.append(serialNo).append("_");
            receiptName.append(receiptNo).append(".pdf");
            String oldReceiptName = receiptNo + ".pdf";
            File bakFile = FileCommonUtils.getFileByPath((String)bakFilePath);
            File[] receiptFileArray = bakFile.listFiles(file -> Objects.equals(file.getName(), oldReceiptName));
            if (receiptFileArray.length == 0) {
                throw new ReceiptException(String.format(ResManager.loadKDString((String)"\u627e\u4e0d\u5230\u6587\u4ef6\u540d\u4e3a\uff1a[%s]\u7684\u6587\u4ef6\uff0c\u8bf7\u68c0\u67e5\u524d\u7f6e\u673a\u76ee\u5f55\u4e0a\u7684\u538b\u7f29\u5305\u91cc\u9762\u662f\u5426\u5b58\u5728\u8be5\u6587\u4ef6\u3002", (String)"ReceiptFetchListImpl_1", (String)"ebg-receipt-banks-bjb-dc", (Object[])new Object[0]), oldReceiptName));
            }
            File oldReceipt = receiptFileArray[0];
            FileCommonUtils.moveFile((File)oldReceipt, (String)bakFilePath, (String)receiptName.toString());
            downloadListDetail.setFileLink(oldReceipt.getName());
            downloadListDetail.setFileName(receiptName.toString());
            result.add(downloadListDetail);
        }
        return BankReceiptHandleResponseEB.success(result);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean download(String bakFilePath, String matchStr, BankReceiptHandleRequest request) {
        String bankLoginId = request.getBankLoginId();
        String accNo = request.getAccNo();
        LocalDate transDate = request.getTransDate();
        ChannelSftp sftp = null;
        BankFtpProperties bankFtpProperties = (BankFtpProperties)EBConfigBuilder.getInstance().buildConfig(BankFtpProperties.class, bankLoginId);
        String suffix = ".zip";
        if (bankFtpProperties.getReceiptAchieveWay().equals("sftp")) {
            String sftp_path = bankFtpProperties.getFtpPath();
            sftp_path = EBGStringUtils.isNotEmpty((String)sftp_path) ? sftp_path : "/";
            try {
                sftp = SFTPUtils.getInstance().getSftp();
                if (sftp == null || !EBGStringUtils.isNotEmpty((String)sftp_path)) return false;
                List<String> zipFileNames = this.getFileByNameOfSFTP(sftp_path, matchStr, suffix, sftp);
                if (zipFileNames.isEmpty()) {
                    throw new ReceiptException(String.format(ResManager.loadKDString((String)"\u6587\u4ef6\u4e0b\u8f7d\u5931\u8d25\uff0c\u8bf7\u68c0\u67e5SFTP\u76ee\u5f55\u662f\u5426\u5b58\u5728\u65e5\u671f\u4e3a%s\u7684\u6587\u4ef6\u3002", (String)"ReceiptFetchListImpl_2", (String)"ebg-receipt-banks-bjb-dc", (Object[])new Object[0]), matchStr));
                }
                for (String zipFileName : zipFileNames) {
                    boolean flag = SFTPUtils.getInstance().downloadSingleFile(sftp_path, zipFileName, bakFilePath, sftp);
                    if (!flag) {
                        throw new ReceiptException(String.format(ResManager.loadKDString((String)"\u6587\u4ef6[%s]\u4e0b\u8f7d\u5931\u8d25\uff0c\u8bf7\u68c0\u67e5SFTP\u76ee\u5f55\u662f\u5426\u5b58\u5728\u8be5\u6587\u4ef6\u3002", (String)"ReceiptFetchListImpl_3", (String)"ebg-receipt-banks-bjb-dc", (Object[])new Object[0]), zipFileName));
                    }
                    this.listReceiptFile(bakFilePath, zipFileName);
                }
                return false;
            }
            catch (Exception e) {
                logger.error("sftp\u4e0b\u8f7d\u56de\u5355\u6587\u4ef6\u5931\u8d25\uff0c\u5931\u8d25\u539f\u56e0\uff1a", (Throwable)e);
                throw new ReceiptException(String.format(ResManager.loadKDString((String)"\u901a\u8fc7sftp\u904d\u5386\u6587\u4ef6\u5217\u8868\u5931\u8d25\uff1a%s\u3002", (String)"ReceiptFetchListImpl_8", (String)"ebg-receipt-banks-bjb-dc", (Object[])new Object[0]), e.getMessage()), (Throwable)e);
            }
            finally {
                SFTPUtils.getInstance().close(sftp);
            }
        } else {
            if (!bankFtpProperties.getReceiptAchieveWay().equals("bank_login")) return false;
            List<String> zipFileNames = this.getFileByNameOfBankProxy(matchStr, accNo, transDate, suffix);
            if (zipFileNames.isEmpty()) {
                throw new ReceiptException(String.format(ResManager.loadKDString((String)"\u6587\u4ef6\u4e0b\u8f7d\u5931\u8d25\uff0c\u8bf7\u68c0\u67e5\u524d\u7f6e\u673a\u56de\u5355\u76ee\u5f55\u4e0b\u662f\u5426\u5b58\u5728\u65e5\u671f\u4e3a%s\u7684\u6587\u4ef6\u3002", (String)"ReceiptFetchListImpl_4", (String)"ebg-receipt-banks-bjb-dc", (Object[])new Object[0]), matchStr));
            }
            Iterator<String> iterator = zipFileNames.iterator();
            while (iterator.hasNext()) {
                BankReceiptApiUtil bankReceiptApiUtil = new BankReceiptApiUtil(accNo, transDate);
                String zipFileName = iterator.next();
                boolean flag = bankReceiptApiUtil.downloadReceiptFile(zipFileName, bakFilePath);
                if (!flag) {
                    throw new ReceiptException(String.format(ResManager.loadKDString((String)"\u603b\u5305\u6587\u4ef6[%s]\u4e0b\u8f7d\u5931\u8d25\uff0c\u8bf7\u68c0\u67e5\u524d\u7f6e\u673a\u76ee\u5f55\u662f\u5426\u5b58\u5728\u8be5\u6587\u4ef6\u3002", (String)"ReceiptFetchListImpl_5", (String)"ebg-receipt-banks-bjb-dc", (Object[])new Object[0]), zipFileName));
                }
                this.listReceiptFile(bakFilePath, zipFileName);
            }
        }
        return false;
    }

    public void listReceiptFile(String bakFilePath, String zipFileName) {
        String batchUnZipPath = bakFilePath + File.separator + "temp";
        logger.info("\u89e3\u538b\u6587\u4ef6\uff1a{}", (Object)zipFileName);
        if (GZFileUtils.unZipFiles((String)(bakFilePath + File.separator + zipFileName), (String)batchUnZipPath)) {
            File[] files;
            File file = FileCommonUtils.getFileByPath((String)batchUnZipPath);
            for (File receiptFile : files = file.listFiles()) {
                String fileName = receiptFile.getName();
                if (!fileName.contains(".pdf")) continue;
                FileCommonUtils.moveFile((File)receiptFile, (String)bakFilePath, (String)fileName);
            }
            File zipFile = FileCommonUtils.getFileByPath((String)(bakFilePath + File.separator + zipFileName));
            if (zipFile.exists()) {
                boolean isDelete = zipFile.delete();
                logger.info("\u5220\u9664\u56de\u5355\u538b\u7f29\u5305:{} {}-\u89e3\u538b\u5230\u7684\u6587\u4ef6\u4e2a\u6570\uff1a{}", new Object[]{zipFileName, isDelete, files.length});
            }
        }
    }

    public List<String> getFileByNameOfBankProxy(String matchString, String accNo, LocalDate transDate, String suffix) {
        BankReceiptApiUtil bankReceiptApiUtil = new BankReceiptApiUtil(accNo, transDate);
        return bankReceiptApiUtil.getFileByName(matchString, suffix);
    }

    public List<String> getFileByNameOfSFTP(String ftpPath, String matchString, String suffix, ChannelSftp sftp) {
        ArrayList<String> fileList = new ArrayList<String>(16);
        try {
            Vector vector = sftp.ls(ftpPath);
            if (!vector.isEmpty()) {
                for (int i = 0; i < vector.size(); ++i) {
                    ChannelSftp.LsEntry file = (ChannelSftp.LsEntry)vector.get(i);
                    String fileName = file.getFilename();
                    logger.info("\u8fdc\u7a0bSFTP\u5b50\u76ee\u5f55\uff1a{}\u4e0a\u68c0\u7d22\u5230\u7684\u6587\u4ef6\u540d\uff1a{}", new Object[]{ftpPath, fileName});
                    if (!fileName.endsWith(suffix) || !fileName.contains(matchString)) continue;
                    fileList.add(fileName);
                }
            }
        }
        catch (Exception e) {
            throw new ReceiptException(String.format(ResManager.loadKDString((String)"\u901a\u8fc7sftp\u904d\u5386\u6587\u4ef6\u5217\u8868\u5931\u8d25\uff1a%s\u3002", (String)"ReceiptFetchListImpl_8", (String)"ebg-receipt-banks-bjb-dc", (Object[])new Object[0]), e.getMessage()), (Throwable)e);
        }
        return fileList;
    }
}

