/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.receipt.banks.cqb.dc.receipt.utils;

import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.Date;
import kd.ebg.egf.common.context.RequestContextUtils;
import kd.ebg.egf.common.utils.LocalDateUtil;
import kd.ebg.egf.common.utils.string.StringUtils;
import kd.ebg.egf.common.utils.xml.JDomUtils;
import kd.ebg.receipt.banks.cqb.dc.receipt.api.Signature;
import kd.ebg.receipt.business.detail.bank.BankDetailRequest;
import kd.ebg.receipt.business.receipt.bank.frontProxy.BankReceiptRequest;
import org.jdom2.Element;

public class CQB_DC_Packer {
    public static String createDetailMessage(BankDetailRequest bankDetailRequest) {
        LocalDate startDate = bankDetailRequest.getStartDate();
        LocalDate endDate = bankDetailRequest.getEndDate();
        Element in = new Element("in");
        Element head = CQB_DC_Packer.createCommonHead("4404");
        Element signBody = new Element("body");
        Element trans = new Element("trans");
        JDomUtils.addChild((Element)signBody, (Element)trans);
        JDomUtils.addChild((Element)trans, (String)"AccountNo", (String)bankDetailRequest.getAcnt().getAccNo());
        String testTime = RequestContextUtils.getBankParameterValue((String)"TEST_TIME");
        if (StringUtils.isNotEmpty((String)testTime)) {
            JDomUtils.addChild((Element)trans, (String)"BgnDate", (String)testTime);
            JDomUtils.addChild((Element)trans, (String)"EndDate", (String)testTime);
        } else {
            JDomUtils.addChild((Element)trans, (String)"BgnDate", (String)startDate.format(DateTimeFormatter.ofPattern("yyyyMMdd")));
            JDomUtils.addChild((Element)trans, (String)"EndDate", (String)endDate.format(DateTimeFormatter.ofPattern("yyyyMMdd")));
        }
        String bodyContent = JDomUtils.element2StringPlain((Element)signBody, (String)RequestContextUtils.getCharset());
        String signature = Signature.doSign(bodyContent);
        Element body = new Element("body");
        JDomUtils.addChild((Element)body, (String)"signature", (String)signature);
        JDomUtils.addChild((Element)in, (Element)head);
        JDomUtils.addChild((Element)in, (Element)body);
        return JDomUtils.root2String((Element)in, (String)RequestContextUtils.getCharset());
    }

    public static String createReceiptMessage(BankReceiptRequest request) {
        LocalDate transDate = request.getTransDate();
        String accNo = request.getAccNo();
        Element in = new Element("in");
        Element head = CQB_DC_Packer.createCommonHead("4450");
        Element signBody = new Element("body");
        Element trans = new Element("trans");
        JDomUtils.addChild((Element)signBody, (Element)trans);
        JDomUtils.addChild((Element)trans, (String)"AccountNo", (String)accNo);
        JDomUtils.addChild((Element)trans, (String)"TransDate", (String)LocalDateUtil.formatDate((LocalDate)transDate));
        JDomUtils.addChild((Element)trans, (String)"TransSeqNo", (String)request.getRequestStr());
        String bodyContent = JDomUtils.element2StringPlain((Element)signBody, (String)RequestContextUtils.getCharset());
        String signature = Signature.doSign(bodyContent);
        Element body = new Element("body");
        JDomUtils.addChild((Element)body, (String)"signature", (String)signature);
        JDomUtils.addChild((Element)in, (Element)head);
        JDomUtils.addChild((Element)in, (Element)body);
        return JDomUtils.root2String((Element)in, (String)RequestContextUtils.getCharset());
    }

    public static Element createCommonHead(String transCode) {
        Date date = new Date();
        long time = date.getTime();
        String dateline = Long.toString(time);
        String PacketId = dateline.substring(0, 10);
        Element element = new Element("head");
        JDomUtils.addChild((Element)element, (String)"TransCode", (String)transCode);
        JDomUtils.addChild((Element)element, (String)"TransDate", (String)LocalDate.now().format(DateTimeFormatter.ofPattern("yyyyMMdd")));
        JDomUtils.addChild((Element)element, (String)"TransTime", (String)LocalDateTime.now().format(DateTimeFormatter.ofPattern("HHmmss")));
        String CorpNo = RequestContextUtils.getBankParameterValue((String)"CUST_NO");
        JDomUtils.addChild((Element)element, (String)"MasterId", (String)CorpNo);
        JDomUtils.addChild((Element)element, (String)"PacketId", (String)PacketId);
        return element;
    }
}

