/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.receipt.banks.cabc.dc.service.receipt.utils;

import java.io.BufferedReader;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.net.Socket;
import kd.bos.dataentity.resource.ResManager;
import kd.ebg.egf.common.utils.string.StringUtils;
import kd.ebg.egf.common.utils.xml.JDomUtils;
import kd.ebg.receipt.common.framework.frame.EBGLogger;
import kd.ebg.receipt.common.framework.receipt.exception.ReceiptException;
import kd.ebg.receipt.common.framework.receipt.util.JDomExtUtils;
import org.jdom2.Document;
import org.jdom2.Element;

public class GetSign {
    private static EBGLogger log = EBGLogger.getInstance().getLogger(GetSign.class);

    public static String getSignData(String opReq, String host, int port) {
        try {
            String signRequest = GetSign.signRequest(opReq);
            log.info("\u957f\u5b89\u94f6\u884c\u7b7e\u540d\u8bf7\u6c42\uff1a" + signRequest);
            String signResponse = GetSign.doSign(signRequest, host, port);
            log.info("\u957f\u5b89\u94f6\u884c\u7b7e\u540d\u54cd\u5e94\uff1a" + signResponse);
            String signed_data = GetSign.signedData(signResponse);
            log.info("\u7b7e\u540d\u6210\u529f.");
            return signed_data;
        }
        catch (Exception e) {
            throw new ReceiptException((Throwable)e);
        }
    }

    public static String signRequest(String opReq) {
        Element msg = JDomExtUtils.createRoot((String)"msg");
        Element msg_head = JDomUtils.addChild((Element)msg, (String)"msg_head");
        JDomUtils.addChild((Element)msg_head, (String)"msg_type", (String)"0");
        JDomUtils.addChild((Element)msg_head, (String)"msg_id", (String)"1005");
        JDomUtils.addChild((Element)msg_head, (String)"msg_sn", (String)"0");
        JDomUtils.addChild((Element)msg_head, (String)"version", (String)"1");
        Element msg_body = JDomUtils.addChild((Element)msg, (String)"msg_body");
        JDomUtils.addChild((Element)msg_body, (String)"origin_data", (String)"replaceWith");
        String signRequest = JDomUtils.doc2StrGBK((Document)new Document(msg));
        signRequest = signRequest.replace("replaceWith", opReq);
        return signRequest;
    }

    public static String doSign(String signRequest, String host, int port) {
        String signResponse = "";
        try (Socket socket = new Socket(host, port);
             InputStream is = socket.getInputStream();
             InputStreamReader isr = new InputStreamReader(is, "GBK");){
            OutputStream dos = socket.getOutputStream();
            dos.write(signRequest.getBytes("GBK"));
            dos.flush();
            try (BufferedReader br = new BufferedReader(isr);){
                signResponse = br.readLine();
            }
            catch (Exception e) {
                throw new ReceiptException(String.format(ResManager.loadKDString((String)"\u957f\u5b89\u94f6\u884c\u8bfb\u53d6\u6570\u636e\u5f02\u5e38:%s\u3002", (String)"GetSign_5", (String)"ebg-receipt-banks-cabc-dc", (Object[])new Object[0]), e.getMessage()), (Throwable)e);
            }
        }
        catch (Exception e) {
            throw new ReceiptException(ResManager.loadKDString((String)"\u957f\u5b89\u94f6\u884c\u53d1\u9001\u8bf7\u6c42\u83b7\u53d6\u7b7e\u540d\u7ed3\u679c\u5f02\u5e38\u3002", (String)"GetSign_1", (String)"ebg-receipt-banks-cabc-dc", (Object[])new Object[0]), (Throwable)e);
        }
        return signResponse;
    }

    private static String signedData(String signResponse) {
        String signed_data = "";
        try {
            int start = signResponse.indexOf("<signed_data>");
            int end = signResponse.indexOf("</signed_data>");
            if (-1 == start || -1 == end) {
                throw new ReceiptException(ResManager.loadKDString((String)"\u7b7e\u540d\u5931\u8d25, \u7b7e\u540d\u53cd\u56de\u62a5\u6587\u4e2d\u4e0d\u5305\u542b<signed_data></signed_data>\u8282\u70b9", (String)"GetSign_2", (String)"ebg-receipt-banks-cabc-dc", (Object[])new Object[0]));
            }
            signed_data = signResponse.substring(start + "signed_data".length() + 2, end);
        }
        catch (Exception e) {
            throw new ReceiptException(String.format(ResManager.loadKDString((String)"\u7b7e\u540d\u5931\u8d25\uff0c\u89e3\u6790\u7b7e\u540d\u62a5\u6587\u5f02\u5e38:%s\u3002", (String)"GetSign_6", (String)"ebg-receipt-banks-cabc-dc", (Object[])new Object[0]), e.getMessage()), (Throwable)e);
        }
        if (StringUtils.isEmpty((String)signed_data)) {
            throw new ReceiptException(ResManager.loadKDString((String)"\u7b7e\u540d\u5931\u8d25, \u7b7e\u540d\u65f6\u94f6\u884c\u8fd4\u56de \u7b7e\u540d\u6570\u636e<signed_data>\u4e3a\u7a7a.", (String)"GetSign_4", (String)"ebg-receipt-banks-cabc-dc", (Object[])new Object[0]));
        }
        return signed_data;
    }
}

