/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.receipt.servicehelper;

import com.google.common.collect.Maps;
import java.util.Map;
import kd.bos.dataentity.TypesContainer;
import kd.bos.dataentity.resource.ResManager;

public class ServiceFactory {
    private static Map<String, String> serviceMap = Maps.newHashMapWithExpectedSize((int)8);
    private static final String EB_SYNC_SERVICE_IMPL = "kd.ebg.receipt.mservice.EBSyncServiceImpl";
    private static final String EB_ASYNC_SERVICE_IMPL = "kd.ebg.receipt.mservice.EBAsyncServiceImpl";

    public static <T> T getService(Class<T> clazz) {
        return (T)ServiceFactory.getService(clazz.getSimpleName());
    }

    public static Object getService(String serviceName) {
        String className = serviceMap.get(serviceName);
        if (className == null) {
            throw new RuntimeException(String.format(ResManager.loadKDString((String)"\u94f6\u4f01\u4e91%s\u63a5\u53e3\u5bf9\u5e94\u7684\u5fae\u670d\u52a1\u5b9e\u73b0\u7c7b\u672a\u627e\u5230\u3002", (String)"ServiceFactory_0", (String)"ebg-receipt-servicehelper", (Object[])new Object[0]), serviceName));
        }
        return TypesContainer.getOrRegisterSingletonInstance((String)className);
    }

    static {
        serviceMap.put("receiptService", EB_SYNC_SERVICE_IMPL);
        serviceMap.put("receipt", EB_SYNC_SERVICE_IMPL);
        serviceMap.put("reconciliation", EB_SYNC_SERVICE_IMPL);
        serviceMap.put("balanceReconciliationQuery", EB_SYNC_SERVICE_IMPL);
        serviceMap.put("balanceReconciliationQueryPage", EB_SYNC_SERVICE_IMPL);
        serviceMap.put("balanceReconciliate", EB_SYNC_SERVICE_IMPL);
        serviceMap.put("receiptDownload", EB_SYNC_SERVICE_IMPL);
        serviceMap.put("syncAccount", EB_SYNC_SERVICE_IMPL);
        serviceMap.put("listBankLogin", EB_SYNC_SERVICE_IMPL);
        serviceMap.put("queryApply", EB_SYNC_SERVICE_IMPL);
        serviceMap.put("apply", EB_SYNC_SERVICE_IMPL);
        serviceMap.put("register", EB_SYNC_SERVICE_IMPL);
        serviceMap.put("listBank", EB_SYNC_SERVICE_IMPL);
        serviceMap.put("bankLoginConfig", EB_SYNC_SERVICE_IMPL);
        serviceMap.put("bankLoginDetail", EB_SYNC_SERVICE_IMPL);
        serviceMap.put("syncBankLogin", EB_SYNC_SERVICE_IMPL);
        serviceMap.put("pay", EB_ASYNC_SERVICE_IMPL);
        serviceMap.put("queryPay", EB_ASYNC_SERVICE_IMPL);
        serviceMap.put("linkpay", EB_ASYNC_SERVICE_IMPL);
        serviceMap.put("queryLinkpay", EB_ASYNC_SERVICE_IMPL);
        serviceMap.put("updatePayStatus", EB_SYNC_SERVICE_IMPL);
        serviceMap.put("ping", EB_SYNC_SERVICE_IMPL);
        serviceMap.put("customize", EB_SYNC_SERVICE_IMPL);
    }
}

