/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.receipt.banks.cib.dc.services.receipt;

import com.alibaba.fastjson.JSONObject;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import kd.bos.dataentity.resource.ResManager;
import kd.ebg.egf.common.exception.EBExceiptionUtil;
import kd.ebg.receipt.banks.cib.dc.services.CIB_DC_Parser;
import kd.ebg.receipt.business.receipt.bank.ReceiptInfo;
import kd.ebg.receipt.business.receipt.bank.ReceiptRequest;
import kd.ebg.receipt.business.receipt.bank.ReceiptResponseEB;
import kd.ebg.receipt.common.core.utils.EBGStringUtils;
import kd.ebg.receipt.common.framework.frame.EBGLogger;
import kd.ebg.receipt.common.framework.match.MatchRule;
import org.jdom2.Element;

public class ReceiptParser {
    EBGLogger logger = EBGLogger.getInstance().getLogger(ReceiptParser.class);

    public static ReceiptResponseEB parse(ReceiptRequest request, String responseStr) {
        ReceiptResponseEB response = new ReceiptResponseEB();
        response.setCompleteFlag(0);
        Element root = CIB_DC_Parser.parseString2Root(responseStr);
        Element eb1 = root.getChild("SECURITIES_MSGSRSV1");
        if (eb1 == null) {
            throw EBExceiptionUtil.serviceException((String)ResManager.loadKDString((String)"\u94f6\u884c\u672a\u8fd4\u56deSECURITIES_MSGSRSV1\u8282\u70b9\u94f6\u4f01\u5e73\u53f0\u65e0\u6cd5\u89e3\u6790\uff0c\u67e5\u8be2\u56de\u5355\u5931\u8d25\u3002\u5982\u9700\u4e86\u89e3\u8be6\u60c5\u8bf7\u8054\u7cfb\u94f6\u884c\u5ba2\u6237\u7ecf\u7406\u3002", (String)"ReceiptParser_0", (String)"ebg-receipt-banks-cib-dc", (Object[])new Object[0]));
        }
        Element eb = eb1.getChild("SCUSTSTMTTRNRS");
        Element status = eb.getChild("STATUS");
        String iRetCode = status.getChildTextTrim("CODE");
        String msg = status.getChildTextTrim("MESSAGE");
        if ("6421".equals(iRetCode)) {
            response.setCompleteFlag(1);
            ArrayList infosList = new ArrayList(16);
            response.setReceiptInfos(infosList);
            return response;
        }
        if (!"0".equals(iRetCode)) {
            throw EBExceiptionUtil.serviceException((String)String.format(ResManager.loadKDString((String)"\u94f6\u884c\u8fd4\u56de\u7684\u72b6\u6001\u7801\uff1a%1$s\u72b6\u6001\u63cf\u8ff0\uff1a%2$s\u8868\u793a\u67e5\u8be2\u5931\u8d25\u3002\u5982\u9700\u4e86\u89e3\u8be6\u60c5\u8bf7\u8054\u7cfb\u94f6\u884c\u5ba2\u6237\u7ecf\u7406\u3002", (String)"ReceiptParser_4", (String)"ebg-receipt-banks-cib-dc", (Object[])new Object[0]), iRetCode, msg));
        }
        Element stmtrs = eb.getChild("SCUSTSTMTRS");
        String CurrType = stmtrs.getChildText("CURDEF");
        Element tranList = stmtrs.getChild("TRANLIST");
        List localList = tranList.getChildren("STMTTRN");
        ArrayList<ReceiptInfo> receiptInfoList = new ArrayList<ReceiptInfo>(16);
        HashMap<String, Integer> countMap = new HashMap<String, Integer>(16);
        Iterator iterator = localList.iterator();
        while (iterator.hasNext()) {
            ReceiptInfo rInfo = new ReceiptInfo();
            Element e = (Element)iterator.next();
            String Balance = e.getChildTextTrim("BALAMT");
            String RecipAccNo = e.getChildText("CORRELATE_ACCTID");
            String RecipName = e.getChildText("CORRELATE_NAME");
            String RecipBankName = e.getChildText("CORRELATE_BANKNAME");
            String Summary = e.getChildText("MEMO");
            if (!EBGStringUtils.isEmpty((String)Summary)) {
                int index = Summary.indexOf("@KD");
                String first = null;
                String last = null;
                if (index != -1) {
                    first = Summary.substring(0, index - 8);
                    last = Summary.substring(index + 3);
                    rInfo.setUseCn(first + "" + last);
                } else {
                    rInfo.setUseCn(Summary);
                }
            }
            String Time = e.getChildText("DTACCT");
            Time = Time.substring(0, Time.indexOf("T"));
            Time = Time.replace("-", "");
            String ATTACHINFO = e.getChildText("ATTACHINFO");
            String CreditAmount = e.getChildText("TRNAMT");
            rInfo.setAccNo(request.getAccNo());
            rInfo.setOppAccNo(RecipAccNo);
            rInfo.setOppAccName(RecipName);
            rInfo.setOppBankName(RecipBankName);
            if ("DEBIT".equals(e.getChildText("TRNTYPE"))) {
                rInfo.setDebitAmount(CreditAmount);
                rInfo.setCreditAmount("0");
            }
            if ("CREDIT".equals(e.getChildText("TRNTYPE"))) {
                rInfo.setCreditAmount(CreditAmount);
                rInfo.setOppAccNo(request.getAccNo());
                rInfo.setAccNo(RecipAccNo);
            }
            rInfo.setCurrency(CurrType);
            String accNo = request.getAccNo();
            String transDate = Time;
            rInfo.setFileFlag("0");
            rInfo.setTranSerialNo(ATTACHINFO);
            String jsonStr = MatchRule.getInstance().getDetailJsonWithStructuredData(e);
            JSONObject jsonObject = JSONObject.parseObject((String)jsonStr);
            jsonObject.put("serialNo", (Object)ATTACHINFO);
            rInfo.setJson(jsonObject.toJSONString());
            String receiptNo = MatchRule.getInstance().getReceiptMatchNo(accNo, transDate, jsonObject.toJSONString());
            if (countMap.containsKey(receiptNo)) {
                int count = (Integer)countMap.get(receiptNo) + 1;
                countMap.put(receiptNo, count);
                receiptNo = receiptNo + "-" + String.format("%04d", count);
            } else {
                countMap.put(receiptNo, 0);
            }
            rInfo.setReceiptNo(receiptNo);
            rInfo.setAmount(CreditAmount);
            rInfo.setTransDate(Time);
            rInfo.setTranSerialNo(ATTACHINFO);
            receiptInfoList.add(rInfo);
        }
        response.setReceiptInfos(receiptInfoList);
        response.setCompleteFlag(1);
        return response;
    }
}

