/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.receipt.banks.nmgbc.dc.service.receipt;

import java.time.LocalDate;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.ebg.egf.common.framework.communication.ConnectionFactory;
import kd.ebg.egf.common.utils.xml.JDomUtils;
import kd.ebg.receipt.banks.nmgbc.dc.service.utils.PackerHelper;
import kd.ebg.receipt.banks.nmgbc.dc.service.utils.ParserHelper;
import kd.ebg.receipt.business.receipt.atom.AbstractBankReceiptImpl;
import kd.ebg.receipt.business.receipt.atom.IBankReceipt;
import kd.ebg.receipt.business.receipt.bank.frontProxy.BankReceiptRequest;
import kd.ebg.receipt.business.receipt.bank.frontProxy.BankReceiptResponseEB;
import org.jdom2.Element;

public class HisReceiptListQryImpl
extends AbstractBankReceiptImpl
implements IBankReceipt {
    private boolean lastPage = false;

    public String getDeveloper() {
        return "";
    }

    public String getBizCode() {
        return "HisReceiptListQry";
    }

    public String getBizDesc() {
        return "";
    }

    public synchronized List<Map<String, Object>> process(BankReceiptRequest bankReceiptRequest) {
        ArrayList<Map<String, Object>> res = new ArrayList<Map<String, Object>>(8);
        this.lastPage = false;
        while (!this.lastPage) {
            BankReceiptResponseEB bankReceiptResponseEB = this.doBiz(bankReceiptRequest);
            List data = (List)bankReceiptResponseEB.getData();
            res.addAll(data);
        }
        return res;
    }

    public String pack(BankReceiptRequest bankReceiptRequest) {
        LocalDate transDate = bankReceiptRequest.getTransDate();
        String transDateStr = transDate.format(DateTimeFormatter.BASIC_ISO_DATE);
        HashMap<String, String> map = new HashMap<String, String>(4);
        map.put("accountNo", bankReceiptRequest.getAccNo());
        map.put("startIntcDate", transDateStr);
        map.put("endIntcDate", transDateStr);
        map.put("StartSeq", bankReceiptRequest.getRequestStr());
        return PackerHelper.packXML(map, this.getBizCode());
    }

    public BankReceiptResponseEB parse(BankReceiptRequest bankReceiptRequest, String s) {
        this.lastPage = true;
        Element root = JDomUtils.string2Root((String)s.substring(56), (String)"GBK");
        Element opRep = JDomUtils.getChildElement((Element)root, (String)"opRep");
        ParserHelper.parserRep(opRep);
        Element RepParam = JDomUtils.getChildElement((Element)opRep, (String)"RepParam");
        String moreResult = JDomUtils.getUnNullChildElement((Element)RepParam, (String)"moreResult").getTextTrim();
        String lastSeq = JDomUtils.getUnNullChildElement((Element)RepParam, (String)"lastSeq").getTextTrim();
        Element list = JDomUtils.getChildElement((Element)RepParam, (String)"list");
        List rows = list.getChildren("row");
        ArrayList ret = new ArrayList(8);
        for (Element row : rows) {
            String tranDate = JDomUtils.getUnNullChildElement((Element)row, (String)"tranDate").getTextTrim();
            String transferFlowNo = JDomUtils.getUnNullChildElement((Element)row, (String)"transferFlowNo").getTextTrim();
            String amount = JDomUtils.getUnNullChildElement((Element)row, (String)"amount").getTextTrim();
            String PrintNum = JDomUtils.getUnNullChildElement((Element)row, (String)"PrintNum").getTextTrim();
            String dbusLogNum = JDomUtils.getUnNullChildElement((Element)row, (String)"dbusLogNum").getTextTrim();
            String receiptType = JDomUtils.getUnNullChildElement((Element)row, (String)"receiptType").getTextTrim();
            String templetNo = JDomUtils.getUnNullChildElement((Element)row, (String)"templetNo").getTextTrim();
            String diskPartition = JDomUtils.getUnNullChildElement((Element)row, (String)"diskPartition").getTextTrim();
            String cmchannelType = JDomUtils.getUnNullChildElement((Element)row, (String)"cmchannelType").getTextTrim();
            HashMap<String, String> re = new HashMap<String, String>(12);
            re.put("amount", amount);
            re.put("tranDate", tranDate);
            re.put("transferFlowNo", transferFlowNo);
            re.put("PrintNum", PrintNum);
            re.put("dbusLogNum", dbusLogNum);
            re.put("receiptType", receiptType);
            re.put("templetNo", templetNo);
            re.put("diskPartition", diskPartition);
            re.put("cmchannelType", cmchannelType);
            ret.add(re);
        }
        if (moreResult.equalsIgnoreCase("Y")) {
            this.lastPage = false;
            bankReceiptRequest.setRequestStr(lastSeq);
        }
        return BankReceiptResponseEB.success(ret);
    }

    public void configFactory(ConnectionFactory factory) {
        factory.setUri("/yqbank/APIReqServlet");
    }
}

