/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.receipt.formplugin.plugin.match;

import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.EventObject;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.control.events.RowClickEvent;
import kd.bos.form.control.events.RowClickEventListener;
import kd.bos.form.events.BeforeClosedEvent;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.ComboEdit;
import kd.bos.form.field.ComboItem;
import kd.bos.form.field.TextEdit;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.form.operate.FormOperate;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.list.ListShowParameter;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.operation.DeleteServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.bos.url.UrlService;
import kd.ebg.egf.common.context.EBContext;
import kd.ebg.receipt.common.core.utils.EBGStringUtils;
import kd.ebg.receipt.common.framework.utils.ReceiptCommonAipUtil;
import kd.ebg.receipt.common.utils.SpringContextUtil;
import kd.ebg.receipt.formplugin.constant.MatchRuleTransTypeEnum;
import kd.ebg.receipt.formplugin.plugin.common.CommonFieldIndexEnum;
import kd.ebg.receipt.formplugin.plugin.match.MatchRule;
import kd.ebg.receipt.formplugin.service.CommonService;
import kd.ebg.receipt.formplugin.util.JsonUtil;
import kd.ebg.receipt.formplugin.util.StringUtil;
import kd.ebg.receipt.formplugin.util.StringUtils;

public class MatchRuleBillPlugin
extends AbstractFormPlugin
implements RowClickEventListener,
BeforeF7SelectListener {
    private static final String EB = "eb_matchRulePlugin_";
    private static final String entity = "receipt_bd_match_rule";
    private static final String properties = "id,number,name,match_rule,bank_version,modifytime,trans_type";
    private static final String match_param_entity = "receipt_bd_match_param";
    private static final String match_param_properties = "number,name,detail_param,receipt_param,ref_id";
    private CommonService commonService = (CommonService)SpringContextUtil.getBean(CommonService.class);
    private static final boolean isLock = true;
    private static final boolean isOnlyDefine = true;

    public void registerListener(EventObject e) {
        super.registerListener(e);
        EntryGrid treeEntryGrid = (EntryGrid)this.getControl("match_tree_entity");
        treeEntryGrid.addRowClickListener((RowClickEventListener)this);
        BasedataEdit bankVersionFieldEdit = (BasedataEdit)this.getView().getControl("bank_list");
        if (bankVersionFieldEdit != null) {
            bankVersionFieldEdit.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        }
    }

    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
    }

    public void entryRowClick(RowClickEvent evt) {
        int row = evt.getRow();
        DynamicObject dynamicObject = this.getModel().getEntryRowEntity("match_tree_entity", row);
        boolean flag = MatchRule.commonParams.contains(dynamicObject.getString("define_param"));
        this.getModel();
        if (flag && row > 6 && this.isNeedLock()) {
            EntryGrid treeEntryGrid = (EntryGrid)this.getControl("match_tree_entity");
            treeEntryGrid.entryRowClick(Integer.valueOf(row));
        }
    }

    public void beforeClosed(BeforeClosedEvent e) {
        e.setCheckDataChange(false);
        this.getModel().setDataChanged(false);
    }

    public void beforeBindData(EventObject e) {
        this.getView().setVisible(Boolean.valueOf(false), new String[]{"bar_save", "update", "tb_new", "tb_del", "trans_type"});
    }

    public void propertyChanged(PropertyChangedArgs e) {
        super.propertyChanged(e);
        String fieldKey = e.getProperty().getName();
        String type = "define";
        if (StringUtil.equals(fieldKey, "template_combo")) {
            DynamicObject dynamicObject = (DynamicObject)this.getView().getModel().getValue("bank_list");
            if (dynamicObject == null) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u94f6\u884c\u7248\u672c\u3002", (String)"MatchRuleBillPlugin_0", (String)"ebg-receipt-formplugin", (Object[])new Object[0]));
            } else {
                this.getView().setVisible(Boolean.valueOf(true), new String[]{"bar_save", "update"});
            }
        } else if (StringUtil.equals(fieldKey, "bank_list")) {
            DynamicObject dynamicObject = (DynamicObject)this.getView().getModel().getValue("bank_list");
            if (dynamicObject == null) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u94f6\u884c\u7248\u672c\u3002", (String)"MatchRuleBillPlugin_0", (String)"ebg-receipt-formplugin", (Object[])new Object[0]));
            } else {
                this.getView().setVisible(Boolean.valueOf(true), new String[]{"bar_save", "update", "tb_new", "tb_del"});
                String bankVersion = dynamicObject.getString("number");
                String transType = (String)this.getView().getModel().getValue("trans_type");
                this.loadMatchRule(bankVersion, type, transType);
                this.loadMatchParams();
                this.lockGridData();
                this.loadTransType(bankVersion);
            }
        } else if (StringUtil.equals(fieldKey, "trans_type")) {
            String transType = (String)this.getView().getModel().getValue("trans_type");
            DynamicObject dynamicObject = (DynamicObject)this.getView().getModel().getValue("bank_list");
            if (dynamicObject == null) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u94f6\u884c\u7248\u672c\u3002", (String)"MatchRuleBillPlugin_0", (String)"ebg-receipt-formplugin", (Object[])new Object[0]));
            } else {
                this.getView().setVisible(Boolean.valueOf(true), new String[]{"bar_save", "update", "tb_new", "tb_del"});
                String bankVersion = dynamicObject.getString("number");
                this.loadMatchRule(bankVersion, type, transType);
                this.loadMatchParams();
                this.lockGridData();
                if (!Objects.equals(transType, MatchRuleTransTypeEnum.COMMON.getId())) {
                    this.getView().setVisible(Boolean.valueOf(false), new String[]{"bar_save", "update", "tb_new", "tb_del"});
                    EntryGrid treeEntryGrid = (EntryGrid)this.getControl("match_tree_entity");
                    int rowCount = treeEntryGrid.getModel().getEntryRowCount(treeEntryGrid.getEntryKey());
                    if (rowCount > 0) {
                        int[] rows = new int[rowCount];
                        for (int i = 0; i < rowCount; ++i) {
                            rows[i] = i;
                        }
                        treeEntryGrid.setRowLock(true, rows);
                    }
                } else {
                    this.getView().setVisible(Boolean.valueOf(true), new String[]{"bar_save", "update", "tb_new", "tb_del"});
                }
            }
        }
    }

    public void beforeF7Select(BeforeF7SelectEvent e) {
        String fieldKey = e.getProperty().getName();
        if ("bank_list".equals(fieldKey)) {
            List<String> bankVersionIDList = this.commonService.getImplBankVersionIdList();
            ArrayList<QFilter> qFilters = new ArrayList<QFilter>();
            qFilters.add(new QFilter("number", "in", bankVersionIDList));
            qFilters.add(QFilter.of((String)"enable=? and status=?", (Object[])new Object[]{"1", "C"}));
            ListShowParameter showParameter = (ListShowParameter)e.getFormShowParameter();
            showParameter.setShowApproved(false);
            showParameter.getListFilterParameter().setQFilters(qFilters);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        super.beforeDoOperation(args);
        FormOperate formOperate = (FormOperate)args.getSource();
        if (StringUtil.equals(formOperate.getOperateKey(), "savematchrule")) {
            DynamicObject dynamicObject = (DynamicObject)this.getView().getModel().getValue("bank_list");
            if (dynamicObject == null) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u94f6\u884c\u7248\u672c\u3002", (String)"MatchRuleBillPlugin_0", (String)"ebg-receipt-formplugin", (Object[])new Object[0]));
                args.setCancel(true);
                return;
            }
            String alertMsg = this.checkTreeGrid(args);
            if (!StringUtils.isEmpty(alertMsg)) {
                this.getView().showErrorNotification(String.format(ResManager.loadKDString((String)"\u4fdd\u5b58\u5931\u8d25\uff0c%s\u3002", (String)"MatchRuleBillPlugin_22", (String)"ebg-receipt-formplugin", (Object[])new Object[0]), alertMsg));
                args.setCancel(true);
                return;
            }
            if (this.isConstainCommonFiled()) {
                args.setCancel(true);
                return;
            }
            this.updateMatchRule();
            String jsonStr = this.getPageCache().get("eb_matchRulePlugin_instance");
            if (StringUtil.isNotNil(jsonStr)) {
                MatchRule matchRule = JsonUtil.fromJson(jsonStr, MatchRule.class);
                this.saveMatchRule(matchRule, args);
                this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u4fdd\u5b58\u6210\u529f\u3002", (String)"MatchRuleBillPlugin_2", (String)"ebg-receipt-formplugin", (Object[])new Object[0]));
            }
        } else if (StringUtil.equals(formOperate.getOperateKey(), "remove")) {
            DynamicObject dynamicObject = (DynamicObject)this.getView().getModel().getValue("bank_list");
            if (dynamicObject != null) {
                String bankVersion = dynamicObject.getString("number");
                if (this.isDefinedMatchRule(bankVersion)) {
                    this.removeMatchRule(bankVersion);
                    this.loadMatchRule(bankVersion, "common", MatchRuleTransTypeEnum.COMMON.getId());
                    this.loadMatchParams();
                    this.lockGridData();
                    this.loadTransType(bankVersion);
                    this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u91cd\u7f6e\u6210\u529f\u3002", (String)"MatchRuleBillPlugin_3", (String)"ebg-receipt-formplugin", (Object[])new Object[0]));
                }
            } else {
                this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u91cd\u7f6e\u5df2\u5b8c\u6210\u3002", (String)"MatchRuleBillPlugin_4", (String)"ebg-receipt-formplugin", (Object[])new Object[0]));
            }
        } else if (StringUtil.equals(formOperate.getOperateKey(), "deleteentry")) {
            int row;
            IDataModel entryOperate = this.getModel();
            DynamicObject dynamicObject = entryOperate.getEntryRowEntity("match_tree_entity", row = entryOperate.getEntryCurrentRowIndex("match_tree_entity"));
            String name = dynamicObject.getString("define_param");
            if (MatchRule.commonParams.contains(name)) {
                this.getView().showErrorNotification(String.format(ResManager.loadKDString((String)"\u5220\u9664\u5931\u8d25\uff0c\u5339\u914d\u5b57\u6bb5%s\u4e3a\u901a\u7528\u6a21\u677f\u5b57\u6bb5\uff0c\u4e0d\u5141\u8bb8\u5220\u9664\u3002", (String)"MatchRuleBillPlugin_5", (String)"ebg-receipt-formplugin", (Object[])new Object[0]), name));
                args.setCancel(true);
            }
            this.updateMatchRule();
        } else if (StringUtil.equals(formOperate.getOperateKey(), "updatereceiptno")) {
            DynamicObject dynamicObject = (DynamicObject)this.getView().getModel().getValue("bank_list");
            if (dynamicObject != null) {
                try {
                    String bankVersion = dynamicObject.getString("number");
                    EBContext ebContext = EBContext.builder().bankVersionID(bankVersion).customID(RequestContext.get().getTenantId()).build();
                    EBContext.setContext((EBContext)ebContext);
                    ReceiptCommonAipUtil receiptCommonAipUtil = new ReceiptCommonAipUtil();
                    receiptCommonAipUtil.againInstallReceiptNo(bankVersion);
                    this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u66f4\u65b0\u6210\u529f\u3002", (String)"MatchRuleBillPlugin_6", (String)"ebg-receipt-formplugin", (Object[])new Object[0]));
                }
                catch (Exception e) {
                    this.getView().showErrorNotification(String.format(ResManager.loadKDString((String)"\u66f4\u65b0\u5931\u8d25\uff0c\u66f4\u65b0\u5931\u8d25\u539f\u56e0\uff1a%s\u3002", (String)"MatchRuleBillPlugin_23", (String)"ebg-receipt-formplugin", (Object[])new Object[0]), e.getMessage()));
                    args.setCancel(true);
                }
                finally {
                    EBContext.destroy();
                }
            } else {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u94f6\u884c\u7248\u672c\u3002", (String)"MatchRuleBillPlugin_0", (String)"ebg-receipt-formplugin", (Object[])new Object[0]));
                args.setCancel(true);
            }
        }
    }

    private void saveMatchRule(MatchRule rule, BeforeDoOperationEventArgs args) {
        if (StringUtils.isEmpty(rule.getId())) {
            DynamicObject dynamicObject = BusinessDataServiceHelper.newDynamicObject((String)entity);
            dynamicObject.set("number", (Object)"define");
            dynamicObject.set("name", (Object)rule.getName());
            dynamicObject.set("bank_version", (Object)rule.getBankVersion());
            dynamicObject.set("match_rule", (Object)rule.getRule());
            dynamicObject.set("trans_type", (Object)MatchRuleTransTypeEnum.COMMON.getId());
            dynamicObject.set("status", (Object)"A");
            Object[] objs = SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{dynamicObject});
            DynamicObject dObj = (DynamicObject)objs[0];
            rule.setId(dObj.getString("id"));
        } else {
            DynamicObject dynamicObject = BusinessDataServiceHelper.loadSingle((Object)rule.getId(), (String)entity);
            String type = "define";
            if (StringUtils.equals(dynamicObject.getString("number"), "define") && type.equals("common")) {
                DynamicObject bankDynamicObject = (DynamicObject)this.getView().getModel().getValue("bank_list");
                if (bankDynamicObject != null) {
                    String bankVersion = bankDynamicObject.getString("number");
                    this.removeMatchRule(bankVersion);
                }
                dynamicObject.set("number", (Object)type);
            }
            dynamicObject.set("name", (Object)rule.getName());
            dynamicObject.set("match_rule", (Object)rule.getRule());
            dynamicObject.set("trans_type", (Object)MatchRuleTransTypeEnum.COMMON.getId());
            SaveServiceHelper.update((DynamicObject)dynamicObject);
        }
        String jsonStr = JsonUtil.toJson(rule);
        this.getPageCache().put("eb_matchRulePlugin_instance", jsonStr);
        rule = this.getMatchParams(rule);
        this.saveMatchParams(rule, args);
    }

    private MatchRule getMatchParams(MatchRule rule) {
        IDataModel entryOperate = this.getModel();
        DynamicObjectCollection collection = entryOperate.getEntryEntity("match_tree_entity");
        for (DynamicObject dynamicObject : collection) {
            String v2;
            String k = dynamicObject.getString("define_param");
            if (MatchRule.commonParams.contains(k)) {
                // empty if block
            }
            if (!StringUtil.isNotNil(k)) continue;
            rule.addDefineParam(k);
            String v1 = dynamicObject.getString("receipt_param");
            if (StringUtil.isNotNil(v1)) {
                rule.addReceiptParam(k, v1);
            }
            if (!StringUtil.isNotNil(v2 = dynamicObject.getString("detail_param"))) continue;
            rule.addDetailParam(k, v2);
        }
        return rule;
    }

    private void saveMatchParams(MatchRule rule, BeforeDoOperationEventArgs args) {
        DynamicObject[] dynamicObjects;
        String refId = rule.getId();
        String[] s = rule.getRule().split("-");
        List<String> paramList = Arrays.asList(s);
        ArrayList<DynamicObject> dynamicObjectList = new ArrayList<DynamicObject>(1);
        ArrayList<DynamicObject> updateObjectList = new ArrayList<DynamicObject>(1);
        for (String defineParam : rule.getDefineParams()) {
            String receiptParam = rule.getReceiptMapping().get(defineParam);
            String detailParam = rule.getDetailMapping().get(defineParam);
            if (receiptParam.length() > 30) {
                this.getView().showErrorNotification(String.format(ResManager.loadKDString((String)"\u4fdd\u5b58\u5931\u8d25\uff0c\u56de\u5355\u6620\u5c04\u5b57\u6bb5%s\u957f\u5ea6\u8d85\u9650\u3002", (String)"MatchRuleBillPlugin_8", (String)"ebg-receipt-formplugin", (Object[])new Object[0]), defineParam));
                args.setCancel(true);
                return;
            }
            if (detailParam.length() > 30) {
                this.getView().showErrorNotification(String.format(ResManager.loadKDString((String)"\u4fdd\u5b58\u5931\u8d25\uff0c\u660e\u7ec6\u6620\u5c04\u5b57\u6bb5%s\u957f\u5ea6\u8d85\u9650\u3002", (String)"MatchRuleBillPlugin_9", (String)"ebg-receipt-formplugin", (Object[])new Object[0]), defineParam));
                args.setCancel(true);
                return;
            }
            QFilter filter = QFilter.of((String)"number = ? and ref_id = ?", (Object[])new Object[]{defineParam, refId});
            DynamicObject dynamicObject = BusinessDataServiceHelper.loadSingle((String)match_param_entity, (String)match_param_properties, (QFilter[])filter.toArray());
            if (dynamicObject == null) {
                dynamicObject = BusinessDataServiceHelper.newDynamicObject((String)match_param_entity);
                dynamicObject.set("number", (Object)defineParam);
                dynamicObject.set("name", (Object)defineParam);
                dynamicObject.set("ref_id", (Object)refId);
                dynamicObject.set("status", (Object)"A");
            }
            dynamicObject.set("detail_param", (Object)rule.getDetailMapping().get(defineParam));
            dynamicObject.set("receipt_param", (Object)rule.getReceiptMapping().get(defineParam));
            if (paramList.contains(defineParam)) {
                if (StringUtils.equals(dynamicObject.getString("id"), "0")) {
                    dynamicObjectList.add(dynamicObject);
                    continue;
                }
                updateObjectList.add(dynamicObject);
                continue;
            }
            DeleteServiceHelper.delete((String)match_param_entity, (QFilter[])filter.toArray());
        }
        if (dynamicObjectList.size() > 0) {
            SaveServiceHelper.save((DynamicObject[])dynamicObjectList.toArray(new DynamicObject[0]));
        }
        if (updateObjectList.size() > 0) {
            SaveServiceHelper.update((DynamicObject[])updateObjectList.toArray(new DynamicObject[0]));
        }
        QFilter filter = QFilter.of((String)"ref_id = ?", (Object[])new Object[]{refId});
        if (rule.getDefineParams().isEmpty()) {
            DeleteServiceHelper.delete((String)match_param_entity, (QFilter[])filter.toArray());
        }
        if ((dynamicObjects = BusinessDataServiceHelper.load((String)match_param_entity, (String)match_param_properties, (QFilter[])filter.toArray())) != null) {
            for (DynamicObject dynamicObject : dynamicObjects) {
                String param = dynamicObject.getString("number");
                if (paramList.contains(param)) continue;
                filter = QFilter.of((String)"number = ? and ref_id = ?", (Object[])new Object[]{param, refId});
                DeleteServiceHelper.delete((String)match_param_entity, (QFilter[])filter.toArray());
            }
        }
    }

    private boolean isDefinedMatchRule(String bankVersion) {
        QFilter filter = QFilter.of((String)"bank_version=? and number=? and trans_type=? ", (Object[])new Object[]{bankVersion, "define", MatchRuleTransTypeEnum.COMMON.getId()});
        DynamicObject dynamicObject = BusinessDataServiceHelper.loadSingle((String)entity, (String)properties, (QFilter[])filter.toArray());
        return dynamicObject != null;
    }

    public void loadTransType(String bankVersion) {
        this.getView().setVisible(Boolean.valueOf(true), new String[]{"trans_type"});
        ArrayList<ComboItem> comboList = new ArrayList<ComboItem>(1);
        QFilter filter = QFilter.of((String)"bank_version=?", (Object[])new Object[]{bankVersion});
        DynamicObject[] dynamicObjects = BusinessDataServiceHelper.load((String)entity, (String)properties, (QFilter[])filter.toArray());
        if (dynamicObjects != null && dynamicObjects.length > 1) {
            HashSet transTypes = Sets.newHashSetWithExpectedSize((int)1);
            for (DynamicObject dynamicObject : dynamicObjects) {
                String transType = dynamicObject.getString("trans_type");
                transTypes.add(transType);
            }
            for (MatchRuleTransTypeEnum matchRuleTransTypeEnum : MatchRuleTransTypeEnum.values()) {
                if (!transTypes.contains(matchRuleTransTypeEnum.getId())) continue;
                comboList.add(new ComboItem(new LocaleString(matchRuleTransTypeEnum.getCnName()), matchRuleTransTypeEnum.getId()));
            }
        } else {
            comboList.add(new ComboItem(new LocaleString(MatchRuleTransTypeEnum.COMMON.getCnName()), MatchRuleTransTypeEnum.COMMON.getId()));
        }
        ComboEdit comboEdit = (ComboEdit)this.getView().getControl("trans_type");
        comboEdit.setComboItems(comboList);
        comboEdit.setMustInput(true);
        this.getModel().setValue("trans_type", (Object)MatchRuleTransTypeEnum.COMMON.getId());
    }

    private void loadMatchRule(String bankVersion, String type, String transType) {
        DynamicObject dynamicObject;
        MatchRule matchRule = new MatchRule();
        matchRule.setBankVersion(bankVersion);
        matchRule.setType(type);
        if (EBGStringUtils.isEmpty((String)transType)) {
            transType = MatchRuleTransTypeEnum.COMMON.getId();
        }
        QFilter filter = QFilter.of((String)"bank_version=? and number=? and trans_type=?", (Object[])new Object[]{bankVersion, type, transType});
        if ("common".equals(type)) {
            filter = QFilter.of((String)"number=? and trans_type=?", (Object[])new Object[]{type, transType});
        }
        if ((dynamicObject = BusinessDataServiceHelper.loadSingle((String)entity, (String)properties, (QFilter[])filter.toArray())) == null) {
            filter = QFilter.of((String)"bank_version=? and number=?", (Object[])new Object[]{bankVersion, "define"});
            dynamicObject = BusinessDataServiceHelper.loadSingle((String)entity, (String)properties, (QFilter[])filter.toArray());
        }
        if (dynamicObject != null) {
            String id = dynamicObject.getString("id");
            String rule = dynamicObject.getString("match_rule");
            String name = dynamicObject.getString("name");
            if (EBGStringUtils.isEmpty((String)transType)) {
                this.getView().getModel().setValue("trans_type", (Object)MatchRuleTransTypeEnum.COMMON.getId());
            } else {
                this.getView().getModel().setValue("trans_type", (Object)transType);
            }
            this.getView().getModel().setValue("receipt_rule", (Object)rule);
            TextEdit textEdit = (TextEdit)this.getControl("receipt_rule");
            textEdit.setEnable("", false, 0);
            matchRule.setId(id);
            matchRule.setRule(rule);
            matchRule.setName(name);
            Date date = dynamicObject.getDate("modifytime");
            this.getView().getModel().setValue("edit_time", (Object)date);
        } else {
            String rule = "accNo-oppAccNo-transDate-Amount-cdFlag-serialNo";
            this.getView().getModel().setValue("receipt_rule", (Object)rule);
            TextEdit textEdit = (TextEdit)this.getControl("receipt_rule");
            this.getView().getModel().setValue("trans_type", (Object)MatchRuleTransTypeEnum.COMMON.getId());
            textEdit.setEnable("", false, 0);
            matchRule.setRule(rule);
            this.getView().getModel().setValue("edit_time", (Object)new Date());
        }
        String jsonStr = JsonUtil.toJson(matchRule);
        this.getPageCache().put("eb_matchRulePlugin_instance", jsonStr);
    }

    public void loadMatchParams() {
        String jsonStr = this.getPageCache().get("eb_matchRulePlugin_instance");
        if (StringUtil.isNotNil(jsonStr)) {
            IDataModel entryOperate = this.getModel();
            entryOperate.deleteEntryData("match_tree_entity");
            MatchRule matchRule = JsonUtil.fromJson(jsonStr, MatchRule.class);
            String id = matchRule.getId();
            QFilter filter = QFilter.of((String)"ref_id = ?", (Object[])new Object[]{id});
            DynamicObject[] dynamicObjects = BusinessDataServiceHelper.load((String)match_param_entity, (String)match_param_properties, (QFilter[])filter.toArray(), (String)"id asc");
            for (String param : MatchRule.commonParams) {
                int row = entryOperate.createNewEntryRow("match_tree_entity");
                this.getModel().setValue("define_param", (Object)param, row);
                this.getModel().setValue("receipt_param", (Object)param, row);
                this.getModel().setValue("detail_param", (Object)param, row);
            }
            if (StringUtils.isNotEmpty(matchRule.getRule())) {
                String[] s = matchRule.getRule().split("-");
                List<String> paramList = Arrays.asList(s);
                if (dynamicObjects != null && dynamicObjects.length > 0) {
                    for (DynamicObject dynamicObject : dynamicObjects) {
                        if (!paramList.contains(dynamicObject.getString("number"))) continue;
                        String number = dynamicObject.getString("number");
                        CommonFieldIndexEnum commonFieldIndexEnum = CommonFieldIndexEnum.getCompareEnumByName(number);
                        int row = 0;
                        row = commonFieldIndexEnum != null ? commonFieldIndexEnum.getIndex() : entryOperate.createNewEntryRow("match_tree_entity");
                        this.getModel().setValue("define_param", (Object)dynamicObject.getString("number"), row);
                        this.getModel().setValue("receipt_param", (Object)dynamicObject.getString("receipt_param"), row);
                        this.getModel().setValue("detail_param", (Object)dynamicObject.getString("detail_param"), row);
                    }
                }
            }
        }
    }

    private void lockGridData() {
        EntryGrid treeEntryGrid = (EntryGrid)this.getControl("match_tree_entity");
        int rowCount = treeEntryGrid.getModel().getEntryRowCount(treeEntryGrid.getEntryKey());
        if (this.isNeedLock()) {
            treeEntryGrid.setRowLock(true, new int[]{0, 1, 2, 3, 4, 5});
        }
    }

    public boolean isNeedLock() {
        return !MatchRuleBillPlugin.isTestEnv();
    }

    public static boolean isTestEnv() {
        String clientUrl = UrlService.getDomainContextUrl();
        if (clientUrl.contains("feature.kingdee.com")) {
            return true;
        }
        if (clientUrl.contains("localhost")) {
            return true;
        }
        return clientUrl.contains("127.0.0.1");
    }

    private boolean isConstainCommonFiled() {
        EntryGrid treeEntryGrid = (EntryGrid)this.getControl("match_tree_entity");
        int rowCount = treeEntryGrid.getModel().getEntryRowCount(treeEntryGrid.getEntryKey());
        for (int row = 6; row < rowCount; ++row) {
            DynamicObject dynamicObject = this.getModel().getEntryRowEntity("match_tree_entity", row);
            String defineParam = dynamicObject.getString("define_param");
            String receiptParam = dynamicObject.getString("receipt_param");
            String detailParam = dynamicObject.getString("detail_param");
            if (StringUtils.isEmpty(defineParam)) {
                this.getView().showErrorNotification(String.format(ResManager.loadKDString((String)"\u66f4\u65b0\u5931\u8d25\uff0c\u5f53\u524d\u884c\u53f7\u4e3a%s\uff0c\u5339\u914d\u5b57\u6bb5\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"MatchRuleBillPlugin_24", (String)"ebg-receipt-formplugin", (Object[])new Object[0]), row + 1));
                return true;
            }
            if (StringUtils.isEmpty(receiptParam)) {
                this.getView().showErrorNotification(String.format(ResManager.loadKDString((String)"\u66f4\u65b0\u5931\u8d25\uff0c\u5f53\u524d\u884c\u53f7\u4e3a%s\uff0c\u56de\u5355\u5339\u914d\u6620\u5c04\u5b57\u6bb5\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"MatchRuleBillPlugin_25", (String)"ebg-receipt-formplugin", (Object[])new Object[0]), row + 1));
                return true;
            }
            if (StringUtils.isEmpty(detailParam)) {
                this.getView().showErrorNotification(String.format(ResManager.loadKDString((String)"\u66f4\u65b0\u5931\u8d25\uff0c\u5f53\u524d\u884c\u53f7\u4e3a%s\uff0c\u660e\u7ec6\u5339\u914d\u6620\u5c04\u5b57\u6bb5\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"MatchRuleBillPlugin_26", (String)"ebg-receipt-formplugin", (Object[])new Object[0]), row + 1));
                return true;
            }
            if (this.isRepeatDefine(defineParam, row).booleanValue()) {
                this.getView().showErrorNotification(String.format(ResManager.loadKDString((String)"\u66f4\u65b0\u5931\u8d25\uff0c\u5339\u914d\u5b57\u6bb5%s\u91cd\u590d\u3002", (String)"MatchRuleBillPlugin_13", (String)"ebg-receipt-formplugin", (Object[])new Object[0]), defineParam));
                return true;
            }
            if (!this.isDefaultParam(defineParam)) continue;
            this.getView().showErrorNotification(String.format(ResManager.loadKDString((String)"\u66f4\u65b0\u5931\u8d25\uff0c\u5f53\u524d\u884c\u53f7\u4e3a%1$s\uff0c\u5339\u914d\u5b57\u6bb5%2$s\u4e3a\u901a\u7528\u6a21\u677f\u5b57\u6bb5\uff0c\u4e0d\u5141\u8bb8\u66f4\u65b0\u3002", (String)"MatchRuleBillPlugin_27", (String)"ebg-receipt-formplugin", (Object[])new Object[0]), row + 1, defineParam));
            return true;
        }
        return false;
    }

    private void updateMatchRule() {
        TextEdit textEdit = (TextEdit)this.getControl("receipt_rule");
        textEdit.setEnable("", false, 0);
        int rowCount = this.getModel().getEntryRowCount("match_tree_entity");
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < rowCount; ++i) {
            DynamicObject dynamicObject = this.getModel().getEntryRowEntity("match_tree_entity", i);
            String param = dynamicObject.getString("define_param");
            sb.append(param);
            if (i >= rowCount - 1) continue;
            sb.append("-");
        }
        String rule = sb.toString();
        this.getModel().setValue("receipt_rule", (Object)rule);
        String jsonStr = this.getPageCache().get("eb_matchRulePlugin_instance");
        MatchRule matchRule = StringUtil.isNotNil(jsonStr) ? JsonUtil.fromJson(jsonStr, MatchRule.class) : new MatchRule();
        matchRule.setRule(rule);
        this.getPageCache().put("eb_matchRulePlugin_instance", JsonUtil.toJson(matchRule));
    }

    private boolean removeMatchRule(String bankVersion) {
        QFilter filter = QFilter.of((String)"bank_version=? and number=? and trans_type=? ", (Object[])new Object[]{bankVersion, "define", MatchRuleTransTypeEnum.COMMON.getId()});
        DynamicObject dynamicObject = BusinessDataServiceHelper.loadSingle((String)entity, (String)properties, (QFilter[])filter.toArray());
        if (dynamicObject != null) {
            String id = dynamicObject.getString("id");
            DeleteServiceHelper.delete((String)entity, (QFilter[])filter.toArray());
            filter = QFilter.of((String)"ref_id = ?", (Object[])new Object[]{id});
            DeleteServiceHelper.delete((String)match_param_entity, (QFilter[])filter.toArray());
        }
        return true;
    }

    private String checkTreeGrid(BeforeDoOperationEventArgs args) {
        String msg = "";
        int rowCount = this.getModel().getEntryRowCount("match_tree_entity");
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < rowCount; ++i) {
            DynamicObject dynamicObject = this.getModel().getEntryRowEntity("match_tree_entity", i);
            String param_define = dynamicObject.getString("define_param");
            String param_receipt = dynamicObject.getString("receipt_param");
            String param_detail = dynamicObject.getString("detail_param");
            if (StringUtils.isEmpty(param_define)) {
                sb.append(ResManager.loadKDString((String)"\u5339\u914d\u5b57\u6bb5\u4e3a\u7a7a\u3002", (String)"MatchRuleBillPlugin_15", (String)"ebg-receipt-formplugin", (Object[])new Object[0]));
            }
            if (StringUtils.isEmpty(param_receipt)) {
                sb.append(ResManager.loadKDString((String)"\u56de\u5355\u6620\u5c04\u5b57\u6bb5\u4e3a\u7a7a\u3002", (String)"MatchRuleBillPlugin_16", (String)"ebg-receipt-formplugin", (Object[])new Object[0]));
            }
            if (StringUtils.isEmpty(param_detail)) {
                sb.append(ResManager.loadKDString((String)"\u660e\u7ec6\u6620\u5c04\u5b57\u6bb5\u4e3a\u7a7a\u3002", (String)"MatchRuleBillPlugin_17", (String)"ebg-receipt-formplugin", (Object[])new Object[0]));
            }
            if (param_define.length() > 30) {
                sb.append(ResManager.loadKDString((String)"\u5339\u914d\u5b57\u6bb5\u957f\u5ea6\u8d85\u9650\u3002", (String)"MatchRuleBillPlugin_18", (String)"ebg-receipt-formplugin", (Object[])new Object[0]));
            }
            if (param_receipt.length() > 30) {
                sb.append(ResManager.loadKDString((String)"\u56de\u5355\u6620\u5c04\u5b57\u6bb5\u957f\u5ea6\u8d85\u9650\u5ea6\u3002", (String)"MatchRuleBillPlugin_19", (String)"ebg-receipt-formplugin", (Object[])new Object[0]));
            }
            if (param_detail.length() > 30) {
                sb.append(ResManager.loadKDString((String)"\u660e\u7ec6\u6620\u5c04\u5b57\u6bb5\u957f\u5ea6\u8d85\u9650\u3002", (String)"MatchRuleBillPlugin_20", (String)"ebg-receipt-formplugin", (Object[])new Object[0]));
            }
            if (StringUtils.isEmpty(sb.toString())) continue;
            sb.append(ResManager.loadKDString((String)"\u884c\u53f7\uff1a", (String)"MatchRuleBillPlugin_21", (String)"ebg-receipt-formplugin", (Object[])new Object[0])).append(i + 1).append("\r\n");
            msg = sb.toString();
            break;
        }
        return msg;
    }

    private Boolean isRepeatDefine(String param, int row) {
        int repeatCount = 0;
        int rowCount = this.getModel().getEntryRowCount("match_tree_entity");
        for (int i = 0; i < rowCount; ++i) {
            DynamicObject dynamicObject = this.getModel().getEntryRowEntity("match_tree_entity", i);
            String param_define = dynamicObject.getString("define_param");
            if (!param.equals(param_define) || row == i) continue;
            ++repeatCount;
        }
        return repeatCount > 0;
    }

    private boolean isDefaultParam(String param) {
        return MatchRule.getCommonParams().contains(param);
    }
}

