/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.receipt.formplugin.plugin.monitor.connect;

import java.util.Objects;
import kd.bos.bill.OperationStatus;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.ShowType;
import kd.bos.form.StyleCss;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.events.SetFilterEvent;
import kd.bos.form.operate.FormOperate;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.plugin.AbstractListPlugin;
import kd.ebg.receipt.business.receipt.utils.ReceiptDownloadConnectMonitorUtils;
import kd.ebg.receipt.common.constant.monitor.ReceiptPushWayEnum;
import kd.ebg.receipt.common.framework.frame.EBGLogger;
import kd.ebg.receipt.common.model.monitor.ReceiptConnectMonitorInfo;
import kd.ebg.receipt.common.model.repository.monitor.ReceiptConnectMonitorRepository;
import kd.ebg.receipt.common.utils.SpringContextUtil;

public class ReceiptConnectMonitorListPlugin
extends AbstractListPlugin {
    private static final String ENTITY_KEY = "receipt_bank_login";
    private static EBGLogger logger = EBGLogger.getInstance().getLogger(ReceiptConnectMonitorListPlugin.class);
    private static final String TEST_CONNECT_BUTTON = "testconnect";
    private static final String TEST_CONNECT_OPERATION_KEY = "test_connect";
    private static final String TEST_CONNECT_SETTING_KEY = "test_connect_setting";

    public void setFilter(SetFilterEvent e) {
        super.setFilter(e);
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        ListSelectedRowCollection listSelectedRowCollection;
        super.beforeDoOperation(args);
        FormOperate formOperate = (FormOperate)args.getSource();
        String operateKey = formOperate.getOperateKey();
        if (Objects.equals("delete", operateKey)) {
            try {
                listSelectedRowCollection = args.getListSelectedData();
                if (listSelectedRowCollection.size() == 0 || listSelectedRowCollection == null) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u8981\u6267\u884c\u7684\u6570\u636e\u3002", (String)"ReceiptConnectMonitorListPlugin_0", (String)"ebg-receipt-formplugin", (Object[])new Object[0]));
                    args.setCancel(true);
                    return;
                }
                ReceiptDownloadConnectMonitorUtils receiptDownloadConnectMonitorUtils = new ReceiptDownloadConnectMonitorUtils();
                listSelectedRowCollection.forEach(selectedRow -> {
                    Long fid = (Long)selectedRow.getPrimaryKeyValue();
                    receiptDownloadConnectMonitorUtils.isMeetConditionDelete(fid);
                });
            }
            catch (Exception e) {
                this.getView().showTipNotification(e.getMessage());
                args.setCancel(true);
            }
        }
        if (Objects.equals(TEST_CONNECT_OPERATION_KEY, operateKey)) {
            listSelectedRowCollection = args.getListSelectedData();
            if (listSelectedRowCollection.size() == 0 || listSelectedRowCollection == null) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u8981\u6267\u884c\u7684\u6570\u636e\u3002", (String)"ReceiptConnectMonitorListPlugin_0", (String)"ebg-receipt-formplugin", (Object[])new Object[0]));
                return;
            }
            listSelectedRowCollection.forEach(selectedRow -> {
                Long fid = (Long)selectedRow.getPrimaryKeyValue();
                ReceiptDownloadConnectMonitorUtils receiptDownloadConnectMonitorUtils = new ReceiptDownloadConnectMonitorUtils();
                try {
                    receiptDownloadConnectMonitorUtils.testConnect(fid, false);
                    this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u6d4b\u8bd5\u8fde\u63a5\u6210\u529f\u3002", (String)"ReceiptConnectMonitorListPlugin_1", (String)"ebg-receipt-formplugin", (Object[])new Object[0]));
                }
                catch (Exception e) {
                    logger.monitorError("ReceiptConnectMonitor#error:" + e.getMessage(), (Throwable)e);
                    ReceiptConnectMonitorRepository getReceiptConnectMonitorRepository = (ReceiptConnectMonitorRepository)SpringContextUtil.getBean(ReceiptConnectMonitorRepository.class);
                    ReceiptConnectMonitorInfo receiptConnectMonitorInfo = getReceiptConnectMonitorRepository.findById(fid.longValue());
                    String pushWay = receiptConnectMonitorInfo.getReceipt_way();
                    if (Objects.equals(pushWay, ReceiptPushWayEnum.BANK_LOGIN.getCode())) {
                        String message = ResManager.loadKDString((String)"\u524d\u7f6e\u673a\u4ee3\u7406\u8fde\u63a5\u5931\u8d25\uff0c\u8bf7\u68c0\u67e5IP\u7aef\u53e3\u662f\u5426\u51c6\u786e\uff0c\u7f51\u7edc\u8fde\u63a5\u662f\u5426\u901a\u7545\uff0c\u4ee3\u7406\u7a0b\u5e8f\u7535\u5b50\u56de\u5355\u6587\u4ef6\u670d\u52a1\u662f\u5426\u6b63\u5e38\u8fd0\u884c\u3002", (String)"JumpRemoteFilter_4", (String)"ebg-receipt-formplugin", (Object[])new Object[0]);
                        this.getView().showErrorNotification(message);
                    }
                    this.getView().showErrorNotification(e.getMessage());
                }
            });
            this.getView().invokeOperation("refresh");
        }
        if (StringUtils.equals((CharSequence)TEST_CONNECT_SETTING_KEY, (CharSequence)operateKey)) {
            this.showSettingPage();
        }
    }

    public void showSettingPage() {
        FormShowParameter showParameter = new FormShowParameter();
        showParameter.setFormId("receipt_c_monitor_setting");
        StyleCss style = new StyleCss();
        showParameter.getOpenStyle().setShowType(ShowType.Modal);
        showParameter.getOpenStyle().setInlineStyleCss(style);
        showParameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, "test"));
        showParameter.setStatus(OperationStatus.EDIT);
        this.getView().showForm(showParameter);
    }

    public void closedCallBack(ClosedCallBackEvent closedCallBackEvent) {
        String result;
        if (closedCallBackEvent.getReturnData() != null && "success".equals(result = (String)closedCallBackEvent.getReturnData())) {
            this.getView().invokeOperation("refresh");
        }
    }
}

