/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.receipt.formplugin.plugin.task;

import com.google.common.collect.Maps;
import java.time.LocalDate;
import java.util.Date;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import kd.bos.bill.AbstractBillPlugIn;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.form.events.BeforeClosedEvent;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.form.operate.FormOperate;
import kd.ebg.egf.common.utils.LocalDateUtil;
import kd.ebg.receipt.common.constant.MatchStatusEnum;
import kd.ebg.receipt.common.core.utils.EBGStringUtils;
import kd.ebg.receipt.common.framework.receipt.exception.ReceiptException;
import kd.ebg.receipt.common.model.repository.DetailInfoRepository;
import kd.ebg.receipt.common.model.repository.receipt.DownloadListDetailRepository;
import kd.ebg.receipt.common.utils.SpringContextUtil;

public class ReceiptNoEditPlugin
extends AbstractBillPlugIn
implements BeforeF7SelectListener {
    public void registerListener(EventObject e) {
        super.registerListener(e);
    }

    public void beforeF7Select(BeforeF7SelectEvent e) {
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        super.beforeDoOperation(args);
        FormOperate formOperate = (FormOperate)args.getSource();
        if (StringUtils.equals((CharSequence)"update", (CharSequence)formOperate.getOperateKey())) {
            IDataModel model = this.getModel();
            String newReceiptNo = (String)model.getValue("new_receipt_no");
            if (EBGStringUtils.isEmpty((String)newReceiptNo)) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u73b0\u4ea4\u6613\u660e\u7ec6\u5339\u914d\u7801\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"ReceiptNoEditPlugin_0", (String)"ebg-receipt-formplugin", (Object[])new Object[0]));
                args.setCancel(true);
                return;
            }
            try {
                this.resetMatch(newReceiptNo);
                this.getPageCache().put("update_success", "true");
                this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u64cd\u4f5c\u6210\u529f\u3002", (String)"ReceiptNoEditPlugin_1", (String)"ebg-receipt-formplugin", (Object[])new Object[0]));
            }
            catch (Exception e) {
                this.getView().showTipNotification(e.getMessage());
                args.setCancel(true);
                return;
            }
        }
    }

    public void beforeBindData(EventObject e) {
        super.beforeBindData(e);
    }

    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        String oldReceiptNo = (String)this.getView().getFormShowParameter().getCustomParam("old_receipt_no");
        this.getModel().getDataEntity().set("old_receipt_no", (Object)oldReceiptNo);
    }

    public void beforeClosed(BeforeClosedEvent e) {
        super.beforeClosed(e);
        e.setCheckDataChange(false);
        if ("true".equals(this.getPageCache().get("update_success"))) {
            this.getView().returnDataToParent((Object)"success");
        }
    }

    public void resetMatch(String newReceiptNo) {
        Long id;
        DownloadListDetailRepository downloadListDetailRepository = (DownloadListDetailRepository)SpringContextUtil.getBean(DownloadListDetailRepository.class);
        Long fid = (Long)this.getView().getFormShowParameter().getCustomParam("recordId");
        DynamicObject existSameReceipt = downloadListDetailRepository.selectByReceiptNo(newReceiptNo);
        if (existSameReceipt != null && (id = Long.valueOf(existSameReceipt.getLong("id"))).intValue() != fid.intValue()) {
            throw new ReceiptException(String.format(ResManager.loadKDString((String)"\u5df2\u5b58\u5728\u4ea4\u6613\u660e\u7ec6\u5339\u914d\u7801%s\uff0c\u8bf7\u5f55\u5165\u6b63\u786e\u7684\u5339\u914d\u7801\u3002", (String)"ReceiptNoEditPlugin_2", (String)"ebg-receipt-formplugin", (Object[])new Object[0]), newReceiptNo));
        }
        DynamicObject dynamicObject = downloadListDetailRepository.selectById(fid);
        String accNo = dynamicObject.getString("acc_no.number");
        String bankVersionId = dynamicObject.getString("bank_version.number");
        LocalDate transDate = LocalDateUtil.date2LocalDate((Date)dynamicObject.getDate("trans_date"));
        DetailInfoRepository detailInfoRepository = (DetailInfoRepository)SpringContextUtil.getBean(DetailInfoRepository.class);
        List detailInfoList = detailInfoRepository.findByAccNoAndBankVersionIDAndTransDateBetween(accNo, bankVersionId, transDate, transDate);
        HashMap detailInfoMap = Maps.newHashMapWithExpectedSize((int)detailInfoList.size());
        detailInfoList.forEach(o -> detailInfoMap.put(o.getReceiptNo(), o));
        dynamicObject.set("detail_no", (Object)newReceiptNo);
        if (detailInfoMap.containsKey(newReceiptNo)) {
            dynamicObject.set("match_flag", (Object)MatchStatusEnum.SUCCESS.getId());
            dynamicObject.set("modifytime", (Object)new Date());
            downloadListDetailRepository.update(dynamicObject);
        } else {
            dynamicObject.set("match_flag", (Object)MatchStatusEnum.FAIL.getId());
            dynamicObject.set("modifytime", (Object)new Date());
            downloadListDetailRepository.update(dynamicObject);
        }
    }
}

