/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.receipt.formplugin.plugin.task;

import java.time.LocalDate;
import java.util.concurrent.Callable;
import java.util.concurrent.TimeUnit;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.util.ConfigurationUtil;
import kd.ebg.egf.common.cache.CosmicCache;
import kd.ebg.egf.common.utils.LocalDateUtil;
import kd.ebg.receipt.business.receipt.entity.HandlerType;
import kd.ebg.receipt.business.receipt.entity.ReceiptHandlerRequest;
import kd.ebg.receipt.business.receipt.framework.EBThreadPools;
import kd.ebg.receipt.business.receipt.framework.TaskActuator;
import kd.ebg.receipt.business.receipt.framework.TaskFactory;
import kd.ebg.receipt.business.receipt.impl.task.BatchDownLoadTask;
import kd.ebg.receipt.business.receipt.impl.task.DownLoadTask;
import kd.ebg.receipt.business.receipt.impl.task.IntegrityTask;
import kd.ebg.receipt.business.receipt.impl.task.MatchTask;
import kd.ebg.receipt.common.constant.TaskStatusEnum;
import kd.ebg.receipt.common.core.utils.EBGStringUtils;
import kd.ebg.receipt.common.framework.context.RequestContextUtils;
import kd.ebg.receipt.common.framework.receipt.exception.ReceiptException;
import kd.ebg.receipt.common.framework.services.receipt.DownloadTaskService;
import kd.ebg.receipt.common.model.receipt.DownloadListTask;
import kd.ebg.receipt.common.utils.FileCommonUtils;
import kd.ebg.receipt.common.utils.SpringContextUtil;

public class ReceiptTaskUtils {
    private DownloadTaskService downloadTaskService = (DownloadTaskService)SpringContextUtil.getBean(DownloadTaskService.class);

    public void doReceiptTaskByTaskId(Long taskId) {
        DownloadListTask downloadListTask = this.downloadTaskService.findById(taskId.longValue());
        String customId = RequestContext.get().getTenantId();
        downloadListTask.setCustomNo(customId);
        int taskStatus = downloadListTask.getStatus();
        if (taskStatus == TaskStatusEnum.FAILED.getId() || taskStatus == TaskStatusEnum.FINISH.getId()) {
            throw new ReceiptException(ResManager.loadKDString((String)"\u4e0d\u80fd\u9009\u62e9\u5b8c\u6210\u6216\u5931\u8d25\u7684\u4efb\u52a1\uff0c\u8bf7\u91cd\u65b0\u9009\u62e9", (String)"ReceiptTaskUtils_0", (String)"ebg-receipt-formplugin", (Object[])new Object[0]));
        }
        if (taskStatus == TaskStatusEnum.PROCESSING.getId() || taskStatus == TaskStatusEnum.DOWNLOADING.getId()) {
            throw new ReceiptException(ResManager.loadKDString((String)"\u4e0d\u80fd\u9009\u62e9\u6b63\u5728\u5904\u7406\u4e2d\u7684\u4efb\u52a1\uff0c\u8bf7\u91cd\u65b0\u9009\u62e9", (String)"ReceiptTaskUtils_1", (String)"ebg-receipt-formplugin", (Object[])new Object[0]));
        }
        if (taskStatus == TaskStatusEnum.RETRYING.getId()) {
            downloadListTask.setRedo(Integer.valueOf(0));
            downloadListTask.setStatus(Integer.valueOf(TaskStatusEnum.CREATE.getId()));
            downloadListTask.setExpmsg("");
            this.downloadTaskService.update(downloadListTask);
            taskStatus = TaskStatusEnum.CREATE.getId();
        }
        String bankVersionId = downloadListTask.getBankVersionId();
        String bankLoginId = downloadListTask.getBankLoginId();
        ReceiptHandlerRequest receiptRequest = new ReceiptHandlerRequest();
        receiptRequest.setBankVersion(bankVersionId);
        receiptRequest.setBatchSeqId(downloadListTask.getBatchNo());
        receiptRequest.setTransDate(LocalDateUtil.formatDate((LocalDate)downloadListTask.getTransDate()));
        receiptRequest.setBankLoginId(bankLoginId);
        receiptRequest.setCustomId(downloadListTask.getCustomNo());
        receiptRequest.setTaskId(downloadListTask.getId());
        receiptRequest.setAccNo(downloadListTask.getAccNo());
        boolean isSupportBatchDownload = RequestContextUtils.isSupportBatchDownloadByBankLogin((String)bankVersionId, (String)bankLoginId);
        String isSyncDownload = ConfigurationUtil.getString((String)String.format("%s_isAsyncDownload_receipt", RequestContext.get().getTenantId()));
        if (EBGStringUtils.isEmpty((String)isSyncDownload)) {
            isSyncDownload = "false";
        }
        if (taskStatus == TaskStatusEnum.CREATE.getId() || taskStatus == TaskStatusEnum.COMPLETED.getId()) {
            receiptRequest.setType(HandlerType.DOWNLOAD.getName());
            DownLoadTask downLoadTask = new DownLoadTask(receiptRequest);
            if (isSupportBatchDownload && !downloadListTask.getTransDate().isEqual(LocalDate.now())) {
                receiptRequest.setType(HandlerType.BATCH_DOWNLOAD.getName());
                receiptRequest.setTaskStatus(Integer.valueOf(taskStatus));
                downLoadTask = new BatchDownLoadTask(receiptRequest);
            }
            String key = this.getCacheKey(receiptRequest.getTaskId());
            CosmicCache.delete((String)key);
            if (Boolean.parseBoolean(isSyncDownload)) {
                if (isSupportBatchDownload && !this.isConformDownloadOfBatch(downloadListTask)) {
                    return;
                }
                if (downLoadTask.match() && downLoadTask.preTask()) {
                    try {
                        downLoadTask.subProcess();
                    }
                    catch (Throwable e) {
                        throw new ReceiptException(e);
                    }
                    finally {
                        downLoadTask.afterTask();
                    }
                } else {
                    throw new ReceiptException(ResManager.loadKDString((String)"\u4efb\u52a1\u6b63\u5728\u6267\u884c\u4e2d\uff0c\u8bf7\u7a0d\u540e\u91cd\u8bd5", (String)"ReceiptTaskUtils_2", (String)"ebg-receipt-formplugin", (Object[])new Object[0]));
                }
            }
        }
        if (taskStatus == TaskStatusEnum.DOWNLOADED.getId() || taskStatus == TaskStatusEnum.CHECKING.getId()) {
            receiptRequest.setType(HandlerType.INTEGRITY.getName());
            if (Boolean.parseBoolean(isSyncDownload)) {
                IntegrityTask integrityTask = new IntegrityTask(receiptRequest);
                if (integrityTask.match() && integrityTask.preTask()) {
                    try {
                        integrityTask.subProcess();
                    }
                    catch (Throwable e) {
                        throw new ReceiptException(e);
                    }
                    finally {
                        integrityTask.afterTask();
                    }
                } else {
                    throw new ReceiptException(ResManager.loadKDString((String)"\u56de\u5355\u6587\u4ef6\u6b63\u5728\u4e0a\u4f20\u4e2d\uff0c\u8bf7\u7a0d\u540e\u91cd\u8bd5", (String)"ReceiptTaskUtils_3", (String)"ebg-receipt-formplugin", (Object[])new Object[0]));
                }
            }
        }
        if (taskStatus == TaskStatusEnum.CHECKED.getId()) {
            receiptRequest.setType(HandlerType.MATCH.getName());
            if (Boolean.parseBoolean(isSyncDownload)) {
                MatchTask matchTask = new MatchTask(receiptRequest);
                if (matchTask.match() && matchTask.preTask()) {
                    try {
                        matchTask.subProcess();
                    }
                    catch (Throwable e) {
                        throw new ReceiptException(e);
                    }
                    finally {
                        matchTask.afterTask();
                    }
                } else {
                    throw new ReceiptException(ResManager.loadKDString((String)"\u56de\u5355\u6587\u4ef6\u6b63\u5728\u4e0a\u4f20\u4e2d\uff0c\u8bf7\u7a0d\u540e\u91cd\u8bd5", (String)"ReceiptTaskUtils_3", (String)"ebg-receipt-formplugin", (Object[])new Object[0]));
                }
            }
        }
        if (!Boolean.parseBoolean(isSyncDownload)) {
            if (isSupportBatchDownload && !this.isConformDownloadOfBatch(downloadListTask)) {
                return;
            }
            TaskActuator task = TaskFactory.getTask((ReceiptHandlerRequest)receiptRequest);
            EBThreadPools.getThreadPool((String)"download", (String)"receipt", (String)customId).submit((Callable)task);
        }
    }

    public boolean isConformDownloadOfBatch(DownloadListTask task) {
        if (task.getTransDate().isEqual(LocalDate.now())) {
            return false;
        }
        String bankLoginId = task.getBankLoginId();
        String transDateStr = LocalDateUtil.formatDate((LocalDate)task.getTransDate());
        String key = String.format("receipt_download_%s_%s_%s_lock", bankLoginId, transDateStr, task.getStatus());
        String cache_token = CosmicCache.get((String)key);
        if (FileCommonUtils.isTestEnv()) {
            cache_token = "";
        }
        if (EBGStringUtils.isEmpty((String)cache_token)) {
            CosmicCache.putIfAbsentWithExpire((String)key, (String)"true", (int)3600, (TimeUnit)TimeUnit.SECONDS);
            return true;
        }
        return false;
    }

    private String getCacheKey(long taskId) {
        return "ebg_download_" + taskId + "_lock";
    }
}

