/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.receipt.mservice.boot.handler;

import com.alibaba.fastjson.JSONObject;
import com.google.common.collect.Maps;
import com.google.common.io.Resources;
import java.io.File;
import java.lang.reflect.Method;
import java.net.URL;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import kd.bos.dataentity.resource.ResManager;
import kd.ebg.egf.common.entity.base.EBRequest;
import kd.ebg.egf.common.entity.base.EBResponse;
import kd.ebg.egf.common.exception.EBExceiptionUtil;
import kd.ebg.egf.common.framework.biz.EBServiceMethod;
import kd.ebg.egf.common.utils.string.StrUtil;
import kd.ebg.receipt.common.utils.ClassUtil;
import kd.ebg.receipt.common.utils.FileCommonUtils;
import kd.ebg.receipt.common.utils.ReflectUtil;
import kd.ebg.receipt.mservice.boot.handler.EBServiceHandler;
import kd.ebg.receipt.mservice.boot.handler.EBServiceHandlerEnhance;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EBServiceHandlerContainer {
    private static Logger logger = LoggerFactory.getLogger(EBServiceHandlerContainer.class);
    private static final String packageScan = "kd.ebg.receipt.bank";
    private static ConcurrentMap<String, EBServiceHandler<? extends EBRequest, ? extends EBResponse>> handlers = new ConcurrentHashMap<String, EBServiceHandler<? extends EBRequest, ? extends EBResponse>>();
    private static ConcurrentMap<String, EBServiceHandlerEnhance> enhanceHandlers = new ConcurrentHashMap<String, EBServiceHandlerEnhance>();
    private static Map<String, JSONObject> handlerInfo = Maps.newHashMapWithExpectedSize((int)8);
    static final String innerConfigFileName = "handlerReceipt.json";

    public static synchronized void init(String configFile, Charset charset) {
        File userFile;
        if (StrUtil.isNotBlank((CharSequence)configFile) && (userFile = FileCommonUtils.getFileByPath((String)configFile)).exists() && userFile.isFile()) {
            try {
                URL url = Resources.getResource((String)configFile);
                String content = Resources.toString((URL)url, (Charset)charset);
                EBServiceHandlerContainer.loadFromConfig(content);
            }
            catch (Exception e) {
                logger.warn("\u5916\u90e8handler \u914d\u7f6e\u6587\u4ef6\uff1a{} \u52a0\u8f7d\u5931\u8d25", (Object)userFile.getAbsolutePath());
                logger.error("\u5177\u4f53\u539f\u56e0\u4e3a", (Throwable)e);
            }
        }
        EBServiceHandlerContainer.initInner();
        EBServiceHandlerContainer.initCustomize();
    }

    static Map<String, JSONObject> getHandlerInfo() {
        return handlerInfo;
    }

    private static synchronized void initInner() {
        URL url = Resources.getResource((String)innerConfigFileName);
        try {
            String content = Resources.toString((URL)url, (Charset)StandardCharsets.UTF_8);
            EBServiceHandlerContainer.loadFromConfig(content);
        }
        catch (Exception e) {
            logger.warn("\u5185\u90e8handler \u914d\u7f6e\u6587\u4ef6\uff1a{} \u52a0\u8f7d\u5931\u8d25", (Object)innerConfigFileName);
            logger.error("\u5177\u4f53\u539f\u56e0\u4e3a", (Throwable)e);
        }
    }

    private static synchronized void initCustomize() {
        try {
            Set implSet = ReflectUtil.getSubTypesOf(EBServiceMethod.class);
            for (Class c : implSet) {
                Method method = c.getMethod("register", new Class[0]);
                String content = (String)method.invoke(c.newInstance(), new Object[0]);
                EBServiceHandlerContainer.loadFromCustomize(content);
            }
        }
        catch (Exception e) {
            logger.error("\u626b\u63cf\u63d2\u4ef6\u5305\u51fa\u9519\uff1a{}", (Object)e.getMessage());
        }
    }

    private static void loadFromConfig(String content) {
        JSONObject jsonObject = JSONObject.parseObject((String)content);
        logger.info("\u53d1\u73b0\u4e1a\u52a1\u6846\u67b6\u6807\u8bc6\uff0c\u5171\u8ba1{}\u4e2a", (Object)jsonObject.keySet().size());
        for (String key : jsonObject.keySet()) {
            if (!handlers.containsKey(key)) {
                try {
                    JSONObject handler = jsonObject.getJSONObject(key);
                    EBServiceHandlerContainer.loadHandler(key, handler);
                }
                catch (Throwable e) {
                    logger.error("\u4e1a\u52a1\u6846\u67b6\u6807\u8bc6: {}\u7684\u914d\u7f6e\u52a0\u8f7d\u5931\u8d25", (Object)key);
                    logger.error("\u9519\u8bef\u539f\u56e0\u4e3a", e);
                }
                continue;
            }
            logger.info("\u4e1a\u52a1\u6846\u67b6\u6807\u8bc6: {}\u5df2\u7ecf\u52a0\u8f7d", (Object)key);
        }
    }

    private static void loadFromCustomize(String content) {
        JSONObject jsonObject = JSONObject.parseObject((String)content);
        logger.info("\u53d1\u73b0\u5b9a\u5236\u5316\u4e1a\u52a1\u6807\u8bc6\uff0c\u5171\u8ba1{}\u4e2a", (Object)jsonObject.keySet().size());
        for (String key : jsonObject.keySet()) {
            if (!handlers.containsKey(key)) {
                try {
                    JSONObject handler = jsonObject.getJSONObject(key);
                    EBServiceHandlerContainer.loadHandler(key, handler);
                }
                catch (Throwable e) {
                    logger.error("\u5b9a\u5236\u5316\u4e1a\u52a1\u6807\u8bc6: {}\u7684\u914d\u7f6e\u52a0\u8f7d\u5931\u8d25", (Object)key);
                    logger.error("\u9519\u8bef\u539f\u56e0\u4e3a", e);
                }
                continue;
            }
            logger.info("\u5b9a\u5236\u5316\u4e1a\u52a1\u6807\u8bc6: {}\u5df2\u7ecf\u52a0\u8f7d", (Object)key);
        }
    }

    private static void loadHandler(String key, JSONObject handler) {
        String methodClassName = handler.getString("methodClass");
        String requestClassName = handler.getString("requestClass");
        String responseClassName = handler.getString("responseClass");
        Class methodClass = ClassUtil.loadClass((String)methodClassName);
        Class requestClass = ClassUtil.loadClass((String)requestClassName);
        Class responseClass = ClassUtil.loadClass((String)responseClassName);
        EBServiceHandler serviceHandler = new EBServiceHandler(key, (EBServiceMethod)ReflectUtil.newInstance((Class)methodClass), requestClass, responseClass);
        EBServiceHandlerEnhance enhance = new EBServiceHandlerEnhance(key, (EBServiceMethod)ReflectUtil.newInstance((Class)methodClass), requestClass, responseClass);
        handlers.put(key, serviceHandler);
        enhanceHandlers.put(key, enhance);
        logger.info("\u4e1a\u52a1\u6846\u67b6\u6807\u8bc6 {} \u52a0\u8f7d\u5b8c\u6bd5 , EBServiceMethod:{} , requestClass:{} , responseClass:{}", new Object[]{key, methodClassName, requestClassName, responseClassName});
        handlerInfo.put(key, handler);
    }

    public static EBServiceHandler<? extends EBRequest, ? extends EBResponse> getHandler(String method) {
        return (EBServiceHandler)handlers.get(method);
    }

    public static EBServiceHandlerEnhance getHandlerEnhance(String method) {
        if (!enhanceHandlers.containsKey(method)) {
            throw EBExceiptionUtil.preCheckException((String)String.format(ResManager.loadKDString((String)"\u4e0d\u652f\u6301\u7684\u65b9\u6cd5:%s\u3002", (String)"EBServiceHandlerContainer_4", (String)"ebg-receipt-mservice", (Object[])new Object[0]), method));
        }
        return (EBServiceHandlerEnhance)enhanceHandlers.get(method);
    }

    public static EBServiceHandlerEnhance getHandlerEnhance(EBRequest request) {
        if (request != null) {
            if (request.getHeader() != null) {
                String operationName = request.getHeader().getOperationName();
                if (StrUtil.isBlank((CharSequence)operationName)) {
                    operationName = request.getHeader().getBizType();
                }
                if (StrUtil.isBlank((CharSequence)operationName)) {
                    throw EBExceiptionUtil.preCheckException((String)ResManager.loadKDString((String)"\u8c03\u7528\u7684\u65b9\u4f4d\u540d\u4e3a\u7a7a\u3002", (String)"EBServiceHandlerContainer_1", (String)"ebg-receipt-mservice", (Object[])new Object[0]));
                }
                return EBServiceHandlerContainer.getHandlerEnhance(operationName);
            }
            throw EBExceiptionUtil.preCheckException((String)ResManager.loadKDString((String)"\u8bf7\u6c42\u5934\u5bf9\u8c61\u4e3a\u7a7a\u3002", (String)"EBServiceHandlerContainer_2", (String)"ebg-receipt-mservice", (Object[])new Object[0]));
        }
        throw EBExceiptionUtil.preCheckException((String)ResManager.loadKDString((String)"\u8bf7\u6c42\u5bf9\u8c61\u4e3a\u7a7a\u3002", (String)"EBServiceHandlerContainer_3", (String)"ebg-receipt-mservice", (Object[])new Object[0]));
    }
}

