/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.receipt.mservice.boot.handler;

import com.alibaba.fastjson.JSON;
import com.google.common.base.Preconditions;
import com.google.common.util.concurrent.RateLimiter;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.regex.Pattern;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.db.tx.TX;
import kd.bos.util.StringUtils;
import kd.ebg.egf.common.context.EBContext;
import kd.ebg.egf.common.entity.base.EBException;
import kd.ebg.egf.common.entity.base.EBHeader;
import kd.ebg.egf.common.entity.base.EBRequest;
import kd.ebg.egf.common.entity.base.EBResponse;
import kd.ebg.egf.common.exception.EBPreCheckException;
import kd.ebg.egf.common.framework.biz.EBServiceMethod;
import kd.ebg.egf.common.framework.frame.Sequence;
import kd.ebg.egf.common.license.EbgLicenseUtil;
import kd.ebg.egf.common.model.bank.BankAcnt;
import kd.ebg.egf.common.repository.acnt.BankAcntRepository;
import kd.ebg.egf.common.repository.bank.login.BankLoginRepository;
import kd.ebg.egf.common.utils.JsonUtil;
import kd.ebg.egf.common.utils.string.StrUtil;
import kd.ebg.receipt.common.entity.biz.receipt.QueryReceiptResponse;
import kd.ebg.receipt.common.entity.biz.reconciliation.query.QueryBalanceReconciliationResponse;
import kd.ebg.receipt.common.framework.frame.EBGLogger;
import kd.ebg.receipt.common.framework.log.MDCUtil;
import kd.ebg.receipt.common.framework.properties.SystemPropertyConfig;
import kd.ebg.receipt.common.utils.ReflectUtil;
import kd.ebg.receipt.mservice.boot.handler.filter.IdentificationCodeHandler;
import net.sf.json.JSONObject;
import org.slf4j.MDC;

public class EBServiceHandlerEnhance<REQ extends EBRequest, RSP extends EBResponse> {
    private static final EBGLogger log = EBGLogger.getInstance().getLogger(EBServiceHandlerEnhance.class);
    private static final String REQUEST_SEQ_ID_KEY = "requestSeqID";
    private static final String BIZ_NAME_KEY = "bizName";
    private static final String BIZ_SEQ_KEY = "bizSeqID";
    private static final String CUSTOMER_ID = "customerID";
    private static final String BANK_VERSION_ID = "bankVersionID";
    private static final String TYPE = "type";
    private BankAcntRepository bankAcntRepository;
    private BankLoginRepository bankLoginRepository;
    private static final List<String> NOT_CHECK_ACCNO_BIZTYPE_LIST = Arrays.asList("listBankLogin", "syncAccount", "register", "apply");
    private static final RateLimiter globalRateLimiter = RateLimiter.create((double)200.0);
    private static final long maxWaitTime = 30L;
    private static final AtomicInteger rateLimiterRejectCount = new AtomicInteger(0);
    private static final ConcurrentHashMap<String, RateLimiter> customRateLimiter = new ConcurrentHashMap();
    private final Class<REQ> requestClass;
    private final Class<RSP> responseClass;
    private final String method;
    private final EBServiceMethod<REQ, RSP> serviceMethod;

    public EBServiceHandlerEnhance(String method, EBServiceMethod<REQ, RSP> serviceMethod, Class<REQ> requestClass, Class<RSP> responseClass) {
        Preconditions.checkArgument((boolean)StrUtil.isNotBlank((CharSequence)method), (Object)ResManager.loadKDString((String)"method \u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"EBServiceHandlerEnhance_0", (String)"ebg-receipt-mservice", (Object[])new Object[0]));
        Preconditions.checkArgument((boolean)Objects.nonNull(serviceMethod), (Object)ResManager.loadKDString((String)"serviceMethod \u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"EBServiceHandlerEnhance_1", (String)"ebg-receipt-mservice", (Object[])new Object[0]));
        Preconditions.checkArgument((boolean)Objects.nonNull(requestClass), (Object)ResManager.loadKDString((String)"\u8bf7\u6c42\u5b9e\u4f53\u7c7b\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"EBServiceHandlerEnhance_2", (String)"ebg-receipt-mservice", (Object[])new Object[0]));
        Preconditions.checkArgument((boolean)Objects.nonNull(responseClass), (Object)ResManager.loadKDString((String)"\u54cd\u5e94\u5b9e\u4f53\u7c7b\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"EBServiceHandlerEnhance_3", (String)"ebg-receipt-mservice", (Object[])new Object[0]));
        this.method = method;
        this.serviceMethod = serviceMethod;
        this.requestClass = requestClass;
        this.responseClass = responseClass;
    }

    public RSP handle(String data, String customId) {
        EBRequest req = (EBRequest)JsonUtil.json2Obj((String)data, this.requestClass);
        req.getHeader().setCustomId(customId);
        req.getHeader().setLogBizSeqID(Sequence.gen18Sequence());
        req.getHeader().setLogRequestSeqID(String.valueOf(req.getHeader().getRequestTime()));
        return this.handle(req);
    }

    private RSP getPreErrorResponse(REQ request, String errorMsg) {
        return this.getPreErrorResponse(request, null, errorMsg);
    }

    private RSP getPreErrorResponse(REQ request, String errorCode, String errorMsg) {
        EBResponse response = (EBResponse)ReflectUtil.newInstance(this.responseClass);
        response.setHeader(request.getHeader());
        EBHeader header = response.getHeader();
        if (Objects.nonNull(header)) {
            header.setResponseTime(System.currentTimeMillis());
        }
        EBException ebException = new EBException();
        ebException.setMessage(errorMsg);
        if (StringUtils.isEmpty((String)errorCode)) {
            ebException.setErrorCode("preException");
        } else {
            ebException.setErrorCode(errorCode);
        }
        ebException.setInnerException("preException");
        response.setException(ebException);
        return (RSP)response;
    }

    private RSP getBizErrorResponse(REQ request, Throwable throwable) {
        EBResponse response = (EBResponse)ReflectUtil.newInstance(this.responseClass);
        response.setHeader(request.getHeader());
        EBHeader header = response.getHeader();
        if (Objects.nonNull(header)) {
            header.setResponseTime(System.currentTimeMillis());
        }
        EBException ebException = new EBException();
        String errorMsg = EBContext.getContext().getExceptionMsg();
        if (StringUtils.isEmpty((String)errorMsg)) {
            String string = errorMsg = Objects.isNull(throwable) ? null : throwable.getMessage();
            if (Objects.nonNull(throwable) && !Objects.isNull(throwable.getCause()) && !throwable.getMessage().contains(throwable.getCause().getMessage())) {
                errorMsg = errorMsg + (Objects.isNull(throwable.getCause()) ? "" : throwable.getCause().getMessage());
            }
        }
        ebException.setMessage(errorMsg);
        ebException.setErrorCode("serviceException");
        ebException.setInnerException("serviceException");
        response.setException(ebException);
        return (RSP)response;
    }

    private synchronized RateLimiter createForCustom(String customId) {
        RateLimiter rateLimiter = customRateLimiter.get(customId);
        if (Objects.isNull(rateLimiter)) {
            rateLimiter = RateLimiter.create((double)100.0);
            customRateLimiter.put(customId, rateLimiter);
        }
        return rateLimiter;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     * Could not resolve type clashes
     */
    public RSP handle(REQ request) {
        block52: {
            block50: {
                block51: {
                    block56: {
                        block48: {
                            block49: {
                                block46: {
                                    block47: {
                                        block44: {
                                            block45: {
                                                block42: {
                                                    block43: {
                                                        block40: {
                                                            block41: {
                                                                block38: {
                                                                    block39: {
                                                                        block36: {
                                                                            block37: {
                                                                                this.bankAcntRepository = BankAcntRepository.getInstance();
                                                                                this.bankLoginRepository = BankLoginRepository.getInstance();
                                                                                currentMs = System.currentTimeMillis();
                                                                                MDC.put((String)"requestSeqID", (String)"");
                                                                                MDC.put((String)"bizSeqID", (String)"");
                                                                                MDC.put((String)"customerID", (String)"");
                                                                                MDC.put((String)"bizName", (String)"");
                                                                                MDC.put((String)"bankVersionID", (String)"");
                                                                                MDC.put((String)"type", (String)"");
                                                                                h = TX.notSupported();
                                                                                tryAcquire = EBServiceHandlerEnhance.globalRateLimiter.tryAcquire(30L, TimeUnit.SECONDS);
                                                                                if (tryAcquire) break block36;
                                                                                EBServiceHandlerEnhance.log.warn("\u89e6\u53d1\u5168\u5c40\u9650\u6d41");
                                                                                EBServiceHandlerEnhance.rateLimiterRejectCount.incrementAndGet();
                                                                                var6_6 = this.getPreErrorResponse(request, ResManager.loadKDString((String)"\u5168\u5c40\u9650\u6d41", (String)"EBServiceHandlerEnhance_4", (String)"ebg-receipt-mservice", (Object[])new Object[0]));
                                                                                if (h == null) break block37;
                                                                                h.close();
                                                                            }
                                                                            cost = System.currentTimeMillis() - currentMs;
                                                                            EBServiceHandlerEnhance.log.info("\u65b9\u6cd5\uff1a{}({})\u6267\u884c\u7ed3\u675f,\u8017\u65f6:{} ms", new Object[]{this.method, request.getHeader().getSubBizType(), cost});
                                                                            return var6_6;
                                                                        }
                                                                        header = request.getHeader();
                                                                        accountNo = header.getAccNo();
                                                                        customId = header.getCustomId();
                                                                        bankVersion = "";
                                                                        bankLogin = header.getBankVersion();
                                                                        if (!StringUtils.isEmpty((String)bankLogin)) {
                                                                            bankLoginInfo = this.bankLoginRepository.findById(bankLogin, customId);
                                                                            bankVersion = bankLoginInfo.getBankVersionId();
                                                                        }
                                                                        if (!StringUtils.isEmpty((String)bankVersion) && EBServiceHandlerEnhance.NOT_CHECK_ACCNO_BIZTYPE_LIST.contains(header.getBizType()) || accountNo == null) break block38;
                                                                        bankAcnt = this.bankAcntRepository.findEnableByAccNo(accountNo);
                                                                        if (bankAcnt != null) {
                                                                            bankVersion = bankAcnt.getBankVersionId();
                                                                            break block38;
                                                                        }
                                                                        var12_15 = this.getPreErrorResponse(request, String.format(ResManager.loadKDString((String)"\u8d26\u53f7[%s]\u4e0d\u5b58\u5728\u3002", (String)"EBServiceHandlerEnhance_17", (String)"ebg-receipt-mservice", (Object[])new Object[0]), new Object[]{accountNo}));
                                                                        if (h == null) break block39;
                                                                        h.close();
                                                                    }
                                                                    cost = System.currentTimeMillis() - currentMs;
                                                                    EBServiceHandlerEnhance.log.info("\u65b9\u6cd5\uff1a{}({})\u6267\u884c\u7ed3\u675f,\u8017\u65f6:{} ms", new Object[]{this.method, request.getHeader().getSubBizType(), cost});
                                                                    return var12_15;
                                                                }
                                                                rateLimiter = EBServiceHandlerEnhance.customRateLimiter.get(customId);
                                                                if (Objects.isNull(rateLimiter)) {
                                                                    rateLimiter = this.createForCustom(customId);
                                                                }
                                                                if (rateLimiter.tryAcquire(30L, TimeUnit.SECONDS)) break block40;
                                                                EBServiceHandlerEnhance.log.warn("\u79df\u6237:{} \u89e6\u53d1\u9650\u6d41", new Object[]{customId});
                                                                var12_16 = this.getPreErrorResponse(request, ResManager.loadKDString((String)"\u5355\u79df\u6237\u9650\u6d41", (String)"EBServiceHandlerEnhance_7", (String)"ebg-receipt-mservice", (Object[])new Object[0]));
                                                                if (h == null) break block41;
                                                                h.close();
                                                            }
                                                            cost = System.currentTimeMillis() - currentMs;
                                                            EBServiceHandlerEnhance.log.info("\u65b9\u6cd5\uff1a{}({})\u6267\u884c\u7ed3\u675f,\u8017\u65f6:{} ms", new Object[]{this.method, request.getHeader().getSubBizType(), cost});
                                                            return var12_16;
                                                        }
                                                        logBizSeqID = request.getHeader().getLogBizSeqID();
                                                        if (StringUtils.isEmpty((String)logBizSeqID)) {
                                                            logBizSeqID = Sequence.gen18Sequence();
                                                        }
                                                        if (StringUtils.isEmpty((String)header.getLogRequestSeqID())) {
                                                            header.setLogRequestSeqID(String.valueOf(header.getRequestTime()));
                                                        }
                                                        extDate = request.getHeader().getExtData();
                                                        loggerBatchNo = "";
                                                        loggerDetailNo = "";
                                                        loggerBankNo = "";
                                                        try {
                                                            if (extDate != null) {
                                                                object = JSONObject.fromObject((Object)extDate);
                                                                loggerBatchNo = (String)object.get("loggerBatchNo");
                                                                loggerDetailNo = (String)object.get("loggerDetailNo");
                                                                loggerBankNo = (String)object.get("loggerBankNo");
                                                            }
                                                        }
                                                        catch (Exception e) {
                                                            EBServiceHandlerEnhance.log.error("\u89e3\u6790\u65e5\u5fd7\u8ddf\u8e2a\u53f7\u5f02\u5e38", (Throwable)e);
                                                        }
                                                        context = EBContext.builder().createTime(System.currentTimeMillis()).customID(customId).logRequestSeqID(header.getLogRequestSeqID()).bizName(header.getBizType()).subBizName(header.getSubBizType()).bankVersionID(bankVersion).logBizSeqID(logBizSeqID).bizSeqID(Sequence.gen18Sequence()).requestSeqID(Sequence.genSequence()).loggerBatchNo(loggerBatchNo).loggerDetailNo(loggerDetailNo).loggerBankNo(loggerBankNo).build();
                                                        if (Objects.equals(header.getBizType(), "receiptPage") || Objects.equals(header.getBizType(), "receipt")) {
                                                            context.setBizName("queryReceipt");
                                                        }
                                                        if (Objects.equals(header.getBizType(), "balanceReconciliationQuery") || Objects.equals(header.getBizType(), "balanceReconciliationQueryPage")) {
                                                            context.setBizName("balanceReconciliationQuery");
                                                        }
                                                        if (Objects.equals(header.getBizType(), "balanceReconciliate")) {
                                                            context.setBizName("balanceReconciliation");
                                                        }
                                                        MDCUtil.clearBankMDC();
                                                        MDCUtil.initMDC((EBContext)context);
                                                        MDC.put((String)"bussiness_type", (String)"bussiness_process");
                                                        MDC.put((String)"requestSeqID", (String)context.getRequestSeqID());
                                                        MDC.put((String)"bizSeqID", (String)context.getBizSeqID());
                                                        MDC.put((String)"customerID", (String)context.getCustomID());
                                                        MDC.put((String)"bizName", (String)context.getBizName());
                                                        MDC.put((String)"bankVersionID", (String)context.getBankVersionID());
                                                        if ("ping".equalsIgnoreCase(header.getBizType()) && !StringUtils.isEmpty((String)header.getExtData())) {
                                                            obj = JSON.parseObject((String)header.getExtData());
                                                            bankVersion = obj.getString("bankVersionID");
                                                            bankLogin = obj.getString("bankLoginID");
                                                            context.setBankLoginID(bankLogin);
                                                            context.setBankVersionID(bankVersion);
                                                        }
                                                        EBContext.setContext((EBContext)context);
                                                        ipErrorMessage = this.checkIp();
                                                        if (!StrUtil.isNotBlank((CharSequence)ipErrorMessage)) break block42;
                                                        var19_27 = this.getPreErrorResponse(request, ipErrorMessage);
                                                        if (h == null) break block43;
                                                        h.close();
                                                    }
                                                    cost = System.currentTimeMillis() - currentMs;
                                                    EBServiceHandlerEnhance.log.info("\u65b9\u6cd5\uff1a{}({})\u6267\u884c\u7ed3\u675f,\u8017\u65f6:{} ms", new Object[]{this.method, request.getHeader().getSubBizType(), cost});
                                                    return var19_27;
                                                }
                                                if (!SystemPropertyConfig.isDatacenterCheckOpen()) break block44;
                                                identificationCode /* !! */  = header.getIdentificationCode();
                                                identificationCodeHandler = IdentificationCodeHandler.build();
                                                if (identificationCodeHandler.handleIdentificationCode(customId, header.getClientName(), header.getClientVersion(), identificationCode /* !! */ )) break block44;
                                                var21_32 = this.getPreErrorResponse(request, ResManager.loadKDString((String)"\u5ba2\u6237\u8ba4\u8bc1\u6807\u8bc6\u7801\u8ba4\u8bc1\u5931\u8d25\uff0c\u8bf7\u786e\u4fdd\u6570\u636e\u4e2d\u5fc3\u914d\u7f6e\u6b63\u786e\uff0c\u4e0b\u4e00\u4ee3\u9700\u8981\u914d\u7f6e\u8d26\u5957ID\u3002", (String)"EBServiceHandlerEnhance_8", (String)"ebg-receipt-mservice", (Object[])new Object[0]));
                                                if (h == null) break block45;
                                                h.close();
                                            }
                                            cost = System.currentTimeMillis() - currentMs;
                                            EBServiceHandlerEnhance.log.info("\u65b9\u6cd5\uff1a{}({})\u6267\u884c\u7ed3\u675f,\u8017\u65f6:{} ms", new Object[]{this.method, request.getHeader().getSubBizType(), cost});
                                            return var21_32;
                                        }
                                        if (!"detail".equalsIgnoreCase(this.method) || this.checkQueryDetail(accountNo)) break block46;
                                        identificationCode /* !! */  = this.getPreErrorResponse(request, String.format(ResManager.loadKDString((String)"\u5f53\u524d\u8d26\u53f7\uff1a%s\uff0c\u4e0d\u5141\u8bb8\u67e5\u8be2\u4ea4\u6613\u660e\u7ec6\u3002", (String)"EBServiceHandlerEnhance_23", (String)"ebg-receipt-mservice", (Object[])new Object[0]), new Object[]{accountNo}));
                                        if (h == null) break block47;
                                        h.close();
                                    }
                                    cost = System.currentTimeMillis() - currentMs;
                                    EBServiceHandlerEnhance.log.info("\u65b9\u6cd5\uff1a{}({})\u6267\u884c\u7ed3\u675f,\u8017\u65f6:{} ms", new Object[]{this.method, request.getHeader().getSubBizType(), cost});
                                    return (RSP)identificationCode /* !! */ ;
                                }
                                EBServiceHandlerEnhance.log.info("\u8c03\u7528\u4e86 {} \u65b9\u6cd5", (Object)this.method);
                                headerCurrency = request.getHeader().getCurrency();
                                if (!this.serviceMethod.needCheckAccNo()) ** GOTO lbl164
                                accNo = header.getAccNo();
                                if (!StringUtils.isEmpty((String)bankLogin)) ** GOTO lbl157
                                acnt = this.bankAcntRepository.findByAccNoAndCustomID(accNo, customId);
                                if (null != acnt) break block48;
                                cost = this.getPreErrorResponse(request, String.format(ResManager.loadKDString((String)"\u4f7f\u7528\u4e86\u94f6\u4f01\u4e91\u4e2d\u672a\u7ef4\u62a4\u7684\u8d26\u53f7:%s\u3002", (String)"EBServiceHandlerEnhance_19", (String)"ebg-receipt-mservice", (Object[])new Object[0]), new Object[]{accNo}));
                                if (h == null) break block49;
                                h.close();
                            }
                            cost = System.currentTimeMillis() - currentMs;
                            EBServiceHandlerEnhance.log.info("\u65b9\u6cd5\uff1a{}({})\u6267\u884c\u7ed3\u675f,\u8017\u65f6:{} ms", new Object[]{this.method, request.getHeader().getSubBizType(), cost});
                            return cost;
                        }
                        EBServiceHandlerEnhance.log.info("\u94f6\u4f01\u5e73\u53f0\u4e2d\u6709\u8fd9\u4e2a\u8d26\u53f7: " + acnt.getAccNo());
                        context.setBankAcnt(acnt);
                        context.setBankLoginID(acnt.getBankLoginId());
                        context.setBankVersionID(acnt.getBankVersionId());
                        break block56;
lbl157:
                        // 1 sources

                        context.setBankLoginID(bankLogin);
                        context.setBankVersionID(bankVersion);
                    }
                    MDCUtil.initMDC((EBContext)context);
                    if ("receiptPage".equalsIgnoreCase(header.getBizType()) || "receipt".equalsIgnoreCase(header.getBizType()) || "receiptDownload".equalsIgnoreCase(header.getBizType()) || "queryReceipt".equalsIgnoreCase(header.getBizType()) || "balanceReconciliationQuery".equalsIgnoreCase(header.getBizType()) || "balanceReconciliationQueryPage".equalsIgnoreCase(header.getBizType()) || "balanceReconciliate".equalsIgnoreCase(header.getBizType())) {
                        EBServiceHandlerEnhance.log.infoIndex("\u5f00\u59cb\u8fdb\u884c\u4e1a\u52a1\u5904\u7406,{}", (Object)header.getBizType());
                    }
lbl164:
                    // 5 sources

                    EBServiceHandlerEnhance.log.info("\u5f00\u59cb\u6267\u884c\u8bf7\u6c42");
                    response = this.serviceMethod.executeClientRequest(request, context);
                    EBServiceHandlerEnhance.log.info("\u6267\u884c\u8bf7\u6c42\u5b8c\u6210");
                    response.setHeader(header);
                    header.setResponseTime(System.currentTimeMillis());
                    isNeedValid = true;
                    isHasReceipt = false;
                    isEmptyResult = false;
                    hasReceiptAccountList = this.bankAcntRepository.findByBankVersionIdAndBankLoginIdAndHasReceipt(context.getBankVersionID(), context.getBankLoginID(), true);
                    for (BankAcnt bankAcnt : hasReceiptAccountList) {
                        if (!Objects.equals(bankAcnt /* !! */ .getAccNo(), accountNo)) continue;
                        isHasReceipt = true;
                    }
                    if (response instanceof QueryReceiptResponse) {
                        receiptResponse = (QueryReceiptResponse)response;
                        isEmptyResult = receiptResponse.getBody().getDetails().isEmpty();
                    }
                    if (response instanceof QueryBalanceReconciliationResponse) {
                        receiptResponse = (QueryBalanceReconciliationResponse)response;
                        isEmptyResult = receiptResponse.getBody().getReceiptInfos().isEmpty();
                    }
                    if (!isHasReceipt || isEmptyResult) {
                        isNeedValid = false;
                    }
                    if (!isNeedValid || !StrUtil.isNotBlank((CharSequence)(errorMessage = EbgLicenseUtil.checkLicenseValid((String)customId, (String)header.getBizType(), (String)context.getBankLoginID())))) break block50;
                    bankAcnt /* !! */  = this.getPreErrorResponse(request, errorMessage);
                    if (h == null) break block51;
                    h.close();
                }
                cost = System.currentTimeMillis() - currentMs;
                EBServiceHandlerEnhance.log.info("\u65b9\u6cd5\uff1a{}({})\u6267\u884c\u7ed3\u675f,\u8017\u65f6:{} ms", new Object[]{this.method, request.getHeader().getSubBizType(), cost});
                return (RSP)bankAcnt /* !! */ ;
            }
            var25_48 = response;
            if (h == null) break block52;
            h.close();
        }
        cost = System.currentTimeMillis() - currentMs;
        EBServiceHandlerEnhance.log.info("\u65b9\u6cd5\uff1a{}({})\u6267\u884c\u7ed3\u675f,\u8017\u65f6:{} ms", new Object[]{this.method, request.getHeader().getSubBizType(), cost});
        return (RSP)var25_48;
        {
            catch (IllegalArgumentException | EBPreCheckException preCheckException) {
                block53: {
                    EBServiceHandlerEnhance.log.warn("\u524d\u7f6e\u68c0\u67e5\u5f02\u5e38:", new Object[]{preCheckException});
                    errorCode = null;
                    if (preCheckException instanceof EBPreCheckException) {
                        errorCode = ((EBPreCheckException)preCheckException).getErrorCode();
                    }
                    isEmptyResult = this.getPreErrorResponse(request, errorCode, preCheckException.getMessage());
                    if (h == null) break block53;
                    h.close();
                }
                cost = System.currentTimeMillis() - currentMs;
                EBServiceHandlerEnhance.log.info("\u65b9\u6cd5\uff1a{}({})\u6267\u884c\u7ed3\u675f,\u8017\u65f6:{} ms", new Object[]{this.method, request.getHeader().getSubBizType(), cost});
                return isEmptyResult;
            }
            catch (Throwable t) {
                block54: {
                    EBServiceHandlerEnhance.log.error("\u94f6\u4f01\u4e2d\u95f4\u4ef6\u629b\u5411\u4e1a\u52a1\u7cfb\u7edf\u7684\u5f02\u5e38:", t);
                    var22_41 = this.getBizErrorResponse(request, t);
                    if (h == null) break block54;
                    h.close();
                }
                cost = System.currentTimeMillis() - currentMs;
                EBServiceHandlerEnhance.log.info("\u65b9\u6cd5\uff1a{}({})\u6267\u884c\u7ed3\u675f,\u8017\u65f6:{} ms", new Object[]{this.method, request.getHeader().getSubBizType(), cost});
                return var22_41;
                {
                    catch (Throwable e) {
                        block55: {
                            try {
                                h.markRollback();
                                EBServiceHandlerEnhance.log.error("handle\u5904\u7406\u53d1\u751f\u5f02\u5e38", e);
                                var6_7 = this.getPreErrorResponse(request, "", e.getMessage());
                                if (h == null) break block55;
                            }
                            catch (Throwable var29_52) {
                                if (h != null) {
                                    h.close();
                                }
                                cost = System.currentTimeMillis() - currentMs;
                                EBServiceHandlerEnhance.log.info("\u65b9\u6cd5\uff1a{}({})\u6267\u884c\u7ed3\u675f,\u8017\u65f6:{} ms", new Object[]{this.method, request.getHeader().getSubBizType(), cost});
                                throw var29_52;
                            }
                            h.close();
                        }
                        cost = System.currentTimeMillis() - currentMs;
                        EBServiceHandlerEnhance.log.info("\u65b9\u6cd5\uff1a{}({})\u6267\u884c\u7ed3\u675f,\u8017\u65f6:{} ms", new Object[]{this.method, request.getHeader().getSubBizType(), cost});
                        return var6_7;
                    }
                }
            }
        }
    }

    private String checkDatacenter(String name) {
        if (SystemPropertyConfig.isDatacenterCheckOpen()) {
            List datacenterList = SystemPropertyConfig.getDatacenterList();
            if (Objects.nonNull(datacenterList) && !datacenterList.isEmpty()) {
                for (String datacenter : datacenterList) {
                    if (!StrUtil.equals((String)datacenter, (String)name)) continue;
                    return null;
                }
            }
            return String.format(ResManager.loadKDString((String)"\u4e0d\u5141\u8bb8\u63a5\u5165\u7684\u6570\u636e\u4e2d\u5fc3:%s\u3002", (String)"EBServiceHandlerEnhance_20", (String)"ebg-receipt-mservice", (Object[])new Object[0]), name);
        }
        return null;
    }

    private boolean checkQueryDetail(String accNo) {
        List queryDetailAcntList = SystemPropertyConfig.getQueryDetailList();
        if (queryDetailAcntList != null && queryDetailAcntList.size() > 0) {
            return queryDetailAcntList.contains(accNo);
        }
        return true;
    }

    private String checkIp() {
        String ipAddr = RequestContext.get().getLoginIP();
        if (StringUtils.isEmpty((String)ipAddr)) {
            return null;
        }
        log.info("\u8bf7\u6c42\u7684ip\u4e3a :{}", (Object)ipAddr);
        boolean matchingMode = SystemPropertyConfig.isMatchingMode();
        List configIpList = SystemPropertyConfig.getConfigIpList();
        if (StrUtil.isBlank((CharSequence)ipAddr)) {
            return null;
        }
        boolean ipMatch = this.hasMatchConfig(configIpList, ipAddr);
        if (configIpList.isEmpty()) {
            return null;
        }
        if (matchingMode) {
            if (!ipMatch) {
                return String.format(ResManager.loadKDString((String)"%s \u4e0d\u5728\u767d\u540d\u5355\u4e2d\u3002", (String)"EBServiceHandlerEnhance_21", (String)"ebg-receipt-mservice", (Object[])new Object[]{ipAddr}), new Object[0]);
            }
        } else if (ipMatch) {
            return String.format(ResManager.loadKDString((String)"%s \u5728\u9ed1\u540d\u5355\u4e2d\u3002", (String)"EBServiceHandlerEnhance_22", (String)"ebg-receipt-mservice", (Object[])new Object[0]), ipAddr);
        }
        return null;
    }

    private boolean hasMatchConfig(List<String> configIpList, String ipAddr) {
        for (String allowdIp : configIpList) {
            if (!StrUtil.isNotBlank((CharSequence)(allowdIp = StrUtil.trim((CharSequence)allowdIp)))) continue;
            boolean contains = ipAddr.contains(allowdIp);
            if (contains) {
                return true;
            }
            if (allowdIp.contains("*")) {
                Pattern pattern = Pattern.compile(allowdIp);
                boolean matches = pattern.matcher(ipAddr).matches();
                if (!matches) continue;
                return true;
            }
            if (allowdIp.contains("-")) {
                List allowdIpSplit = StrUtil.split((String)allowdIp, (char)'.');
                List ipAddrSplit = StrUtil.split((String)ipAddr, (char)'.');
                if (Objects.nonNull(allowdIp) && Objects.nonNull(ipAddr) && !allowdIpSplit.isEmpty() && !ipAddrSplit.isEmpty() && allowdIpSplit.size() == ipAddrSplit.size()) {
                    for (int i = 0; i < allowdIpSplit.size(); ++i) {
                        String ipSplit;
                        String configSplit = (String)allowdIpSplit.get(i);
                        if (configSplit.equals(ipSplit = (String)ipAddrSplit.get(i))) continue;
                        if (configSplit.contains("-")) {
                            List ipRanges = StrUtil.split((String)configSplit, (char)'-');
                            if (ipRanges.size() != 2) {
                                return false;
                            }
                            int start = Integer.parseInt(StrUtil.trim((CharSequence)((CharSequence)ipRanges.get(0))));
                            int end = Integer.parseInt(StrUtil.trim((CharSequence)((CharSequence)ipRanges.get(1))));
                            int real = Integer.parseInt(ipSplit);
                            return real >= start && real <= end;
                        }
                        return false;
                    }
                    return true;
                }
                return false;
            }
            if (!allowdIp.equalsIgnoreCase(ipAddr)) continue;
            return true;
        }
        return false;
    }
}

