/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.receipt.banks.hxb.dc.service.receipt;

import java.time.LocalDate;
import java.util.Objects;
import kd.ebg.egf.common.utils.LocalDateUtil;
import kd.ebg.receipt.common.framework.frame.EBGLogger;
import kd.ebg.receipt.common.framework.receipt.parse.impl.AbstractFileParser;

public class HxbDcFileParser
extends AbstractFileParser {
    private static EBGLogger logger = EBGLogger.getInstance().getLogger(HxbDcFileParser.class);

    public String getAccNo() {
        return this.getParsedString(0);
    }

    public LocalDate getDate() {
        return LocalDateUtil.parserDate((String)this.getParsedString(1));
    }

    public String getReceiptNo() {
        String receiptNo = this.getParsedString(6);
        return HxbDcFileParser.removeLeadingZeros(receiptNo);
    }

    public String getOppAccNo() {
        return this.getParsedString(2);
    }

    public String getAmount() {
        return this.getParsedString(3);
    }

    public String getCdFlag() {
        String cdFlag = this.getParsedString(4);
        if (Objects.equals(cdFlag, "0")) {
            cdFlag = "2";
        }
        return cdFlag;
    }

    public String getFileSplit() {
        return "-";
    }

    public String getBankVersion() {
        return "HXB_DC";
    }

    public static String removeLeadingZeros(String str) {
        int i;
        if (str == null || str.isEmpty()) {
            return str;
        }
        for (i = 0; i < str.length() && str.charAt(i) == '0'; ++i) {
        }
        return str.substring(i);
    }
}

