/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.receipt.banks.hxb.dc.service.receipt;

import com.alibaba.fastjson.JSONObject;
import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Objects;
import kd.bos.dataentity.resource.ResManager;
import kd.ebg.egf.common.cache.CosmicConstants;
import kd.ebg.egf.common.exception.EBServiceException;
import kd.ebg.receipt.banks.hxb.dc.service.receipt.HxbDcCommConfig;
import kd.ebg.receipt.banks.hxb.dc.service.receipt.ResponseStrUtil;
import kd.ebg.receipt.business.receipt.bank.ReceiptInfo;
import kd.ebg.receipt.business.receipt.bank.ReceiptRequest;
import kd.ebg.receipt.business.receipt.bank.ReceiptResponseEB;
import kd.ebg.receipt.common.core.utils.EBGStringUtils;
import kd.ebg.receipt.common.framework.frame.EBGLogger;
import kd.ebg.receipt.common.framework.match.MatchRule;
import kd.ebg.receipt.common.framework.receipt.util.EBConfigBuilder;

public class ReceiptParser {
    private static final String SEPARATOR = "#";
    private static final String CIRCLE_STR = "|";
    private static EBGLogger logger = EBGLogger.getInstance().getLogger(ReceiptParser.class);

    public static ReceiptResponseEB parse(ReceiptRequest request, String responseStr) {
        logger.info("{}-{}-{}-\u534e\u590f\u94f6\u884c\u56de\u5355\u67e5\u8be2\u63a5\u53e3\u8fd4\u56de\u62a5\u6587\uff1a{}", new Object[]{request.getHeader().getAcnt().getAccNo(), request.getStartDate(), request.getEndDate(), responseStr});
        responseStr = ResponseStrUtil.process(responseStr);
        ReceiptResponseEB responseEB = new ReceiptResponseEB();
        responseEB.setCompleteFlag(0);
        ArrayList<ReceiptInfo> receiptInfos = new ArrayList<ReceiptInfo>(16);
        String[] elements = EBGStringUtils.split((String)responseStr, (String)SEPARATOR);
        if (elements == null || elements.length < 1) {
            throw new EBServiceException(ResManager.loadKDString((String)"\u94f6\u884c\u8fd4\u56de\u62a5\u6587\u4e3a\u7a7a\u3002", (String)"ReceiptParser_0", (String)"ebg-receipt-banks-hxb-dc", (Object[])new Object[0]));
        }
        String responseCode = elements[0];
        if ("EL4418".equals(responseCode)) {
            responseEB.setCompleteFlag(1);
            responseEB.setReceiptInfos(receiptInfos);
            return responseEB;
        }
        if (!"000000".equals(responseCode)) {
            String errorMsg = String.format(ResManager.loadKDString((String)"\u4e0b\u8f7d\u7535\u5b50\u56de\u5355\u5931\u8d25\uff0c\u5931\u8d25\u54cd\u5e94\u7801\uff1a%s\u3002", (String)"ReceiptParser_4", (String)"ebg-receipt-banks-hxb-dc", (Object[])new Object[0]), responseCode);
            throw new EBServiceException(errorMsg);
        }
        String bankLoginId = request.getHeader().getBankLoginID();
        HxbDcCommConfig bankLoginReceiptProperties = (HxbDcCommConfig)EBConfigBuilder.getInstance().buildConfig(HxbDcCommConfig.class, bankLoginId);
        boolean isUseNewRule = Objects.equals(bankLoginReceiptProperties.getIsUseNewRule(), "true");
        HashMap countMap = Maps.newHashMapWithExpectedSize((int)1);
        elements = responseStr.split(SEPARATOR, 3);
        String[] fourthElements = EBGStringUtils.split((String)elements[2], (String)"|#");
        String[] newElements = new String[2 + fourthElements.length];
        System.arraycopy(elements, 0, newElements, 0, 2);
        System.arraycopy(fourthElements, 0, newElements, 2, fourthElements.length);
        int total = Integer.parseInt(newElements[1]);
        if (total < 1) {
            throw new EBServiceException(ResManager.loadKDString((String)"\u94f6\u884c\u8fd4\u56de\u62a5\u6587\u660e\u7ec6\u4e3a\u7a7a\u3002", (String)"ReceiptParser_2", (String)"ebg-receipt-banks-hxb-dc", (Object[])new Object[0]));
        }
        int elemtIndex = 2;
        for (int i = 0; i < total; ++i) {
            String[] details = EBGStringUtils.split((String)newElements[elemtIndex++], (String)CIRCLE_STR);
            String payerAcntName = details[0];
            String payerAcntNo = details[1];
            String payerBankName = details[2];
            String Amount = details[3];
            String useCn = details[4];
            String payeeAcntName = details[5];
            String payeeAcntNo = details[6];
            String payeeBankName = details[7];
            String ebillKey = details[8];
            String transDate = details[9];
            String transDateString = transDate.replace("-", "");
            int tranSerialNo = Integer.parseInt(details[10]);
            String creditDebitFlag = details[11];
            ReceiptInfo rInfo = new ReceiptInfo();
            rInfo.setFileFlag("0");
            rInfo.setTranSerialNo(tranSerialNo + "");
            String otherAcc = null;
            rInfo.setAccNo(payerAcntNo);
            rInfo.setAccName(payerAcntName);
            rInfo.setBankName(payerBankName);
            rInfo.setOppAccNo(payeeAcntNo);
            rInfo.setOppAccName(payeeAcntName);
            rInfo.setOppBankName(payeeBankName);
            if (request.getAccNo().equals(payerAcntNo)) {
                rInfo.setDebitAmount(Amount);
                rInfo.setCreditAmount("0");
            } else {
                rInfo.setDebitAmount("0");
                rInfo.setCreditAmount(Amount);
            }
            otherAcc = "1".equals(creditDebitFlag) ? payeeAcntNo : payerAcntNo;
            if (useCn.startsWith("KD") && useCn.length() >= 10) {
                useCn = useCn.substring(10);
            }
            if (isUseNewRule) {
                JSONObject jsonObject = new JSONObject();
                jsonObject.put(CosmicConstants.DEFAULT_MATCH_RULE_PARAM_KEY_ARRAY[0], (Object)request.getAccNo());
                jsonObject.put(CosmicConstants.DEFAULT_MATCH_RULE_PARAM_KEY_ARRAY[1], (Object)otherAcc);
                jsonObject.put(CosmicConstants.DEFAULT_MATCH_RULE_PARAM_KEY_ARRAY[2], (Object)transDateString);
                jsonObject.put(CosmicConstants.DEFAULT_MATCH_RULE_PARAM_KEY_ARRAY[3], (Object)Amount);
                jsonObject.put(CosmicConstants.DEFAULT_MATCH_RULE_PARAM_KEY_ARRAY[4], (Object)creditDebitFlag);
                jsonObject.put(CosmicConstants.DEFAULT_MATCH_RULE_PARAM_KEY_ARRAY[5], (Object)Integer.toString(tranSerialNo));
                String jsonStr = jsonObject.toJSONString();
                String receiptNo = MatchRule.getInstance().getReceiptMatchNo(request.getAccNo(), transDateString, jsonStr);
                if (countMap.containsKey(receiptNo)) {
                    int count = (Integer)countMap.get(receiptNo) + 1;
                    countMap.put(receiptNo, count);
                    receiptNo = receiptNo + "-" + String.format("%04d", count);
                } else {
                    countMap.put(receiptNo, 0);
                }
                rInfo.setJson(jsonStr);
                rInfo.setReceiptNo(receiptNo);
            } else {
                String detailNo = transDateString + tranSerialNo + creditDebitFlag + Amount + otherAcc;
                rInfo.setReceiptNo(detailNo);
                rInfo.setJson(detailNo);
            }
            rInfo.setAmount(Amount);
            rInfo.setUseCn(useCn);
            rInfo.setEbillKey(ebillKey);
            rInfo.setTransDate(transDateString);
            rInfo.setValidateCode(ebillKey);
            receiptInfos.add(rInfo);
        }
        responseEB.setCompleteFlag(1);
        responseEB.setReceiptInfos(receiptInfos);
        return responseEB;
    }
}

