/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.receipt.banks.bcs.cmp.service.receipt;

import java.io.InputStream;
import java.util.HashMap;
import java.util.List;
import kd.bos.dataentity.resource.ResManager;
import kd.ebg.egf.common.context.RequestContextUtils;
import kd.ebg.egf.common.exception.EBExceiptionUtil;
import kd.ebg.egf.common.framework.bank.info.BankResponse;
import kd.ebg.egf.common.utils.Sequence;
import kd.ebg.egf.common.utils.xml.JDomUtils;
import kd.ebg.receipt.banks.bcs.cmp.service.utils.Constant;
import kd.ebg.receipt.banks.bcs.cmp.service.utils.Packer;
import kd.ebg.receipt.banks.bcs.cmp.service.utils.Parser;
import kd.ebg.receipt.business.receipt.atom.AbstractBankReceiptImpl;
import kd.ebg.receipt.business.receipt.atom.IBankReceipt;
import kd.ebg.receipt.business.receipt.bank.frontProxy.BankReceiptRequest;
import kd.ebg.receipt.business.receipt.bank.frontProxy.BankReceiptResponseEB;
import org.jdom2.Element;

public class HisReceiptDownloadImpl
extends AbstractBankReceiptImpl
implements IBankReceipt {
    public String getDeveloper() {
        return "";
    }

    public String getBizCode() {
        return "0000304T012D0009";
    }

    public String getBizDesc() {
        return ResManager.loadKDString((String)"\u7535\u5b50\u56de\u5355\u4e0b\u8f7d", (String)"HisReceiptDownloadImpl_0", (String)"ebg-receipt-banks-bcs-cmp", (Object[])new Object[0]);
    }

    public String pack(BankReceiptRequest bankReceiptRequest) {
        String transDate = bankReceiptRequest.getTransDate().format(Constant.dateFormat);
        Element root = Packer.buildHead(this.getBizCode(), Sequence.genSequence());
        Element body = JDomUtils.getChildElement((Element)root, (String)"body");
        JDomUtils.addChild((Element)body, (String)"paperPageSize", (String)"1");
        Element infoList = JDomUtils.addChild((Element)body, (String)"infoList");
        JDomUtils.addChild((Element)infoList, (String)"innerNo", (String)bankReceiptRequest.getRequestStr());
        JDomUtils.addChild((Element)infoList, (String)"sj", (String)String.format("%s-%s", transDate, transDate));
        String xmlStr = JDomUtils.root2StringWithoutXMLDeclaration((Element)root, (String)RequestContextUtils.getCharset());
        return Packer.buildCommonMsg(xmlStr);
    }

    public BankReceiptResponseEB parse(BankReceiptRequest bankReceiptRequest, String s) {
        Element root = JDomUtils.string2Root((String)s, (String)RequestContextUtils.getCharset());
        BankResponse bankResponse = Parser.parser(root);
        if ("0_0000".equals(bankResponse.getResponseCode())) {
            Element body = root.getChild("body");
            List dtoList = body.getChild("array").getChildren("dto");
            Element dto = (Element)dtoList.get(0);
            if (dto == null) {
                throw EBExceiptionUtil.serviceException((String)String.format(ResManager.loadKDString((String)"\u4e0d\u5b58\u5728\u56de\u5355\u5217\u8868\u4fe1\u606f :%s\u3002", (String)"HisReceiptDownloadImpl_1", (String)"ebg-receipt-banks-bcs-cmp", (Object[])new Object[0]), bankResponse.getResponseMessage()));
            }
            String lsh = dto.getChildTextTrim("lsh");
            String fileName = body.getChildTextTrim("file_name");
            HashMap<String, String> resp = new HashMap<String, String>(2);
            resp.put("lsh", lsh);
            resp.put("filename", fileName);
            return BankReceiptResponseEB.success(resp);
        }
        throw EBExceiptionUtil.serviceException((String)String.format(ResManager.loadKDString((String)"\u83b7\u53d6\u56de\u5355\u4e0b\u8f7d\u5931\u8d25 :%s", (String)"HisReceiptDownloadImpl_2", (String)"ebg-receipt-banks-bcs-cmp", (Object[])new Object[0]), bankResponse.getResponseMessage()));
    }

    public String recv(InputStream inputStream) {
        return Parser.parseRecvMsg(super.recv(inputStream));
    }
}

