/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.receipt.banks.gzc.dc.services.receipt.api;

import com.alibaba.fastjson.JSONObject;
import java.io.File;
import java.time.LocalDate;
import kd.bos.dataentity.resource.ResManager;
import kd.ebg.egf.common.context.EBContext;
import kd.ebg.egf.common.exception.EBExceiptionUtil;
import kd.ebg.egf.common.framework.communication.ConnectionFactory;
import kd.ebg.egf.common.utils.LocalDateUtil;
import kd.ebg.egf.common.utils.xml.JDomUtils;
import kd.ebg.receipt.banks.gzc.dc.constants.Constants;
import kd.ebg.receipt.banks.gzc.dc.services.detail.GZC_DC_Packer;
import kd.ebg.receipt.business.receipt.atom.AbstractBankReceiptImpl;
import kd.ebg.receipt.business.receipt.atom.IBankReceipt;
import kd.ebg.receipt.business.receipt.bank.frontProxy.BankReceiptRequest;
import kd.ebg.receipt.business.receipt.bank.frontProxy.BankReceiptResponseEB;
import kd.ebg.receipt.common.framework.context.RequestContextUtils;
import kd.ebg.receipt.common.framework.frame.EBGLogger;
import kd.ebg.receipt.common.framework.receipt.exception.ReceiptException;
import kd.ebg.receipt.common.framework.receipt.util.FileStorageUtil;
import kd.ebg.receipt.common.utils.FileCommonUtils;
import org.jdom2.Content;
import org.jdom2.Element;

public class DownloadReceiptFileImpl
extends AbstractBankReceiptImpl
implements IBankReceipt {
    private static EBGLogger logger = EBGLogger.getInstance().getLogger(DownloadReceiptFileImpl.class);

    public String pack(BankReceiptRequest request) {
        String accNo = request.getAccNo();
        String transDateStr = LocalDateUtil.formatDate((LocalDate)request.getTransDate());
        Element root = GZC_DC_Packer.packRoot(this.getBizCode());
        Element body = JDomUtils.addChild((Element)root, (String)"Body");
        Element ReceiptList = JDomUtils.addChild((Element)body, (String)"ReceiptList");
        Element map = JDomUtils.createRoot((String)"Map");
        ReceiptList.addContent((Content)map);
        String jsonStr = request.getRequestStr();
        JSONObject jsonObject = JSONObject.parseObject((String)jsonStr);
        String TransSeq = jsonObject.getString("TransSeq");
        String DcFlag = jsonObject.getString("DcFlag");
        JDomUtils.addChild((Element)map, (String)"TransDate", (String)transDateStr);
        JDomUtils.addChild((Element)map, (String)"TransSeq", (String)TransSeq);
        JDomUtils.addChild((Element)map, (String)"DcFlag", (String)DcFlag);
        JDomUtils.addChild((Element)map, (String)"TransAcNo", (String)accNo);
        String encoding = EBContext.getContext().getCharsetName();
        String requestStr = JDomUtils.root2String((Element)root, (String)encoding);
        EBContext.getContext().setRemoveWriteResponseLog(true);
        return requestStr;
    }

    public BankReceiptResponseEB parse(BankReceiptRequest request, String responseStr) {
        String fileNamePath;
        EBContext.getContext().setRemoveWriteResponseLog(false);
        if (responseStr.length() < 500) {
            logger.info("\u54cd\u5e94\u62a5\u6587\uff1a\n" + responseStr);
        }
        String accNo = request.getAccNo();
        String transDateStr = LocalDateUtil.formatDate((LocalDate)request.getTransDate());
        String jsonStr = request.getRequestStr();
        JSONObject jsonObject = JSONObject.parseObject((String)jsonStr);
        String TransSeq = jsonObject.getString("TransSeq");
        String fileName = jsonObject.getString("fileName");
        String bakFilePath = FileStorageUtil.getFileBakPathByAccNoAndDate((String)Constants.BANK_VERSION, (String)accNo, (String)transDateStr);
        Element root = JDomUtils.string2Root((String)responseStr, (String)RequestContextUtils.getCharset());
        Element head = root.getChild("Head");
        String returnCode = head.getChildTextTrim("E2BRejCode");
        String returnMessage = head.getChildTextTrim("E2BRejMsg");
        if (!"00000000".equals(returnCode)) {
            String errorMsg = String.format(ResManager.loadKDString((String)"\u8d63\u5dde\u94f6\u884c(10000007)\u63a5\u53e3\u54cd\u5e94\u7801:%s", (String)"DownloadReceiptFileImpl_5", (String)"ebg-receipt-banks-gzc-dc", (Object[])new Object[0]), returnCode) + String.format(ResManager.loadKDString((String)";\u51fa\u9519\u539f\u56e0\u4e3a:%s", (String)"DownloadReceiptFileImpl_6", (String)"ebg-receipt-banks-gzc-dc", (Object[])new Object[0]), returnMessage);
            throw EBExceiptionUtil.serviceException((String)errorMsg);
        }
        Element Body = root.getChild("Body");
        String Pdate = Body.getChildTextTrim("Pdate");
        boolean isSave = FileCommonUtils.base64ToFile((String)Pdate, (String)(fileNamePath = bakFilePath + File.separator + fileName));
        if (isSave) {
            return BankReceiptResponseEB.success();
        }
        throw new ReceiptException(String.format(ResManager.loadKDString((String)"10000007\u63a5\u53e3\u4e0b\u8f7d\u6d41\u6c34\u53f7\u4e3a\uff1a%s\u7684\u56de\u5355\u6587\u4ef6\uff0c\u4fdd\u5b58\u6587\u4ef6\u5931\u8d25\uff0c\u8bf7\u7a0d\u540e\u91cd\u8bd5\u3002", (String)"DownloadReceiptFileImpl_7", (String)"ebg-receipt-banks-gzc-dc", (Object[])new Object[0]), TransSeq));
    }

    public String getDeveloper() {
        return "lw";
    }

    public String getBizCode() {
        return "10000007";
    }

    public String getBizDesc() {
        return ResManager.loadKDString((String)"\u8d63\u5dde\u94f6\u884c\u7535\u5b50\u56de\u5355\u4e0b\u8f7d\u8bf7\u6c42", (String)"DownloadReceiptFileImpl_4", (String)"ebg-receipt-banks-gzc-dc", (Object[])new Object[0]);
    }

    public void configFactory(ConnectionFactory factory) {
        super.configFactory(factory);
        factory.setHttpHeader("Content-Type", "application/xml;charset=utf-8");
    }
}

