/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.receipt.banks.cmb.opa.service.receipt.util.gm;

import com.alibaba.fastjson.JSONObject;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import kd.ebg.egf.common.context.EBContext;
import kd.ebg.egf.common.utils.string.StringUtils;
import kd.ebg.receipt.banks.cmb.opa.BankBusinessConfig;
import kd.ebg.receipt.banks.cmb.opa.service.receipt.util.gm.JsonUtil;
import kd.ebg.receipt.banks.cmb.opa.service.receipt.util.gm.SMUtil;
import kd.ebg.receipt.banks.cmb.opa.service.receipt.util.gm.SignWithAES;
import kd.ebg.receipt.banks.cmb.opa.service.receipt.util.gm.SignWithRSA;
import kd.ebg.receipt.common.framework.context.RequestContextUtils;
import kd.ebg.receipt.common.framework.frame.EBGLogger;

public class MsgPacker {
    public static String getSendMsg(JSONObject object, EBGLogger logger, String bizCode) {
        String signstr;
        EBContext.getContext().setType("request");
        String orgi = JsonUtil.serialJsonOrdered(object);
        logger.info("\u539f\u59cb\u6570\u636e\uff1a" + orgi);
        if (BankBusinessConfig.isPreCloud()) {
            return MsgPacker.getFormParam(orgi, false, bizCode);
        }
        boolean isSM = "SM".equalsIgnoreCase(RequestContextUtils.getBankParameterValue((String)"sign_type"));
        if (isSM) {
            logger.info("\u5f53\u524d\u52a0\u5bc6\u65b9\u5f0f\u4e3a\uff1a\u56fd\u5bc6(SM)");
            signstr = SMUtil.signUser(orgi);
        } else {
            logger.info("\u5f53\u524d\u52a0\u5bc6\u65b9\u5f0f\u4e3a\uff1aAES");
            signstr = SignWithRSA.encryptAES256Str(orgi);
        }
        String content = "";
        if (!BankBusinessConfig.isSaasCloud()) {
            logger.info("\u6807\u51c6\u6a21\u5f0f\u4e91\u76f4\u8fde");
            content = JsonUtil.getFinallyStr(object, signstr);
        } else {
            logger.info("saas\u6a21\u5f0f\u4e91\u76f4\u8fde");
            String plateFormSignStr = SMUtil.signKingdee(signstr);
            content = JsonUtil.getPlateFromFinallyStr(object, signstr, plateFormSignStr);
        }
        String result = isSM ? SMUtil.encrypt(content) : SignWithAES.encryptAES256Str(content);
        HashMap<String, String> map = new HashMap<String, String>(16);
        String encoding = RequestContextUtils.getCharset();
        String loginName = RequestContextUtils.getBankParameterValue((String)"lgnnam");
        map.put("UID", loginName);
        if (BankBusinessConfig.isSaasCloud()) {
            map.put("INSPLAT", "KINGDEE");
        }
        if (isSM) {
            map.put("ALG", "SM");
        }
        if (StringUtils.isNotEmpty((String)bizCode)) {
            map.put("FUNCODE", bizCode);
        }
        try {
            map.put("DATA", URLEncoder.encode(result, encoding));
        }
        catch (Exception exception) {
            // empty catch block
        }
        String param = MsgPacker.createLinkString(map);
        return param;
    }

    private static String getFormParam(String param, boolean isSM, String bizCode) {
        HashMap<String, String> map = new HashMap<String, String>(16);
        String encoding = RequestContextUtils.getCharset();
        String loginName = RequestContextUtils.getBankParameterValue((String)"lgnnam");
        map.put("UID", loginName);
        if (BankBusinessConfig.isSaasCloud()) {
            map.put("INSPLAT", "KINGDEE");
        }
        if (isSM) {
            map.put("ALG", "SM");
        }
        if (StringUtils.isNotEmpty((String)bizCode)) {
            map.put("FUNCODE", bizCode);
        }
        try {
            map.put("DATA", URLEncoder.encode(param, encoding));
        }
        catch (Exception exception) {
            // empty catch block
        }
        String result = MsgPacker.createLinkString(map);
        return result;
    }

    public static String createLinkString(Map<String, String> params) {
        ArrayList<String> keys = new ArrayList<String>(params.keySet());
        Collections.sort(keys);
        StringBuilder prestr = new StringBuilder();
        String eqs = "=";
        for (int i = 0; i < keys.size(); ++i) {
            String key = keys.get(i);
            String value = params.get(key);
            if (i == keys.size() - 1) {
                prestr.append(key).append(eqs).append(value);
                continue;
            }
            prestr.append(key).append(eqs).append(value).append("&");
        }
        return prestr.toString();
    }
}

