/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.receipt.banks.gsnx.dc.service.receipt.api;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import java.time.LocalDate;
import java.util.ArrayList;
import kd.ebg.egf.common.utils.LocalDateUtil;
import kd.ebg.receipt.banks.gsnx.dc.service.receipt.utils.CommonPacker;
import kd.ebg.receipt.banks.gsnx.dc.service.receipt.utils.CommonParser;
import kd.ebg.receipt.business.receipt.atom.AbstractBankReceiptImpl;
import kd.ebg.receipt.business.receipt.atom.IBankReceipt;
import kd.ebg.receipt.business.receipt.bank.frontProxy.BankReceiptRequest;
import kd.ebg.receipt.business.receipt.bank.frontProxy.BankReceiptResponseEB;
import kd.ebg.receipt.common.framework.frame.EBGLogger;
import kd.ebg.receipt.common.model.DetailInfo;

public class BankReceiptBatchPrintImpl
extends AbstractBankReceiptImpl
implements IBankReceipt {
    private static EBGLogger logger = EBGLogger.getInstance().getLogger(BankReceiptBatchPrintImpl.class);

    public String getDeveloper() {
        return "";
    }

    public String getBizCode() {
        return "getelebillinfo";
    }

    public String getBizDesc() {
        return null;
    }

    public String pack(BankReceiptRequest request) {
        String transDateStr = LocalDateUtil.formatDate((LocalDate)request.getTransDate());
        JSONObject body = new JSONObject();
        body.put("acc", (Object)request.getAccNo());
        body.put("start_date", (Object)transDateStr);
        body.put("end_date", (Object)transDateStr);
        return CommonPacker.createRootMsg(body, this.getBizCode());
    }

    public BankReceiptResponseEB parse(BankReceiptRequest request, String responseStr) {
        JSONObject body = CommonParser.getRespBody(responseStr);
        String tolnum = body.getString("tolnum");
        logger.info("\u56de\u5355\u6761\u6570\uff1a{}", (Object)tolnum);
        ArrayList<DetailInfo> detailInfoList = new ArrayList<DetailInfo>(1);
        JSONArray respList = body.getJSONArray("resp_list");
        for (Object list : respList) {
            JSONObject jsonObject = (JSONObject)list;
            Object tran_amt = jsonObject.get((Object)"tran_amt");
            jsonObject.put("tran_amt", (Object)tran_amt.toString());
            String lzw_file = jsonObject.getString("lzw_file");
            jsonObject.remove((Object)"lzw_file");
            DetailInfo detailInfo = new DetailInfo();
            detailInfo.setJson(jsonObject.toJSONString());
            detailInfo.setExplanation(lzw_file);
            detailInfoList.add(detailInfo);
        }
        return BankReceiptResponseEB.success(detailInfoList);
    }
}

