/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.receipt.banks.szsrcb.cmp.service.receipt.fetch;

import java.time.LocalDate;
import java.util.ArrayList;
import kd.ebg.receipt.banks.szsrcb.cmp.service.receipt.api.BatchReceiptDownloadApplyImpl;
import kd.ebg.receipt.business.receipt.atom.AbstractBankReceiptHandleImpl;
import kd.ebg.receipt.business.receipt.atom.IBankReceiptHandle;
import kd.ebg.receipt.business.receipt.bank.frontProxy.BankReceiptRequest;
import kd.ebg.receipt.business.receipt.bank.frontProxy.BankReceiptResponseEB;
import kd.ebg.receipt.business.receipt.bank.task.BankReceiptHandleRequest;
import kd.ebg.receipt.business.receipt.bank.task.BankReceiptHandleResponseEB;
import kd.ebg.receipt.business.receipt.entity.TaskStatus;
import kd.ebg.receipt.common.core.utils.EBGStringUtils;
import kd.ebg.receipt.common.framework.frame.EBGLogger;
import kd.ebg.receipt.common.framework.services.receipt.DownloadListDetailService;
import kd.ebg.receipt.common.framework.services.receipt.DownloadTaskService;
import kd.ebg.receipt.common.model.receipt.DownloadListDetail;
import kd.ebg.receipt.common.model.receipt.DownloadListTask;
import kd.ebg.receipt.common.utils.SpringContextUtil;

public class BankReceiptFetchListImpl
extends AbstractBankReceiptHandleImpl
implements IBankReceiptHandle {
    private static EBGLogger logger = EBGLogger.getInstance().getLogger(BankReceiptFetchListImpl.class);
    public DownloadListDetailService downloadListDetailService;
    public DownloadTaskService downloadTaskService;

    public void init(BankReceiptHandleRequest request) {
        this.downloadListDetailService = (DownloadListDetailService)SpringContextUtil.getBean(DownloadListDetailService.class);
        this.downloadTaskService = (DownloadTaskService)SpringContextUtil.getBean(DownloadTaskService.class);
    }

    public boolean match(BankReceiptHandleRequest request) {
        if (request == null) {
            return false;
        }
        Integer status = request.getTaskStatus();
        if (status == null) {
            return false;
        }
        return status.intValue() == TaskStatus.PROCESSING.getId();
    }

    public BankReceiptHandleResponseEB doBiz(BankReceiptHandleRequest bankReceiptHandleRequest) {
        this.init(bankReceiptHandleRequest);
        long taskId = bankReceiptHandleRequest.getTaskId();
        DownloadListTask task = this.downloadTaskService.findById(taskId);
        ArrayList<DownloadListDetail> result = new ArrayList<DownloadListDetail>(16);
        LocalDate transDate = task.getTransDate();
        String accNo = task.getAccNo();
        BatchReceiptDownloadApplyImpl bankReceiptDownloadPre = new BatchReceiptDownloadApplyImpl();
        BankReceiptRequest bankReceiptRequest = BankReceiptRequest.builder().accNo(accNo).transDate(transDate).build();
        BankReceiptResponseEB receiptResponseEB = bankReceiptDownloadPre.doBiz(bankReceiptRequest);
        String fileName = (String)receiptResponseEB.getData();
        DownloadListDetail downloadListDetail = new DownloadListDetail();
        if (EBGStringUtils.isEmpty((String)fileName)) {
            downloadListDetail.setFileName("EBG_FIRST_ZIP.zip");
            downloadListDetail.setFileLink("EBG_FIRST_ZIP.zip");
        } else {
            downloadListDetail.setFileName(fileName);
            downloadListDetail.setFileLink(fileName);
        }
        result.add(downloadListDetail);
        return BankReceiptHandleResponseEB.success(result);
    }

    public String getDeveloper() {
        return null;
    }

    public String getBizCode() {
        return "SZSRCB_CMP_BankReceiptFetchList";
    }

    public String getBizDesc() {
        return null;
    }
}

