/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.receipt.banks.bosh.dc.service.api.sign;

import java.io.OutputStream;
import kd.bos.dataentity.resource.ResManager;
import kd.ebg.egf.common.exception.EBExceiptionUtil;
import kd.ebg.egf.common.exception.EBServiceException;
import kd.ebg.egf.common.framework.communication.ConnectionFactory;
import kd.ebg.egf.common.framework.communication.IConnection;
import kd.ebg.egf.common.utils.xml.JDomUtils;
import kd.ebg.receipt.banks.bosh.dc.BankBusinessConfig;
import kd.ebg.receipt.banks.bosh.dc.service.api.utils.CommumicationHelper;
import kd.ebg.receipt.banks.bosh.dc.service.api.utils.Packer;
import kd.ebg.receipt.common.framework.frame.EBGLogger;
import org.jdom2.CDATA;
import org.jdom2.Content;
import org.jdom2.Document;
import org.jdom2.Element;

public class SignHelper {
    private static final EBGLogger logger = EBGLogger.getInstance().getLogger(SignHelper.class);

    public static String sign(String orgMsg) throws Exception {
        logger.info("\u7b7e\u540d\u539f\u59cb\u5185\u5bb9:" + orgMsg);
        if (Packer.isCFCA()) {
            orgMsg = JDomUtils.xml2XmlWithOutIndentLineSeparator((String)orgMsg, (String)"GBK");
            String responseStr = SignHelper.doCFCASign(orgMsg);
            logger.info("cfca\u8fd4\u56de\u62a5\u6587\uff1a{}", (Object)responseStr);
            Document doc = JDomUtils.str2Doc((String)responseStr, (String)"GBK");
            Element root = doc.getRootElement();
            Element body = root.getChild("body");
            return body != null ? body.getChildTextTrim("sign") : "";
        }
        String signMsg = SignHelper.createSignRequest(orgMsg);
        String signRspMsg = SignHelper.doSign(signMsg);
        logger.info("\u7b7e\u540d\u8fd4\u56de\u5185\u5bb9:" + signRspMsg);
        if (!signRspMsg.startsWith("<?xml")) {
            signRspMsg = "<?xml version=\"1.0\" encoding=\"gb2312\"?><msg>" + signRspMsg;
        }
        String signedData = SignHelper.getSignedData(signRspMsg);
        logger.info("\u7b7e\u540d\u6210\u529f.");
        return signedData;
    }

    public static String createSignRequest(String orgMsg) throws Exception {
        Element msg_head = new Element("msg_head");
        JDomUtils.addChild((Element)msg_head, (String)"msg_type", (String)"0");
        JDomUtils.addChild((Element)msg_head, (String)"msg_id", (String)"1005");
        JDomUtils.addChild((Element)msg_head, (String)"msg_sn", (String)"0");
        JDomUtils.addChild((Element)msg_head, (String)"version", (String)"1");
        Element msg_body = new Element("msg_body");
        JDomUtils.addChild((Element)msg_body, (String)"origin_data_len", (String)("" + CommumicationHelper.getByte(orgMsg, CommumicationHelper.getEncoding4Comm()).length));
        if (BankBusinessConfig.isSignHasCDATA()) {
            Element originData = JDomUtils.addChild((Element)msg_body, (String)"origin_data");
            originData.addContent((Content)new CDATA(orgMsg));
        } else {
            JDomUtils.addChild((Element)msg_body, (String)"origin_data", (String)orgMsg);
        }
        Element msg = new Element("msg");
        JDomUtils.addChild((Element)msg, (Element)msg_head);
        JDomUtils.addChild((Element)msg, (Element)msg_body);
        String str = "";
        if (BankBusinessConfig.isSignHasCDATA()) {
            str = JDomUtils.root2StringNoIndentLineNoSeparator((Element)msg, (String)"GBK");
        } else {
            str = JDomUtils.root2StringNoIndentLineNoSeparator((Element)msg, (String)"GBK");
            str = str.replace("&lt;", "<").replace("&gt;", ">");
        }
        return str;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static String doSign(String signMsg) {
        try {
            ConnectionFactory factory = ConnectionFactory.getInstanceAutoInit();
            IConnection conn = factory.createSignConnection();
            conn.openConnection();
            try (OutputStream outputStream = conn.getOutputStream();){
                String string = CommumicationHelper.sendAndRecvMessage(conn, outputStream, signMsg);
                return string;
            }
        }
        catch (Throwable t) {
            throw EBExceiptionUtil.serviceException((Throwable)t);
        }
    }

    /*
     * Exception decompiling
     */
    public static String doCFCASign(String signMsg) throws EBServiceException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 3 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private static String getSignedData(String retSignMsg) {
        String signed_data;
        Element root = JDomUtils.string2Root((String)retSignMsg, (String)"GBK");
        Element msg_body = root.getChild("msg_body");
        String error_no = msg_body.getChildTextTrim("error_no");
        if (null != error_no) {
            String msg = String.format(ResManager.loadKDString((String)"\u7b7e\u540d\u5931\u8d25\uff0cerror_no\uff1a%s\u3002", (String)"SignHelper_2", (String)"ebg-receipt-banks-bosh-dc", (Object[])new Object[0]), error_no);
            logger.info(msg);
            EBExceiptionUtil.serviceException((String)msg);
        }
        if ((signed_data = msg_body.getChildTextTrim("signed_data")) != null) {
            return signed_data;
        }
        String msg = ResManager.loadKDString((String)"\u83b7\u5f97signed_data\u6570\u636e\u5931\u8d25\u3002", (String)"SignHelper_1", (String)"ebg-receipt-banks-bosh-dc", (Object[])new Object[0]);
        logger.info(msg);
        throw EBExceiptionUtil.serviceException((String)msg);
    }
}

