/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.receipt.banks.ccb.ccip.service.receipt;

import java.time.LocalDate;
import java.time.format.DateTimeFormatter;
import java.util.Map;
import kd.ebg.egf.common.context.EBContext;
import kd.ebg.receipt.banks.ccb.ccip.BankBusinessConfig;
import kd.ebg.receipt.banks.ccb.ccip.service.receipt.CCBCCIPCommConfig;
import kd.ebg.receipt.common.framework.receipt.parse.impl.AbstractFileParser;
import kd.ebg.receipt.common.framework.receipt.util.EBConfigBuilder;

public class CCBCCIPFileParser
extends AbstractFileParser {
    private static final String FILE_SEPERATOR = "-";

    public String getAccNo() {
        return "e";
    }

    public LocalDate getDate() {
        return LocalDate.now();
    }

    public int getDateIndex() {
        int len = this.getFileSplitLength();
        int dateIndex = 2;
        for (int i = 0; i < len; ++i) {
            if (this.getParsedString(i).length() != 8) continue;
            try {
                dateIndex = i;
                break;
            }
            catch (Exception e) {
                // empty catch block
            }
        }
        return dateIndex;
    }

    public String getReceiptNo() {
        String receiptNo = this.getParsedString(1);
        String bankLoginId = EBContext.getContext().getBankLoginID();
        boolean isPushed = ((CCBCCIPCommConfig)EBConfigBuilder.getInstance().buildConfig(CCBCCIPCommConfig.class, bankLoginId)).getCcipPushMode().equals("true");
        if (isPushed) {
            int dataIndex = this.getDateIndex();
            return this.getParsedString(dataIndex + 1);
        }
        return receiptNo;
    }

    public String getAmount() {
        String bankLoginId = EBContext.getContext().getBankLoginID();
        boolean isPushed = ((CCBCCIPCommConfig)EBConfigBuilder.getInstance().buildConfig(CCBCCIPCommConfig.class, bankLoginId)).getCcipPushMode().equals("true");
        if (isPushed) {
            return "e";
        }
        String amount = this.getParsedString(2);
        return amount;
    }

    public String getCdFlag() {
        String cdFlag = "e";
        if (BankBusinessConfig.isUserNewApi()) {
            cdFlag = this.getParsedString(4);
        }
        return cdFlag;
    }

    public String getFileSplit() {
        return FILE_SEPERATOR;
    }

    public String getBankVersion() {
        return "CCB_CCIP";
    }

    public static String createFileName(String accNo, LocalDate transDate, String receiptNo, String amount, Map<String, Integer> tempMap) {
        StringBuilder sb = new StringBuilder();
        sb.append(transDate.format(DateTimeFormatter.BASIC_ISO_DATE)).append(FILE_SEPERATOR).append(receiptNo).append(FILE_SEPERATOR).append(amount);
        String orderNo = receiptNo + amount;
        if (tempMap.containsKey(orderNo)) {
            int serial = tempMap.get(orderNo) + 1;
            tempMap.put(orderNo, serial);
            sb.append(FILE_SEPERATOR).append(String.format("%04d", serial));
        } else {
            tempMap.put(orderNo, 0);
        }
        sb.append(".pdf");
        return sb.toString();
    }

    public static String createFileNameByNewApi(String accNo, LocalDate transDate, String amount, String logNo, String tradeDetailId, String dbtCrDrcCd, Map<String, Integer> tempMap) {
        StringBuilder sb = new StringBuilder();
        sb.append(transDate.format(DateTimeFormatter.BASIC_ISO_DATE)).append(FILE_SEPERATOR).append(logNo).append(FILE_SEPERATOR).append(amount).append(FILE_SEPERATOR).append(tradeDetailId).append(FILE_SEPERATOR).append(dbtCrDrcCd);
        String orderNo = sb.toString();
        if (tempMap.containsKey(orderNo)) {
            int serial = tempMap.get(orderNo) + 1;
            tempMap.put(orderNo, serial);
            sb.append(FILE_SEPERATOR).append(String.format("%04d", serial));
        } else {
            tempMap.put(orderNo, 0);
        }
        sb.append(".pdf");
        return sb.toString();
    }
}

