/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.receipt.banks.nbcb.dc.services.receipt;

import java.time.LocalDate;
import java.util.ArrayList;
import java.util.Objects;
import kd.bos.dataentity.resource.ResManager;
import kd.ebg.egf.common.framework.bank.info.BankRequest;
import kd.ebg.egf.common.utils.LocalDateUtil;
import kd.ebg.egf.common.utils.Sequence;
import kd.ebg.receipt.banks.nbcb.dc.services.receipt.NBCBDcCommConfig;
import kd.ebg.receipt.banks.nbcb.dc.services.receipt.api.AccountReceiptQueryImpl;
import kd.ebg.receipt.business.receipt.atom.AbstractBankReceiptHandleImpl;
import kd.ebg.receipt.business.receipt.atom.IBankReceiptHandle;
import kd.ebg.receipt.business.receipt.bank.frontProxy.BankReceiptRequest;
import kd.ebg.receipt.business.receipt.bank.frontProxy.BankReceiptResponseEB;
import kd.ebg.receipt.business.receipt.bank.task.BankReceiptHandleRequest;
import kd.ebg.receipt.business.receipt.bank.task.BankReceiptHandleResponseEB;
import kd.ebg.receipt.business.receipt.entity.TaskStatus;
import kd.ebg.receipt.common.framework.frame.EBGLogger;
import kd.ebg.receipt.common.framework.receipt.exception.ReceiptException;
import kd.ebg.receipt.common.framework.receipt.util.EBConfigBuilder;
import kd.ebg.receipt.common.model.receipt.DownloadListDetail;

public class BankReceiptFetchListImpl
extends AbstractBankReceiptHandleImpl
implements IBankReceiptHandle {
    private static EBGLogger logger = EBGLogger.getInstance().getLogger(BankReceiptFetchListImpl.class);

    public boolean match(BankReceiptHandleRequest request) {
        if (request == null) {
            return false;
        }
        Integer status = request.getTaskStatus();
        if (status == null) {
            return false;
        }
        return status.intValue() == TaskStatus.PROCESSING.getId();
    }

    public BankReceiptHandleResponseEB doBiz(BankReceiptHandleRequest request) {
        String accNo = request.getAccNo();
        LocalDate transDate = request.getTransDate();
        ArrayList<DownloadListDetail> result = new ArrayList<DownloadListDetail>(16);
        String serialNo = Sequence.gen16Sequence();
        BankReceiptRequest bankReceiptRequest = BankReceiptRequest.builder().accNo(accNo).transDate(transDate).requestStr(serialNo).build();
        AccountReceiptQueryImpl accountReceiptQuery = new AccountReceiptQueryImpl();
        BankReceiptResponseEB bankReceiptResponseEB = (BankReceiptResponseEB)accountReceiptQuery.doBiz((BankRequest)bankReceiptRequest);
        String st = (String)bankReceiptResponseEB.getData();
        DownloadListDetail downloadListDetail = new DownloadListDetail();
        String transDateStr = LocalDateUtil.formatDate((LocalDate)transDate);
        NBCBDcCommConfig nbcbDcCommConfig = (NBCBDcCommConfig)EBConfigBuilder.getInstance().buildConfig(NBCBDcCommConfig.class, request.getBankLoginId());
        if (!Objects.equals(nbcbDcCommConfig.getCheckPutParam(), "JYXH")) {
            st = serialNo;
        }
        downloadListDetail.setFileLink(st);
        downloadListDetail.setFileName(String.format("%s_%s_%s.zip", st, accNo, transDateStr));
        result.add(downloadListDetail);
        if (result.size() == 0) {
            throw new ReceiptException(ResManager.loadKDString((String)"\u672c\u6b21\u4efb\u52a1\u83b7\u53d6\u7684\u56de\u5355\u6587\u4ef6\u5217\u8868\u4e3a\u7a7a\u3002", (String)"BankReceiptFetchListImpl_0", (String)"ebg-receipt-banks-nbcb-dc", (Object[])new Object[0]));
        }
        return BankReceiptHandleResponseEB.success(result);
    }

    public String getDeveloper() {
        return "LW";
    }

    public String getBizCode() {
        return "NBCB_DC_BankReceiptFetchList";
    }

    public String getBizDesc() {
        return ResManager.loadKDString((String)"\u83b7\u53d6\u56de\u5355\u6587\u4ef6\u5217\u8868", (String)"BankReceiptFetchListImpl_1", (String)"ebg-receipt-banks-nbcb-dc", (Object[])new Object[0]);
    }

    public boolean isBreak() {
        return true;
    }
}

