/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.receipt.banks.crcb.dc.service.receipt;

import com.alibaba.fastjson.JSONObject;
import java.time.LocalDate;
import java.util.ArrayList;
import java.util.List;
import kd.bos.dataentity.resource.ResManager;
import kd.ebg.egf.common.utils.LocalDateUtil;
import kd.ebg.receipt.banks.crcb.dc.service.receipt.api.BankQueryReceiptFileNameImpl;
import kd.ebg.receipt.banks.crcb.dc.service.receipt.api.BankQueryReceiptListImpl;
import kd.ebg.receipt.business.receipt.atom.AbstractBankReceiptHandleImpl;
import kd.ebg.receipt.business.receipt.atom.IBankReceiptHandle;
import kd.ebg.receipt.business.receipt.bank.task.BankReceiptHandleRequest;
import kd.ebg.receipt.business.receipt.bank.task.BankReceiptHandleResponseEB;
import kd.ebg.receipt.business.receipt.entity.TaskStatus;
import kd.ebg.receipt.common.framework.frame.EBGLogger;
import kd.ebg.receipt.common.framework.receipt.exception.ReceiptException;
import kd.ebg.receipt.common.framework.services.receipt.DownloadTaskService;
import kd.ebg.receipt.common.model.receipt.DownloadListDetail;
import kd.ebg.receipt.common.model.receipt.DownloadListTask;
import kd.ebg.receipt.common.utils.SpringContextUtil;

public class BankReceiptFetchListImpl
extends AbstractBankReceiptHandleImpl
implements IBankReceiptHandle {
    private static EBGLogger logger = EBGLogger.getInstance().getLogger(BankReceiptFetchListImpl.class);

    public boolean match(BankReceiptHandleRequest request) {
        if (request == null) {
            return false;
        }
        Integer status = request.getTaskStatus();
        if (status == null) {
            return false;
        }
        return status.intValue() == TaskStatus.PROCESSING.getId();
    }

    public BankReceiptHandleResponseEB doBiz(BankReceiptHandleRequest request) {
        long taskId = request.getTaskId();
        DownloadTaskService downloadTaskService = (DownloadTaskService)SpringContextUtil.getBean(DownloadTaskService.class);
        DownloadListTask task = downloadTaskService.findById(taskId);
        ArrayList<DownloadListDetail> result = new ArrayList<DownloadListDetail>(16);
        String accNo = request.getAccNo();
        String transDateStr = LocalDateUtil.formatDate((LocalDate)request.getTransDate());
        LocalDate transDate = request.getTransDate();
        List<String> jsonList = BankQueryReceiptListImpl.queryReceiptList(accNo, transDate);
        logger.info("\u67e5\u8be2\u5230\u7684\u56de\u5355\u6570\u91cf-list.size() = {}", (Object)jsonList.size());
        if (jsonList.size() == 0) {
            throw new ReceiptException(ResManager.loadKDString((String)"\u94f6\u884c\u8fd4\u56de\uff1a\u65e0\u7b26\u5408\u6761\u4ef6\u7684\u6570\u636e\u3002", (String)"BankReceiptFetchListImpl_0", (String)"ebg-receipt-banks-crcb-dc", (Object[])new Object[0]));
        }
        for (String jsonStr : jsonList) {
            DownloadListDetail downloadListDetail = new DownloadListDetail();
            String receiptFileNameJsonString = BankQueryReceiptFileNameImpl.queryReceiptFileName(accNo, transDate, jsonStr);
            JSONObject jsonObject = JSONObject.parseObject((String)jsonStr);
            String unionSeqNo = jsonObject.getString("UnionSeqNo");
            String txnAmt = jsonObject.getString("TxnAmt");
            String credFlag = jsonObject.getString("CredFlag");
            String settlAcct = jsonObject.getString("SettlAcct");
            StringBuilder newFileName = new StringBuilder();
            newFileName.append(accNo).append("_");
            newFileName.append(transDateStr).append("_");
            newFileName.append(unionSeqNo).append("_");
            newFileName.append(txnAmt).append("_");
            newFileName.append(credFlag).append("_");
            newFileName.append(settlAcct).append(".pdf");
            downloadListDetail.setFileLink(receiptFileNameJsonString);
            downloadListDetail.setReceiptJson(jsonStr);
            downloadListDetail.setFileName(newFileName.toString());
            result.add(downloadListDetail);
        }
        if (result.size() == 0) {
            throw new ReceiptException(ResManager.loadKDString((String)"\u672c\u6b21\u4efb\u52a1\u83b7\u53d6\u7684\u56de\u5355\u6587\u4ef6\u5217\u8868\u4e3a\u7a7a\u3002", (String)"BankReceiptFetchListImpl_1", (String)"ebg-receipt-banks-crcb-dc", (Object[])new Object[0]));
        }
        return BankReceiptHandleResponseEB.success(result);
    }

    public String getDeveloper() {
        return "lw";
    }

    public String getBizCode() {
        return "CRCB_DC_BankReceiptFetchList";
    }

    public String getBizDesc() {
        return ResManager.loadKDString((String)"\u83b7\u53d6\u91cd\u5e86\u519c\u5546\u884c\u56de\u5355\u6587\u4ef6\u5217\u8868\u3002", (String)"BankReceiptFetchListImpl_2", (String)"ebg-receipt-banks-crcb-dc", (Object[])new Object[0]);
    }

    public boolean isBreak() {
        return true;
    }
}

