/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.receipt.banks.crcb.dc.service.receipt.api;

import java.time.LocalDate;
import kd.bos.dataentity.resource.ResManager;
import kd.ebg.egf.common.framework.communication.ConnectionFactory;
import kd.ebg.receipt.banks.crcb.dc.service.helper.RequestPacker;
import kd.ebg.receipt.banks.crcb.dc.service.helper.ResponseParser;
import kd.ebg.receipt.business.receipt.atom.AbstractBankReceiptImpl;
import kd.ebg.receipt.business.receipt.atom.IBankReceipt;
import kd.ebg.receipt.business.receipt.bank.frontProxy.BankReceiptRequest;
import kd.ebg.receipt.business.receipt.bank.frontProxy.BankReceiptResponseEB;

public class BankQueryReceiptFileNameImpl
extends AbstractBankReceiptImpl
implements IBankReceipt {
    public String pack(BankReceiptRequest bankReceiptRequest) {
        String accNo = bankReceiptRequest.getAccNo();
        LocalDate transDate = bankReceiptRequest.getTransDate();
        String jsonStr = bankReceiptRequest.getRequestStr();
        return RequestPacker.packReceiptCreateMessage(accNo, transDate, jsonStr);
    }

    public BankReceiptResponseEB parse(BankReceiptRequest bankReceiptRequest, String responseStr) {
        String fileName = ResponseParser.parserReceiptFileMessage(responseStr);
        return BankReceiptResponseEB.success((Object)fileName);
    }

    public String getDeveloper() {
        return "lw";
    }

    public String getBizCode() {
        return "CL0147";
    }

    public String getBizDesc() {
        return ResManager.loadKDString((String)"\u56de\u5355\u751f\u6210\u8bf7\u6c42", (String)"BankQueryReceiptFileNameImpl_0", (String)"ebg-receipt-banks-crcb-dc", (Object[])new Object[0]);
    }

    public void configFactory(ConnectionFactory factory) {
        super.configFactory(factory);
        factory.setHttpHeader("Content-Type", "text/xml;charset=UTF-8");
    }

    public static String queryReceiptFileName(String accNo, LocalDate transDate, String jsonStr) {
        BankQueryReceiptFileNameImpl bankQueryReceiptList = new BankQueryReceiptFileNameImpl();
        BankReceiptRequest bankReceiptRequest = BankReceiptRequest.builder().accNo(accNo).transDate(transDate).requestStr(jsonStr).build();
        BankReceiptResponseEB response = bankQueryReceiptList.doBiz(bankReceiptRequest);
        return (String)response.getData();
    }
}

