/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.receipt.banks.icbc.opa.service.reconciliation;

import com.jcraft.jsch.ChannelSftp;
import java.io.File;
import java.io.FileFilter;
import java.io.IOException;
import java.text.SimpleDateFormat;
import java.time.LocalDate;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Enumeration;
import java.util.List;
import java.util.Locale;
import java.util.Vector;
import kd.bos.dataentity.resource.ResManager;
import kd.ebg.egf.common.context.EBContext;
import kd.ebg.receipt.banks.icbc.opa.service.receipt.ICBCOpaCommConfig;
import kd.ebg.receipt.business.receipt.atom.reconciliation.AbstractBankReconciliationFetchHandleImpl;
import kd.ebg.receipt.business.receipt.atom.reconciliation.IBankReconciliationHandle;
import kd.ebg.receipt.business.receipt.bank.task.reconciliation.BankReconciliationHandleRequest;
import kd.ebg.receipt.business.receipt.bank.task.reconciliation.BankReconciliationHandleResponseEB;
import kd.ebg.receipt.business.receipt.entity.TaskStatus;
import kd.ebg.receipt.business.receipt.utils.BankReceiptApiUtil;
import kd.ebg.receipt.common.core.utils.EBGStringUtils;
import kd.ebg.receipt.common.core.utils.GZFileUtils;
import kd.ebg.receipt.common.framework.frame.EBGLogger;
import kd.ebg.receipt.common.framework.receipt.bank.BankFtpProperties;
import kd.ebg.receipt.common.framework.receipt.exception.ReceiptException;
import kd.ebg.receipt.common.framework.receipt.util.EBConfigBuilder;
import kd.ebg.receipt.common.framework.receipt.util.FileStorageUtil;
import kd.ebg.receipt.common.framework.receipt.util.SFTPUtils;
import kd.ebg.receipt.common.framework.services.reconciliation.ReconciliationDownloadTaskService;
import kd.ebg.receipt.common.model.reconciliation.ReconciliationDetail;
import kd.ebg.receipt.common.model.reconciliation.ReconciliationInfo;
import kd.ebg.receipt.common.utils.FileCommonUtils;
import kd.ebg.receipt.common.utils.SpringContextUtil;
import org.apache.tools.zip.ZipEntry;
import org.apache.tools.zip.ZipFile;

public class BankReconciliationFetchListImpl
extends AbstractBankReconciliationFetchHandleImpl
implements IBankReconciliationHandle {
    private static EBGLogger logger = EBGLogger.getInstance().getLogger(BankReconciliationFetchListImpl.class);
    private ReconciliationDownloadTaskService reconciliationDownloadTaskService;

    public void init(BankReconciliationHandleRequest request) {
        this.reconciliationDownloadTaskService = (ReconciliationDownloadTaskService)SpringContextUtil.getBean(ReconciliationDownloadTaskService.class);
    }

    public boolean match(BankReconciliationHandleRequest request) {
        if (request == null) {
            return false;
        }
        Integer status = request.getTaskStatus();
        if (status == null) {
            return false;
        }
        return status.intValue() == TaskStatus.PROCESSING.getId();
    }

    public BankReconciliationHandleResponseEB doBiz(BankReconciliationHandleRequest request) {
        this.init(request);
        long taskId = request.getTaskId();
        ReconciliationInfo downloadListTask = this.reconciliationDownloadTaskService.findById(taskId);
        List<ReconciliationDetail> downloadListDetails = this.doJob_pushMode(downloadListTask);
        return BankReconciliationHandleResponseEB.success(downloadListDetails);
    }

    public List<ReconciliationDetail> doJob_pushMode(ReconciliationInfo task) {
        String accNo = task.getAccNo();
        String transDateStr = task.getTransDate().format(DateTimeFormatter.BASIC_ISO_DATE);
        String bakFilePath = FileStorageUtil.getReconciliationFileBakPathByAccNoAndDate((String)EBContext.getContext().getBankVersionID(), (String)accNo, (String)transDateStr);
        ArrayList<ReconciliationDetail> result = new ArrayList<ReconciliationDetail>(16);
        List<String> fileList = this.getFileList(task);
        for (String fileName : fileList) {
            ReconciliationDetail detail = new ReconciliationDetail();
            detail.setFileName(fileName);
            result.add(detail);
        }
        if (result.size() == 0) {
            throw new ReceiptException(ResManager.loadKDString((String)"\u672c\u6b21\u4efb\u52a1\u83b7\u53d6\u7684\u5bf9\u8d26\u5355\u6587\u4ef6\u5217\u8868\u4e3a\u7a7a\u3002", (String)"BankReconciliationFetchListImpl_0", (String)"ebg-receipt-banks-icbc-cmp", (Object[])new Object[0]));
        }
        return result;
    }

    private List<String> getFileList(ReconciliationInfo task) {
        ChannelSftp sftp;
        ArrayList<String> fileList;
        block21: {
            fileList = new ArrayList<String>(16);
            String accNo = task.getAccNo();
            String bankLoginId = task.getBankLoginId();
            LocalDate transDate = task.getTransDate();
            String transDateStr = task.getTransDate().format(DateTimeFormatter.BASIC_ISO_DATE);
            String bakFilePath = FileStorageUtil.getReconciliationFileBakPathByAccNoAndDate((String)EBContext.getContext().getBankVersionID(), (String)accNo, (String)transDateStr);
            LocalDate localDate = transDate;
            BankFtpProperties ftpProperties = (BankFtpProperties)EBConfigBuilder.getInstance().buildConfig(BankFtpProperties.class, bankLoginId);
            String sftp_path = ftpProperties.getFtpPath();
            String ftpPath = sftp_path = EBGStringUtils.isNotEmpty((String)sftp_path) ? sftp_path : "/";
            ICBCOpaCommConfig config = (ICBCOpaCommConfig)EBConfigBuilder.getInstance().buildConfig(ICBCOpaCommConfig.class, bankLoginId);
            String reconciliationPath = config.getReconciliationPath();
            if (EBGStringUtils.isNotEmpty((String)reconciliationPath)) {
                ftpPath = reconciliationPath;
            }
            sftp = null;
            try {
                if (ftpProperties.getReceiptAchieveWay().equals("sftp")) {
                    Vector vector;
                    sftp = SFTPUtils.getInstance().getSftp();
                    if (sftp == null || !EBGStringUtils.isNotEmpty((String)ftpPath) || (vector = sftp.ls(ftpPath)).isEmpty()) break block21;
                    String fileName = "";
                    boolean isCdPath = true;
                    for (int i = 0; i < vector.size(); ++i) {
                        ChannelSftp.LsEntry file = (ChannelSftp.LsEntry)vector.get(i);
                        fileName = file.getFilename();
                        if (!fileName.endsWith(".zip")) continue;
                        try {
                            if (EBGStringUtils.isEmpty((String)fileName) || !this.isReconciliationZipFile(fileName, accNo, transDateStr)) continue;
                            if (!isCdPath) {
                                ftpPath = "";
                            }
                            logger.info("\u5de5\u884c-{}-{}-\u5f00\u59cb\u4e0b\u8f7d\u538b\u7f29\u5305\uff1a{}", new Object[]{accNo, transDate, fileName});
                            boolean flag = false;
                            try {
                                flag = SFTPUtils.getInstance().downloadSingleFile(ftpPath, fileName, bakFilePath, sftp);
                            }
                            catch (Exception e) {
                                logger.info("\u5de5\u884c-{}-{}-\u4e0b\u8f7d\u538b\u7f29\u5305\uff1a{} \u5f02\u5e38\uff1a{}", new Object[]{accNo, transDate, fileName, e.getMessage()});
                            }
                            if (!flag) {
                                logger.info("\u5de5\u884c-{}-{}-\u5f00\u59cb\u4e0b\u8f7d\u538b\u7f29\u5305\uff1a{} sftp\u76ee\u5f55\uff1a{}", new Object[]{accNo, transDate, fileName, sftp_path});
                                flag = SFTPUtils.getInstance().downloadSingleFile(sftp_path, fileName, bakFilePath, sftp);
                            }
                            if (!flag) continue;
                            isCdPath = false;
                            List<String> receiptList = BankReconciliationFetchListImpl.readZipFiles(bakFilePath + File.separator + fileName);
                            logger.info("\u5de5\u884c-{}-{}-\u538b\u7f29\u5305\uff1a{}-\u5b58\u5728\u7684\u5bf9\u8d26\u5355\u6587\u4ef6\u6570\u91cf\uff1a{}", new Object[]{accNo, transDate, fileName, receiptList.size()});
                            if (receiptList == null || receiptList.size() == 0) {
                                throw new ReceiptException(String.format(ResManager.loadKDString((String)"\u6587\u4ef6%s\u4e0d\u5305\u542bofd\u683c\u5f0f\u7684\u5bf9\u8d26\u5355\u6587\u4ef6\u3002", (String)"BankReconciliationFetchListImpl_1", (String)"ebg-receipt-banks-icbc-cmp", (Object[])new Object[0]), fileName));
                            }
                            if (!GZFileUtils.unZipFiles((String)(bakFilePath + File.separator + fileName), (String)bakFilePath)) continue;
                            logger.info("\u89e3\u538b\u5b8c\u6bd5...");
                            File accFile = FileCommonUtils.getFileByPath((String)bakFilePath);
                            if (accFile.exists()) {
                                PDFFilter fitler = new PDFFilter(accNo);
                                File[] files = accFile.listFiles(fitler);
                                logger.info("\u5de5\u884c-{}-{}-\u538b\u7f29\u5305\uff1a{}-\u5b58\u5728\u8be5\u8d26\u53f7\u5bf9\u8d26\u5355\u6587\u4ef6\u6570\u91cf\uff1a{}", new Object[]{accNo, transDate, fileName, files.length});
                                if (files.length > 0) {
                                    for (int j = 0; j < files.length; ++j) {
                                        fileList.add(files[j].getName());
                                    }
                                }
                                logger.info("\u83b7\u53d6\u8d26\u53f7\u6587\u4ef6\u660e\u7ec6\u5b8c\u6bd5...");
                            }
                            logger.info("\u8f6c\u79fb\u6587\u4ef6\u5230bak\u76ee\u5f55\u5b8c\u6bd5...");
                            FileCommonUtils.getFileByPath((String)(bakFilePath + File.separator + fileName)).delete();
                            logger.info("{}-{}-\u5220\u9664ZIP\u6587\u4ef6\u5b8c\u6bd5...,\u6587\u4ef6\u540d\u4e3a\uff1a{}", new Object[]{accNo, transDate, fileName});
                            continue;
                        }
                        catch (Exception e) {
                            // empty catch block
                        }
                    }
                    break block21;
                }
                if (ftpProperties.getReceiptAchieveWay().equals("bank_login")) {
                    String matchKeyString;
                    List<String> filenames;
                    if (EBGStringUtils.isEmpty((String)reconciliationPath)) {
                        ftpPath = ftpProperties.getFrontProxyPath();
                    }
                    if ((filenames = this.getFileByName(matchKeyString = this.matchKeyString(transDateStr), task.getAccNo(), task.getTransDate(), ".zip", ftpPath)) != null && filenames.size() > 0) {
                        for (String filename : filenames) {
                            if (!this.isReconciliationZipFile(filename, accNo, transDateStr)) continue;
                            BankReceiptApiUtil bankReceiptApiUtil = new BankReceiptApiUtil(accNo, task.getTransDate());
                            boolean flag = bankReceiptApiUtil.downloadReceiptFile(filename, bakFilePath);
                            PDFFilter fitler = new PDFFilter(accNo);
                            this.handleFiles(fileList, filename, flag, fitler, bakFilePath);
                        }
                    }
                }
            }
            catch (Exception e) {
                try {
                    String msg = String.format(ResManager.loadKDString((String)"\u83b7\u53d6\u5de5\u884c\u7535\u5b50\u5bf9\u8d26\u5355\u6587\u4ef6\u5217\u8868\u4efb\u52a1\uff0cSFTP\u53d1\u751f\u5f02\u5e38\uff1a%s\u3002\u8bf7\u68c0\u67e5SFTP\u914d\u7f6e\u4fe1\u606f\u548cSFTP\u670d\u52a1\u662f\u5426\u6b63\u5e38\u8fd0\u884c\uff0c\u5e76\u4f7f\u7528SFTP\u5de5\u5177\u786e\u8ba4\u662f\u5426\u53ef\u8fde\u901a\u3002", (String)"BankReconciliationFetchListImpl_2", (String)"ebg-receipt-banks-icbc-cmp", (Object[])new Object[0]), e.getMessage());
                    throw new ReceiptException(msg, e.getCause());
                }
                catch (Throwable throwable) {
                    SFTPUtils.getInstance().close(sftp);
                    throw throwable;
                }
            }
        }
        SFTPUtils.getInstance().close(sftp);
        return fileList;
    }

    public boolean isReconciliationZipFile(String fileName, String accNo, String transDateStr) {
        String matchString = this.matchKeyString(transDateStr);
        return fileName.endsWith(".zip") && fileName.contains(accNo) && fileName.contains(matchString);
    }

    public String matchKeyString(String transDateStr) {
        String transMonthDateStr = BankReconciliationFetchListImpl.getLastDayOfMonth(transDateStr);
        return String.format("_%s_DZD_Month", transMonthDateStr);
    }

    public static String getLastDayOfMonth(String transDateStr) {
        int year = Integer.parseInt(transDateStr.substring(0, 4));
        int month = Integer.parseInt(transDateStr.substring(4, 6));
        Calendar cal = Calendar.getInstance();
        cal.set(1, year);
        cal.set(2, month);
        int lastDay = cal.getMinimum(5);
        cal.set(5, lastDay - 1);
        SimpleDateFormat sdf = new SimpleDateFormat("yyyyMMdd");
        String lastDayOfMonth = sdf.format(cal.getTime());
        return lastDayOfMonth;
    }

    private void handleFiles(List<String> fileList, String fileName, boolean flag, PDFFilter fitler, String bakPath) {
        if (flag && GZFileUtils.unZipFiles((String)(bakPath + File.separator + fileName), (String)bakPath)) {
            logger.info("\u89e3\u538b\u5b8c\u6bd5...");
            File accFile = FileCommonUtils.getFileByPath((String)bakPath);
            if (accFile.exists()) {
                File[] files = accFile.listFiles(fitler);
                if (files.length > 0) {
                    for (int j = 0; j < files.length; ++j) {
                        fileList.add(files[j].getName());
                    }
                }
                logger.info("\u83b7\u53d6\u8d26\u53f7\u6587\u4ef6\u660e\u7ec6\u5b8c\u6bd5...");
            }
            logger.info("\u4e2d\u56fd\u5de5\u5546\u94f6\u884c\u63a8\u5e7f\u7248-\u8f6c\u79fb\u6587\u4ef6\u5230bak\u76ee\u5f55\u5b8c\u6bd5...");
            FileCommonUtils.getFileByPath((String)(bakPath + File.separator + fileName)).delete();
            logger.info("\u4e2d\u56fd\u5de5\u5546\u94f6\u884c\u63a8\u5e7f\u7248-\u5220\u9664\u6587\u4ef6\u5b8c\u6bd5...");
        }
    }

    private List<String> getFileByName(String matchString, String accNo, LocalDate transDate, String suffix, String frontProxyPath) {
        BankReceiptApiUtil bankReceiptApiUtil = new BankReceiptApiUtil(accNo, transDate);
        return bankReceiptApiUtil.getFileByName(matchString, suffix, frontProxyPath);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static List<String> readZipFiles(String patchPath) {
        ArrayList<String> fileList = new ArrayList<String>(16);
        ZipFile zipFile = null;
        try {
            zipFile = new ZipFile(patchPath);
            Enumeration e = zipFile.getEntries();
            while (e.hasMoreElements()) {
                ZipEntry entry = (ZipEntry)e.nextElement();
                System.out.println(entry.getName());
                if (entry.isDirectory() || !entry.getName().endsWith(".ofd") && !entry.getName().endsWith(".OFD")) continue;
                fileList.add(entry.getName());
            }
        }
        catch (IOException e) {
            logger.error(e.getMessage());
        }
        finally {
            try {
                if (zipFile != null) {
                    zipFile.close();
                }
            }
            catch (Exception exception) {}
        }
        return fileList;
    }

    public String getDeveloper() {
        return null;
    }

    public String getBizCode() {
        return null;
    }

    public String getBizDesc() {
        return null;
    }

    public boolean isBreak() {
        return false;
    }

    static class PDFFilter
    implements FileFilter {
        private String accNo;

        public PDFFilter(String accNo) {
            this.accNo = accNo;
        }

        @Override
        public boolean accept(File file) {
            return file.getName().contains(this.accNo) && file.getName().toLowerCase(Locale.ENGLISH).endsWith(".ofd");
        }
    }
}

