/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.receipt.common.framework.context;

import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.util.ConfigurationUtil;
import kd.ebg.egf.common.context.EBContext;
import kd.ebg.egf.common.exception.EBExceiptionUtil;
import kd.ebg.egf.common.framework.conf.IParameter;
import kd.ebg.egf.common.model.bank.BankAcnt;
import kd.ebg.receipt.common.core.utils.EBGStringUtils;
import kd.ebg.receipt.common.framework.frame.BankBundleManager;
import kd.ebg.receipt.common.framework.frame.BankVersion;
import kd.ebg.receipt.common.framework.receipt.bank.BankBusinessProperties;
import kd.ebg.receipt.common.framework.receipt.bank.BankReconciliationProperties;
import kd.ebg.receipt.common.framework.receipt.bank.ReceiptSystemProperties;
import kd.ebg.receipt.common.framework.receipt.util.EBConfigBuilder;
import kd.ebg.receipt.common.model.receipt.DownloadListTask;
import kd.ebg.receipt.common.model.receipt.EBConfig;
import kd.ebg.receipt.common.model.receipt.GlobalObjectParamConfig;
import kd.ebg.receipt.common.model.repository.receipt.EBConfigRepository;
import kd.ebg.receipt.common.model.repository.receipt.GlobalConfigRepository;
import kd.ebg.receipt.common.utils.PropertiesConstantsUtils;
import kd.ebg.receipt.common.utils.SpringContextUtil;
import kd.sdk.annotation.SdkDeprecated;

public class RequestContextUtils {
    public static final String DOWNLOAD_INTERVAL = "download_interval";
    public static final String IS_SUPPORT_BATCH_DOWNLOAD = "is_support_batch_download";

    public static EBContext getRequestContext() {
        EBContext context = EBContext.getContext();
        if (Objects.isNull(context)) {
            throw EBExceiptionUtil.serviceException((String)ResManager.loadKDString((String)"\u7a0b\u5e8f\u9519\u8bef context (in RequestContextUtils)\u3002", (String)"RequestContextUtils_0", (String)"ebg-receipt-common", (Object[])new Object[0]));
        }
        return context;
    }

    public static IParameter getParameter() {
        IParameter parameter = RequestContextUtils.getRequestContext().getParameter();
        if (null != parameter) {
            return parameter;
        }
        throw EBExceiptionUtil.serviceException((String)ResManager.loadKDString((String)"\u7a0b\u5e8f\u9519\u8bef\uff0cParameter\u4e0d\u5b58\u5728(in RequestContextUtils)\u3002", (String)"RequestContextUtils_1", (String)"ebg-receipt-common", (Object[])new Object[0]));
    }

    public static String getBankParameterValue(String bankConfigId) {
        IParameter parameter = RequestContextUtils.getParameter();
        String value = parameter.getBankParameter(bankConfigId);
        return value;
    }

    public static String getCharset() {
        return RequestContextUtils.getBankParameterValue("charset");
    }

    public static String getCustomId() {
        return RequestContextUtils.getRequestContext().getCustomID();
    }

    public static String getExchangeProtocol() {
        return RequestContextUtils.getBankParameterValue("exchangeProtocol");
    }

    public static int getExchangePort() {
        String exchangePortStr = RequestContextUtils.getBankParameterValue("exchangePort");
        if (null != exchangePortStr) {
            try {
                int exchangePort = Integer.parseInt(exchangePortStr);
                return exchangePort;
            }
            catch (NumberFormatException e) {
                throw EBExceiptionUtil.serviceException((String)String.format(ResManager.loadKDString((String)"\u53c2\u6570\u975e\u6cd5\uff0c\u8bbe\u7f6e\u7684\u4ea4\u6613\u7aef\u53e3\u662f%s\u3002", (String)"RequestContextUtils_4", (String)"ebg-receipt-common", (Object[])new Object[0]), exchangePortStr), (Throwable)e);
            }
        }
        throw EBExceiptionUtil.serviceException((String)ResManager.loadKDString((String)"\u7a0b\u5e8f\u9519\u8bef\uff0cParameter\u4e2dexchangePort\u4e0d\u5b58\u5728\u3002", (String)"RequestContextUtils_3", (String)"ebg-receipt-common", (Object[])new Object[0]));
    }

    @SdkDeprecated
    public static void setRunningParam(String key, String value) {
        EBContext context = EBContext.getContext();
        if (context == null) {
            return;
        }
        Map runningParams = context.getRunningParams();
        if (Objects.isNull(runningParams)) {
            runningParams = Maps.newHashMapWithExpectedSize((int)8);
            context.setRunningParams(runningParams);
        }
        runningParams.put(key, value);
    }

    public static String getRunningParam(String key) {
        EBContext context = EBContext.getContext();
        if (context == null) {
            return null;
        }
        Map runningParams = context.getRunningParams();
        if (Objects.isNull(runningParams)) {
            return null;
        }
        return (String)runningParams.get(key);
    }

    public static boolean receiptFormatIsFile() {
        String bankVersion = EBContext.getContext().getBankVersionID();
        return RequestContextUtils.isOnlySupportXml(bankVersion);
    }

    public static boolean isReceiptAutoRetryDownload() {
        String param = RequestContextUtils.getRunningParam("retryingDay");
        if (EBGStringUtils.isNotEmpty(param)) {
            return Integer.parseInt(param) != 0;
        }
        ReceiptSystemProperties receiptSystemProperties = EBConfigBuilder.getInstance().buildConfig(ReceiptSystemProperties.class);
        int retryingDay = receiptSystemProperties.getRetryingDay();
        RequestContextUtils.setRunningParam("retryingDay", Integer.toString(retryingDay));
        return retryingDay != 0;
    }

    public static boolean isCheckReceiptNum() {
        String param = RequestContextUtils.getRunningParam("retryingNum");
        if (EBGStringUtils.isNotEmpty(param)) {
            return Integer.parseInt(param) != 0;
        }
        ReceiptSystemProperties receiptSystemProperties = EBConfigBuilder.getInstance().buildConfig(ReceiptSystemProperties.class);
        int retryingDay = receiptSystemProperties.getRetryingNum();
        RequestContextUtils.setRunningParam("retryingNum", Integer.toString(retryingDay));
        return retryingDay != 0;
    }

    public static boolean receiptFormatIsFile(String bankVersion) {
        return RequestContextUtils.isOnlySupportXml(bankVersion);
    }

    public static boolean isOnlySupportXml(String bankVersion) {
        if (bankVersion.equals("GXNX_CMP")) {
            return false;
        }
        String param = RequestContextUtils.getRunningParam("RECEIPT_FORMAT");
        if (EBGStringUtils.isNotEmpty(param)) {
            return Objects.equals(param, "FILE");
        }
        BankBusinessProperties bankBusinessProperties = EBConfigBuilder.getInstance().buildBusinessConfig(BankBusinessProperties.class, bankVersion);
        String value = bankBusinessProperties.getReceiptFormat();
        RequestContextUtils.setRunningParam("RECEIPT_FORMAT", value);
        return Objects.equals(value, "FILE");
    }

    public static boolean isSupportReconciliation(String bankLoginId) {
        if (EBGStringUtils.isNotEmpty(bankLoginId) && bankLoginId.indexOf("-") != -1) {
            String bankVersion = bankLoginId.substring(0, bankLoginId.indexOf("-"));
            EBContext.getContext().setBankVersionID(bankVersion);
            BankReconciliationProperties bankBusinessProperties = EBConfigBuilder.getInstance().buildConfig(BankReconciliationProperties.class, bankLoginId);
            String value = bankBusinessProperties.getIsSupportReconciliation();
            if (Objects.equals(value, "true")) {
                return true;
            }
        }
        return false;
    }

    public static boolean isMonthReconciliation() {
        String value = RequestContextUtils.getBankParameterValue("isMonthReconciliation");
        return !Objects.equals(value, "false");
    }

    public static boolean isAccNoOfReconciliationByBank() {
        String bankVersionId = EBContext.getContext().getBankVersionID();
        return RequestContextUtils.isAccNoOfReconciliationByBank(bankVersionId);
    }

    public static boolean isAccNoOfReconciliationByBank(String bankVersionId) {
        BankVersion bankVersion = BankBundleManager.getInstance().getBankVersionInfo(bankVersionId);
        return bankVersion.isReconciliationOfAccNo();
    }

    public static boolean isSupportReconciliationOfBankVersion(String bankVersionId) {
        BankVersion bankVersion = BankBundleManager.getInstance().getBankVersionInfo(bankVersionId);
        if (bankVersion == null) {
            return false;
        }
        return bankVersion.isSupportReconciliation();
    }

    public static void handBankAcntListByBankVersion(List<BankAcnt> bankAcntList) {
        if (bankAcntList == null || bankAcntList.isEmpty()) {
            return;
        }
        BankAcnt bankAcnt = bankAcntList.get(0);
        String bankVersionId = bankAcnt.getBankVersionId();
        if (!RequestContextUtils.isAccNoOfReconciliationByBank(bankVersionId)) {
            bankAcnt.setAccNo("");
            ArrayList<BankAcnt> newBankAcntList = new ArrayList<BankAcnt>(1);
            newBankAcntList.add(bankAcnt);
            bankAcntList = newBankAcntList;
        }
    }

    public static int getDownloadIntervalConfig(String bankVersionId, String bankLoginId) {
        String intervalValue = "";
        String customNo = RequestContext.get().getTenantId();
        try {
            EBConfigRepository ebConfigRepository = SpringContextUtil.getBean(EBConfigRepository.class);
            EBConfig receiptConfigs = ebConfigRepository.findOneByBankAndLoginAndCustomAndConfigId(bankVersionId, bankLoginId, customNo, DOWNLOAD_INTERVAL);
            if (receiptConfigs != null) {
                intervalValue = receiptConfigs.getFieldValue();
                if (EBGStringUtils.isEmpty(intervalValue)) {
                    return 0;
                }
                int interval = Integer.parseInt(intervalValue);
                return interval;
            }
        }
        catch (Exception e) {
            return 0;
        }
        return 0;
    }

    public static int getRetryHour() {
        int retryHour;
        int retryHourDefault = 6;
        String retryHourTimeKey = RequestContextUtils.getRunningParam("retry_hour");
        if (EBGStringUtils.isNotEmpty(retryHourTimeKey)) {
            return Integer.parseInt(retryHourTimeKey);
        }
        ReceiptSystemProperties systemProperties = EBConfigBuilder.getInstance().buildConfig(ReceiptSystemProperties.class);
        String value = systemProperties.getRetryHourTimeKey();
        try {
            retryHour = Integer.parseInt(value);
        }
        catch (Exception e) {
            retryHour = retryHourDefault;
        }
        String retryHourStr = ConfigurationUtil.getString((String)"receipt.retryHour");
        try {
            if (!EBGStringUtils.isEmpty(retryHourStr) && (retryHour = Integer.parseInt(retryHourStr)) < 1) {
                retryHour = retryHourDefault;
            }
        }
        catch (Exception e) {
            retryHour = retryHourDefault;
        }
        RequestContextUtils.setRunningParam("retry_hour", Integer.toString(retryHour));
        return retryHour;
    }

    public static int getRetryReceiptTaskNum() {
        int retryReceiptTaskNum = 3;
        String retryNumStr = RequestContextUtils.getRunningParam("retryingTaskNum");
        if (EBGStringUtils.isNotEmpty(retryNumStr)) {
            return Integer.parseInt(retryNumStr);
        }
        GlobalConfigRepository globalConfigRepository = SpringContextUtil.getBean(GlobalConfigRepository.class);
        List<GlobalObjectParamConfig> globalObjectParamConfigs = globalConfigRepository.findBusinessConfigByCustomIDAndId(RequestContext.get().getTenantId(), "retryingTaskNum");
        if (!(globalObjectParamConfigs = globalObjectParamConfigs.stream().filter(o -> o.getObjectName().equals("receipt")).collect(Collectors.toList())).isEmpty()) {
            GlobalObjectParamConfig globalObjectParamConfig = globalObjectParamConfigs.get(0);
            if (globalConfigRepository != null) {
                try {
                    retryReceiptTaskNum = Integer.parseInt(globalObjectParamConfig.getAttrValue()) + 1;
                }
                catch (Throwable e) {
                    retryReceiptTaskNum = 3;
                }
            }
        }
        RequestContextUtils.setRunningParam("retryingTaskNum", Integer.toString(retryReceiptTaskNum));
        return retryReceiptTaskNum;
    }

    public static void setZipName(String zipName) {
        String zipNameStr = RequestContextUtils.getRunningParam("zipName");
        if (EBGStringUtils.isNotEmpty(zipNameStr)) {
            zipNameStr = String.format("%s,", zipNameStr);
            RequestContextUtils.setRunningParam("zipName", zipNameStr);
        } else {
            RequestContextUtils.setRunningParam("zipName", zipName);
        }
    }

    public static void setFileNum(int fileNum) {
        String fileNumStr = RequestContextUtils.getRunningParam("fileNum");
        if (EBGStringUtils.isEmpty(fileNumStr)) {
            RequestContextUtils.setRunningParam("fileNum", Integer.toString(fileNum));
        }
    }

    public static void setZipNameAndFileNumInTask(DownloadListTask task) {
        String fileNumStr;
        String zipNameStr = RequestContextUtils.getRunningParam("zipName");
        if (EBGStringUtils.isNotEmpty(zipNameStr)) {
            task.setZipNames(zipNameStr);
        }
        if (EBGStringUtils.isNotEmpty(fileNumStr = RequestContextUtils.getRunningParam("fileNum")) && EBGStringUtils.isNotEmpty(task.getZipNames())) {
            task.setFileNum(Integer.parseInt(fileNumStr));
        }
    }

    public static boolean isSupportTodayByBankLogin(String bankVersionId, String bankLoginId) {
        String customNo = RequestContext.get().getTenantId();
        try {
            EBConfigRepository ebConfigRepository = SpringContextUtil.getBean(EBConfigRepository.class);
            EBConfig receiptConfigs = ebConfigRepository.findOneByBankAndLoginAndCustomAndConfigId(bankVersionId, bankLoginId, customNo, "is_support_today_receipt");
            if (receiptConfigs != null) {
                String fieldValue = receiptConfigs.getFieldValue();
                if (EBGStringUtils.isEmpty(fieldValue)) {
                    return false;
                }
                return Objects.equals("true", fieldValue);
            }
        }
        catch (Exception e) {
            return false;
        }
        return false;
    }

    public static boolean isSupportBatchDownloadByBankLogin(String bankVersionId, String bankLoginId) {
        String cacheKey = String.format("%s_is_support_batch_download", bankLoginId);
        String value = RequestContextUtils.getRunningParam(cacheKey);
        if (EBGStringUtils.isNotEmpty(value)) {
            return PropertiesConstantsUtils.checkValueIsYes(value);
        }
        String customNo = RequestContext.get().getTenantId();
        try {
            EBConfigRepository ebConfigRepository = SpringContextUtil.getBean(EBConfigRepository.class);
            EBConfig receiptConfigs = ebConfigRepository.findOneByBankAndLoginAndCustomAndConfigId(bankVersionId, bankLoginId, customNo, IS_SUPPORT_BATCH_DOWNLOAD);
            if (receiptConfigs != null) {
                String fieldValue = receiptConfigs.getFieldValue();
                if (EBGStringUtils.isEmpty(fieldValue)) {
                    RequestContextUtils.setRunningParam(cacheKey, "false");
                    return false;
                }
                RequestContextUtils.setRunningParam(cacheKey, fieldValue);
                return PropertiesConstantsUtils.checkValueIsYes(fieldValue);
            }
        }
        catch (Exception e) {
            RequestContextUtils.setRunningParam(cacheKey, "false");
            return false;
        }
        RequestContextUtils.setRunningParam(cacheKey, "false");
        return false;
    }

    public static boolean isOpenEves() {
        String isOpenEves = RequestContextUtils.getRunningParam("is_open_eves_key");
        if (EBGStringUtils.isNotEmpty(isOpenEves)) {
            return PropertiesConstantsUtils.checkValueIsOn(isOpenEves);
        }
        GlobalConfigRepository globalConfigRepository = SpringContextUtil.getBean(GlobalConfigRepository.class);
        List<GlobalObjectParamConfig> globalObjectParamConfigs = globalConfigRepository.findBusinessConfigByCustomIDAndId(RequestContext.get().getTenantId(), "is_open_eves_key");
        if (!(globalObjectParamConfigs = globalObjectParamConfigs.stream().filter(o -> o.getObjectName().equals("receipt")).collect(Collectors.toList())).isEmpty()) {
            GlobalObjectParamConfig globalObjectParamConfig = globalObjectParamConfigs.get(0);
            if (globalConfigRepository != null) {
                try {
                    isOpenEves = globalObjectParamConfig.getAttrValue();
                }
                catch (Throwable e) {
                    isOpenEves = "off";
                }
            }
        }
        RequestContextUtils.setRunningParam("is_open_eves_key", isOpenEves);
        return PropertiesConstantsUtils.checkValueIsOn(isOpenEves);
    }

    public static boolean isSupportProxyDownload() {
        boolean receiptProxyDownloadSwitch = Objects.equals("true", RequestContextUtils.getBankParameterValue("receipt_proxy_download_switch"));
        return receiptProxyDownloadSwitch;
    }
}

