/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.receipt.common.framework.match;

import com.google.common.collect.Maps;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.ebg.egf.common.context.EBContext;
import kd.ebg.egf.common.utils.JsonUtil;
import kd.ebg.receipt.common.core.utils.EBGStringUtils;
import kd.ebg.receipt.common.framework.context.RequestContextUtils;
import kd.ebg.receipt.common.framework.frame.BankBundleManager;
import kd.ebg.receipt.common.model.receipt.DownloadListDetail;
import kd.sdk.annotation.SdkDeprecated;
import org.jdom2.Element;

public class MatchRule {
    private static final String entity = "receipt_bd_match_rule";
    private static final String properties = "id,number,name,match_rule,bank_version";
    private static final String match_param_entity = "receipt_bd_match_param";
    private static final String match_param_properties = "number,name,detail_param,receipt_param,ref_id";
    private static MatchRule instance;

    @SdkDeprecated
    public static synchronized MatchRule getInstance() {
        if (instance == null) {
            instance = new MatchRule();
        }
        return instance;
    }

    @SdkDeprecated
    public String getDetailJsonWithStructuredData(Element element) {
        HashMap jsonMap = Maps.newHashMapWithExpectedSize((int)8);
        if (element != null) {
            List children = element.getChildren();
            for (int i = 0; i < children.size(); ++i) {
                Element node = (Element)children.get(i);
                jsonMap.put(node.getName(), element.getChildTextTrim(node.getName()));
            }
        }
        return JsonUtil.toJson((Object)jsonMap);
    }

    @SdkDeprecated
    public String getDetailJsonWithNonStructuredData(String base, String content, String spliter) {
        HashMap jsonMap = Maps.newHashMapWithExpectedSize((int)8);
        if (EBGStringUtils.isNotEmpty(base) && EBGStringUtils.isNotEmpty(content)) {
            String[] BaseAttr = base.split(spliter);
            String[] items = content.split(spliter);
            for (int i = 0; i < BaseAttr.length; ++i) {
                jsonMap.put(BaseAttr[i], items[i]);
            }
        }
        return JsonUtil.toJson((Object)jsonMap);
    }

    @SdkDeprecated
    public String getReceiptMatchNo(String accNo, String transDate, String jsonStr) {
        Map matchRuleMap;
        String bankVersionId = EBContext.getContext().getBankVersionID();
        try {
            String cacheRuleKey = String.format("%s_match_rule", bankVersionId);
            String matchRuleMapJsonStr = RequestContextUtils.getRunningParam(cacheRuleKey);
            if (EBGStringUtils.isNotEmpty(matchRuleMapJsonStr)) {
                matchRuleMap = (Map)JsonUtil.fromJson((String)matchRuleMapJsonStr, Map.class);
            } else {
                matchRuleMap = this.getReceiptMatchRule(bankVersionId);
                RequestContextUtils.setRunningParam(cacheRuleKey, JsonUtil.toJson((Object)matchRuleMap));
            }
        }
        catch (Exception e) {
            matchRuleMap = this.getReceiptMatchRule(bankVersionId);
        }
        Map jsonMap = (Map)JsonUtil.fromJson((String)jsonStr, Map.class);
        for (Map.Entry entry : matchRuleMap.entrySet()) {
            if (((String)entry.getKey()).equals("accNo")) {
                matchRuleMap.put(entry.getKey(), accNo);
                continue;
            }
            if (((String)entry.getKey()).equals("transDate")) {
                matchRuleMap.put(entry.getKey(), transDate);
                continue;
            }
            if (((String)entry.getKey()).equals("baseMatchRule")) continue;
            if (jsonMap.containsKey(entry.getValue())) {
                matchRuleMap.put(entry.getKey(), jsonMap.get(entry.getValue()));
                continue;
            }
            matchRuleMap.put(entry.getKey(), "e");
        }
        StringBuilder receiptNo = new StringBuilder();
        String string = (String)matchRuleMap.get("baseMatchRule");
        if (EBGStringUtils.isNotEmpty(string)) {
            String[] baseMatchRules;
            for (String item : baseMatchRules = string.split("-")) {
                String value = (String)matchRuleMap.get(item);
                if (EBGStringUtils.isEmpty(value)) {
                    value = "e";
                }
                receiptNo.append(value).append("-");
            }
            String receiptNoStr = receiptNo.substring(0, receiptNo.length() - 1);
            return receiptNoStr;
        }
        return receiptNo.toString();
    }

    public Map<String, String> getReceiptMatchRule(String bankVersion) {
        Map<String, String> matchRuleMap = BankBundleManager.getInstance().getReceiptRule(bankVersion);
        String baseMatchRule = "accNo-oppAccNo-transDate-Amount-cdFlag-serialNo";
        QFilter filter = QFilter.of((String)"bank_version=? and number=? and trans_type=?", (Object[])new Object[]{bankVersion, "define", "0"});
        DynamicObject dynamicObject = BusinessDataServiceHelper.loadSingle((String)entity, (String)properties, (QFilter[])filter.toArray());
        if (dynamicObject == null) {
            filter = QFilter.of((String)"bank_version=? and number=?", (Object[])new Object[]{bankVersion, "define"});
            dynamicObject = BusinessDataServiceHelper.loadSingle((String)entity, (String)properties, (QFilter[])filter.toArray());
        }
        if (dynamicObject != null) {
            String refId = dynamicObject.getString("id");
            baseMatchRule = dynamicObject.getString("match_rule");
            filter = QFilter.of((String)"ref_id = ?", (Object[])new Object[]{refId});
            DynamicObject[] dynamicObjects = BusinessDataServiceHelper.load((String)match_param_entity, (String)match_param_properties, (QFilter[])filter.toArray());
            if (dynamicObjects != null && dynamicObjects.length > 0) {
                for (int i = 0; i < dynamicObjects.length; ++i) {
                    String matchParam = dynamicObjects[i].getString("number");
                    String detailParam = dynamicObjects[i].getString("receipt_param");
                    matchRuleMap.put(matchParam, detailParam);
                }
            }
        }
        matchRuleMap.put("baseMatchRule", baseMatchRule);
        HashMap newMatchRuleMap = Maps.newHashMapWithExpectedSize((int)1);
        newMatchRuleMap.putAll(matchRuleMap);
        return newMatchRuleMap;
    }

    public void handleMatchNoRepeat(Map<String, Integer> countMap, List<DownloadListDetail> downloadListDetails) {
        for (DownloadListDetail detail : downloadListDetails) {
            String receiptNo = detail.getDetailNo();
            if (countMap.containsKey(receiptNo)) {
                int count = countMap.get(receiptNo) + 1;
                countMap.put(receiptNo, count);
                receiptNo = receiptNo + "-" + String.format("%04d", count);
            } else {
                countMap.put(receiptNo, 0);
            }
            detail.setDetailNo(receiptNo);
        }
    }
}

